<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Forecast_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource Forecast Request References element for Get Resource Forecast web service
 * @subpackage Structs
 */
class Resource_Forecast_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Resource_Forecast_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Reference
     * - maxOccurs: unbounded
     * @var \StructType\Resource_ForecastObjectType[]
     */
    public $Resource_Forecast_Reference;
    /**
     * Constructor method for Resource_Forecast_Request_ReferencesType
     * @uses Resource_Forecast_Request_ReferencesType::setResource_Forecast_Reference()
     * @param \StructType\Resource_ForecastObjectType[] $resource_Forecast_Reference
     */
    public function __construct(array $resource_Forecast_Reference = array())
    {
        $this
            ->setResource_Forecast_Reference($resource_Forecast_Reference);
    }
    /**
     * Get Resource_Forecast_Reference value
     * @return \StructType\Resource_ForecastObjectType[]|null
     */
    public function getResource_Forecast_Reference()
    {
        return $this->Resource_Forecast_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Forecast_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Forecast_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Forecast_ReferenceForArrayConstraintsFromSetResource_Forecast_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Forecast_Request_ReferencesTypeResource_Forecast_ReferenceItem) {
            // validation for constraint: itemType
            if (!$resource_Forecast_Request_ReferencesTypeResource_Forecast_ReferenceItem instanceof \StructType\Resource_ForecastObjectType) {
                $invalidValues[] = is_object($resource_Forecast_Request_ReferencesTypeResource_Forecast_ReferenceItem) ? get_class($resource_Forecast_Request_ReferencesTypeResource_Forecast_ReferenceItem) : sprintf('%s(%s)', gettype($resource_Forecast_Request_ReferencesTypeResource_Forecast_ReferenceItem), var_export($resource_Forecast_Request_ReferencesTypeResource_Forecast_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Forecast_Reference property can only contain items of type \StructType\Resource_ForecastObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Forecast_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ForecastObjectType[] $resource_Forecast_Reference
     * @return \StructType\Resource_Forecast_Request_ReferencesType
     */
    public function setResource_Forecast_Reference(array $resource_Forecast_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Forecast_ReferenceArrayErrorMessage = self::validateResource_Forecast_ReferenceForArrayConstraintsFromSetResource_Forecast_Reference($resource_Forecast_Reference))) {
            throw new \InvalidArgumentException($resource_Forecast_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Resource_Forecast_Reference = $resource_Forecast_Reference;
        return $this;
    }
    /**
     * Add item to Resource_Forecast_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ForecastObjectType $item
     * @return \StructType\Resource_Forecast_Request_ReferencesType
     */
    public function addToResource_Forecast_Reference(\StructType\Resource_ForecastObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ForecastObjectType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Forecast_Reference property can only contain items of type \StructType\Resource_ForecastObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Forecast_Reference[] = $item;
        return $this;
    }
}
