<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_ForecastType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains Resource Forecast Details such as Resource Forecast Lines and Resource Forecast Allocations.
 * @subpackage Structs
 */
class Resource_ForecastType extends AbstractStructBase
{
    /**
     * The Resource_Forecast_ID
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Forecast_ID;
    /**
     * The Resource_Forecast_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Reference
     * - minOccurs: 0
     * @var \StructType\Resource_ForecastObjectType
     */
    public $Resource_Forecast_Reference;
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast for Project
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Resource_Forecast_Configuration_Data
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Configuration Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Forecast_Configuration_Get_Webservice_DataType[]
     */
    public $Resource_Forecast_Configuration_Data;
    /**
     * The Resource_Forecast_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Line Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Forecast_Line_View_Get_WebserviceType[]
     */
    public $Resource_Forecast_Line_Data;
    /**
     * Constructor method for Resource_ForecastType
     * @uses Resource_ForecastType::setResource_Forecast_ID()
     * @uses Resource_ForecastType::setResource_Forecast_Reference()
     * @uses Resource_ForecastType::setProject_Reference()
     * @uses Resource_ForecastType::setResource_Forecast_Configuration_Data()
     * @uses Resource_ForecastType::setResource_Forecast_Line_Data()
     * @param string $resource_Forecast_ID
     * @param \StructType\Resource_ForecastObjectType $resource_Forecast_Reference
     * @param \StructType\ProjectObjectType $project_Reference
     * @param \StructType\Resource_Forecast_Configuration_Get_Webservice_DataType[] $resource_Forecast_Configuration_Data
     * @param \StructType\Resource_Forecast_Line_View_Get_WebserviceType[] $resource_Forecast_Line_Data
     */
    public function __construct($resource_Forecast_ID = null, \StructType\Resource_ForecastObjectType $resource_Forecast_Reference = null, \StructType\ProjectObjectType $project_Reference = null, array $resource_Forecast_Configuration_Data = array(), array $resource_Forecast_Line_Data = array())
    {
        $this
            ->setResource_Forecast_ID($resource_Forecast_ID)
            ->setResource_Forecast_Reference($resource_Forecast_Reference)
            ->setProject_Reference($project_Reference)
            ->setResource_Forecast_Configuration_Data($resource_Forecast_Configuration_Data)
            ->setResource_Forecast_Line_Data($resource_Forecast_Line_Data);
    }
    /**
     * Get Resource_Forecast_ID value
     * @return string|null
     */
    public function getResource_Forecast_ID()
    {
        return $this->Resource_Forecast_ID;
    }
    /**
     * Set Resource_Forecast_ID value
     * @param string $resource_Forecast_ID
     * @return \StructType\Resource_ForecastType
     */
    public function setResource_Forecast_ID($resource_Forecast_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Forecast_ID) && !is_string($resource_Forecast_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Forecast_ID, true), gettype($resource_Forecast_ID)), __LINE__);
        }
        $this->Resource_Forecast_ID = $resource_Forecast_ID;
        return $this;
    }
    /**
     * Get Resource_Forecast_Reference value
     * @return \StructType\Resource_ForecastObjectType|null
     */
    public function getResource_Forecast_Reference()
    {
        return $this->Resource_Forecast_Reference;
    }
    /**
     * Set Resource_Forecast_Reference value
     * @param \StructType\Resource_ForecastObjectType $resource_Forecast_Reference
     * @return \StructType\Resource_ForecastType
     */
    public function setResource_Forecast_Reference(\StructType\Resource_ForecastObjectType $resource_Forecast_Reference = null)
    {
        $this->Resource_Forecast_Reference = $resource_Forecast_Reference;
        return $this;
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Resource_ForecastType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Resource_Forecast_Configuration_Data value
     * @return \StructType\Resource_Forecast_Configuration_Get_Webservice_DataType[]|null
     */
    public function getResource_Forecast_Configuration_Data()
    {
        return $this->Resource_Forecast_Configuration_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Forecast_Configuration_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Forecast_Configuration_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Forecast_Configuration_DataForArrayConstraintsFromSetResource_Forecast_Configuration_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_ForecastTypeResource_Forecast_Configuration_DataItem) {
            // validation for constraint: itemType
            if (!$resource_ForecastTypeResource_Forecast_Configuration_DataItem instanceof \StructType\Resource_Forecast_Configuration_Get_Webservice_DataType) {
                $invalidValues[] = is_object($resource_ForecastTypeResource_Forecast_Configuration_DataItem) ? get_class($resource_ForecastTypeResource_Forecast_Configuration_DataItem) : sprintf('%s(%s)', gettype($resource_ForecastTypeResource_Forecast_Configuration_DataItem), var_export($resource_ForecastTypeResource_Forecast_Configuration_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Forecast_Configuration_Data property can only contain items of type \StructType\Resource_Forecast_Configuration_Get_Webservice_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Forecast_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Forecast_Configuration_Get_Webservice_DataType[] $resource_Forecast_Configuration_Data
     * @return \StructType\Resource_ForecastType
     */
    public function setResource_Forecast_Configuration_Data(array $resource_Forecast_Configuration_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Forecast_Configuration_DataArrayErrorMessage = self::validateResource_Forecast_Configuration_DataForArrayConstraintsFromSetResource_Forecast_Configuration_Data($resource_Forecast_Configuration_Data))) {
            throw new \InvalidArgumentException($resource_Forecast_Configuration_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Forecast_Configuration_Data = $resource_Forecast_Configuration_Data;
        return $this;
    }
    /**
     * Add item to Resource_Forecast_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Forecast_Configuration_Get_Webservice_DataType $item
     * @return \StructType\Resource_ForecastType
     */
    public function addToResource_Forecast_Configuration_Data(\StructType\Resource_Forecast_Configuration_Get_Webservice_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Forecast_Configuration_Get_Webservice_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Forecast_Configuration_Data property can only contain items of type \StructType\Resource_Forecast_Configuration_Get_Webservice_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Forecast_Configuration_Data[] = $item;
        return $this;
    }
    /**
     * Get Resource_Forecast_Line_Data value
     * @return \StructType\Resource_Forecast_Line_View_Get_WebserviceType[]|null
     */
    public function getResource_Forecast_Line_Data()
    {
        return $this->Resource_Forecast_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Forecast_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Forecast_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Forecast_Line_DataForArrayConstraintsFromSetResource_Forecast_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_ForecastTypeResource_Forecast_Line_DataItem) {
            // validation for constraint: itemType
            if (!$resource_ForecastTypeResource_Forecast_Line_DataItem instanceof \StructType\Resource_Forecast_Line_View_Get_WebserviceType) {
                $invalidValues[] = is_object($resource_ForecastTypeResource_Forecast_Line_DataItem) ? get_class($resource_ForecastTypeResource_Forecast_Line_DataItem) : sprintf('%s(%s)', gettype($resource_ForecastTypeResource_Forecast_Line_DataItem), var_export($resource_ForecastTypeResource_Forecast_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Forecast_Line_Data property can only contain items of type \StructType\Resource_Forecast_Line_View_Get_WebserviceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Forecast_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Forecast_Line_View_Get_WebserviceType[] $resource_Forecast_Line_Data
     * @return \StructType\Resource_ForecastType
     */
    public function setResource_Forecast_Line_Data(array $resource_Forecast_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Forecast_Line_DataArrayErrorMessage = self::validateResource_Forecast_Line_DataForArrayConstraintsFromSetResource_Forecast_Line_Data($resource_Forecast_Line_Data))) {
            throw new \InvalidArgumentException($resource_Forecast_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Forecast_Line_Data = $resource_Forecast_Line_Data;
        return $this;
    }
    /**
     * Add item to Resource_Forecast_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Forecast_Line_View_Get_WebserviceType $item
     * @return \StructType\Resource_ForecastType
     */
    public function addToResource_Forecast_Line_Data(\StructType\Resource_Forecast_Line_View_Get_WebserviceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Forecast_Line_View_Get_WebserviceType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Forecast_Line_Data property can only contain items of type \StructType\Resource_Forecast_Line_View_Get_WebserviceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Forecast_Line_Data[] = $item;
        return $this;
    }
}
