<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Template_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Request References element contains the specific instance set that should be returned in the Get operation. Either a Reference ID or the Workday ID (GUID) should be specified for each instance to be returned.
 * @subpackage Structs
 */
class Requisition_Template_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Requisition_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Requisition Template
     * - maxOccurs: unbounded
     * @var \StructType\Requisition_TemplateObjectType[]
     */
    public $Requisition_Template_Reference;
    /**
     * Constructor method for Requisition_Template_Request_ReferencesType
     * @uses Requisition_Template_Request_ReferencesType::setRequisition_Template_Reference()
     * @param \StructType\Requisition_TemplateObjectType[] $requisition_Template_Reference
     */
    public function __construct(array $requisition_Template_Reference = array())
    {
        $this
            ->setRequisition_Template_Reference($requisition_Template_Reference);
    }
    /**
     * Get Requisition_Template_Reference value
     * @return \StructType\Requisition_TemplateObjectType[]|null
     */
    public function getRequisition_Template_Reference()
    {
        return $this->Requisition_Template_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Template_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Template_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Template_ReferenceForArrayConstraintsFromSetRequisition_Template_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Template_Request_ReferencesTypeRequisition_Template_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Template_Request_ReferencesTypeRequisition_Template_ReferenceItem instanceof \StructType\Requisition_TemplateObjectType) {
                $invalidValues[] = is_object($requisition_Template_Request_ReferencesTypeRequisition_Template_ReferenceItem) ? get_class($requisition_Template_Request_ReferencesTypeRequisition_Template_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Template_Request_ReferencesTypeRequisition_Template_ReferenceItem), var_export($requisition_Template_Request_ReferencesTypeRequisition_Template_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Template_Reference property can only contain items of type \StructType\Requisition_TemplateObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Template_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TemplateObjectType[] $requisition_Template_Reference
     * @return \StructType\Requisition_Template_Request_ReferencesType
     */
    public function setRequisition_Template_Reference(array $requisition_Template_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Template_ReferenceArrayErrorMessage = self::validateRequisition_Template_ReferenceForArrayConstraintsFromSetRequisition_Template_Reference($requisition_Template_Reference))) {
            throw new \InvalidArgumentException($requisition_Template_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Template_Reference = $requisition_Template_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Template_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TemplateObjectType $item
     * @return \StructType\Requisition_Template_Request_ReferencesType
     */
    public function addToRequisition_Template_Reference(\StructType\Requisition_TemplateObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_TemplateObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Template_Reference property can only contain items of type \StructType\Requisition_TemplateObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Template_Reference[] = $item;
        return $this;
    }
}
