<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Template_Goods_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't select Supplier Contract as a Fulfillment Source on this transaction type. | Only one worktag for each type is allowed for each document line. | Supplier Item Identifiers cannot be set or updated for lines with no items or
 * having non-catalog items. Catalog Items also have Supplier Item Identifiers, but we cannot change the existing value using this web service. For this web service, Web items will not trigger this validation, but any entered Supplier Item Identifier
 * will be ignored and the original value from the web item will be kept. | Quantity cannot be negative | Quantity must be greater than zero and cannot be partial when the document line's spend category is Tracked (unless related to a supplier contract
 * line). | Spend Category is required. | Item Description is Required | Element containing all Requisition Goods Line data. A Requisition may have multiple Goods Lines.
 * @subpackage Structs
 */
class Requisition_Template_Goods_Line_DataType extends AbstractStructBase
{
    /**
     * The Requisition_Template_Goods_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of an existing Goods Requisition Line
     * - minOccurs: 0
     * @var \StructType\Item_Requisition_LineObjectType
     */
    public $Requisition_Template_Goods_Line_Reference;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company at the line level that has an intercompany relationship with the company at the header level.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of an Item on the Requisition.
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Line_Item_Description
     * Meta information extracted from the WSDL
     * - documentation: An optional description of the item, especially useful if only a Spend Category is selected for this line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Item_Description;
    /**
     * The Supplier_Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: The supplier item identifier for a Requisition Goods Line
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Item_Identifier;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Spend Category Usage Type for this Spend Category must be Procurement. | Reference to the Spend Category. The Spend Category will default from the Purchase Item if the item is specified. This Spend Category must match the Spend
     * Category for the Purchase Item.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Requisition_Fulfillment_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to Fulfillment source on Requisition goods Line.
     * - minOccurs: 0
     * @var \StructType\Requisition_SourceObjectType
     */
    public $Requisition_Fulfillment_Source_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to an existing Supplier
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Reference
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Order_From_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a valid Order-From Supplier Connection
     * - minOccurs: 0
     * @var \StructType\Order_From_Supplier_ConnectionObjectType
     */
    public $Order_From_Connection_Reference;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_Of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Unit of Measure
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_Of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Address Reference for an existing Ship-To Address. If not specified on the Requisition Line, Workday will default the Ship-To Address Reference from the Requisition Header.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker, who will be the designated Ship-To contact. If not specified on the Requisition Line, Workday will default the Requisition Requester as the Ship-To Contact.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Location, where the Goods or Services will be delivered. If not specified on the Requisition Line, Workday will default the workspace or the business site of the Requisition Worker as the Deliver-To Location.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Requisition Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Requisition_Template_Goods_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_Split_DataType[]
     */
    public $Requisition_Template_Goods_Line_Split_Data;
    /**
     * Constructor method for Requisition_Template_Goods_Line_DataType
     * @uses Requisition_Template_Goods_Line_DataType::setRequisition_Template_Goods_Line_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setLine_Company_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setItem_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setLine_Item_Description()
     * @uses Requisition_Template_Goods_Line_DataType::setSupplier_Item_Identifier()
     * @uses Requisition_Template_Goods_Line_DataType::setSpend_Category_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setRequisition_Fulfillment_Source_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setSupplier_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setSupplier_Contract_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setOrder_From_Connection_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setQuantity()
     * @uses Requisition_Template_Goods_Line_DataType::setUnit_Of_Measure_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setUnit_Cost()
     * @uses Requisition_Template_Goods_Line_DataType::setExtended_Amount()
     * @uses Requisition_Template_Goods_Line_DataType::setShip_To_Address_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setShip_To_Contact_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setDeliver_To_Location_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setMemo()
     * @uses Requisition_Template_Goods_Line_DataType::setWorktag_Reference()
     * @uses Requisition_Template_Goods_Line_DataType::setRequisition_Template_Goods_Line_Split_Data()
     * @param \StructType\Item_Requisition_LineObjectType $requisition_Template_Goods_Line_Reference
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @param string $line_Item_Description
     * @param string $supplier_Item_Identifier
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_Of_Measure_Reference
     * @param float $unit_Cost
     * @param float $extended_Amount
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param string $memo
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @param \StructType\Business_Document_Line_Split_DataType[] $requisition_Template_Goods_Line_Split_Data
     */
    public function __construct(\StructType\Item_Requisition_LineObjectType $requisition_Template_Goods_Line_Reference = null, \StructType\CompanyObjectType $line_Company_Reference = null, \StructType\Procurement_ItemObjectType $item_Reference = null, $line_Item_Description = null, $supplier_Item_Identifier = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_Of_Measure_Reference = null, $unit_Cost = null, $extended_Amount = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, $memo = null, array $worktag_Reference = array(), array $requisition_Template_Goods_Line_Split_Data = array())
    {
        $this
            ->setRequisition_Template_Goods_Line_Reference($requisition_Template_Goods_Line_Reference)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setItem_Reference($item_Reference)
            ->setLine_Item_Description($line_Item_Description)
            ->setSupplier_Item_Identifier($supplier_Item_Identifier)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setRequisition_Fulfillment_Source_Reference($requisition_Fulfillment_Source_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setOrder_From_Connection_Reference($order_From_Connection_Reference)
            ->setQuantity($quantity)
            ->setUnit_Of_Measure_Reference($unit_Of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setExtended_Amount($extended_Amount)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setMemo($memo)
            ->setWorktag_Reference($worktag_Reference)
            ->setRequisition_Template_Goods_Line_Split_Data($requisition_Template_Goods_Line_Split_Data);
    }
    /**
     * Get Requisition_Template_Goods_Line_Reference value
     * @return \StructType\Item_Requisition_LineObjectType|null
     */
    public function getRequisition_Template_Goods_Line_Reference()
    {
        return $this->Requisition_Template_Goods_Line_Reference;
    }
    /**
     * Set Requisition_Template_Goods_Line_Reference value
     * @param \StructType\Item_Requisition_LineObjectType $requisition_Template_Goods_Line_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setRequisition_Template_Goods_Line_Reference(\StructType\Item_Requisition_LineObjectType $requisition_Template_Goods_Line_Reference = null)
    {
        $this->Requisition_Template_Goods_Line_Reference = $requisition_Template_Goods_Line_Reference;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setItem_Reference(\StructType\Procurement_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Line_Item_Description value
     * @return string|null
     */
    public function getLine_Item_Description()
    {
        return $this->Line_Item_Description;
    }
    /**
     * Set Line_Item_Description value
     * @param string $line_Item_Description
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setLine_Item_Description($line_Item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($line_Item_Description) && !is_string($line_Item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Item_Description, true), gettype($line_Item_Description)), __LINE__);
        }
        $this->Line_Item_Description = $line_Item_Description;
        return $this;
    }
    /**
     * Get Supplier_Item_Identifier value
     * @return string|null
     */
    public function getSupplier_Item_Identifier()
    {
        return $this->Supplier_Item_Identifier;
    }
    /**
     * Set Supplier_Item_Identifier value
     * @param string $supplier_Item_Identifier
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setSupplier_Item_Identifier($supplier_Item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Item_Identifier) && !is_string($supplier_Item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Item_Identifier, true), gettype($supplier_Item_Identifier)), __LINE__);
        }
        $this->Supplier_Item_Identifier = $supplier_Item_Identifier;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Requisition_Fulfillment_Source_Reference value
     * @return \StructType\Requisition_SourceObjectType|null
     */
    public function getRequisition_Fulfillment_Source_Reference()
    {
        return $this->Requisition_Fulfillment_Source_Reference;
    }
    /**
     * Set Requisition_Fulfillment_Source_Reference value
     * @param \StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setRequisition_Fulfillment_Source_Reference(\StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference = null)
    {
        $this->Requisition_Fulfillment_Source_Reference = $requisition_Fulfillment_Source_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Order_From_Connection_Reference value
     * @return \StructType\Order_From_Supplier_ConnectionObjectType|null
     */
    public function getOrder_From_Connection_Reference()
    {
        return $this->{'Order-From_Connection_Reference'};
    }
    /**
     * Set Order_From_Connection_Reference value
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setOrder_From_Connection_Reference(\StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference = null)
    {
        $this->Order_From_Connection_Reference = $this->{'Order-From_Connection_Reference'} = $order_From_Connection_Reference;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_Of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_Of_Measure_Reference()
    {
        return $this->Unit_Of_Measure_Reference;
    }
    /**
     * Set Unit_Of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_Of_Measure_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setUnit_Of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_Of_Measure_Reference = null)
    {
        $this->Unit_Of_Measure_Reference = $unit_Of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->{'Ship-To_Contact_Reference'};
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $this->{'Ship-To_Contact_Reference'} = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->{'Deliver-To_Location_Reference'};
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $this->{'Deliver-To_Location_Reference'} = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Template_Goods_Line_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Template_Goods_Line_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($requisition_Template_Goods_Line_DataTypeWorktag_ReferenceItem) ? get_class($requisition_Template_Goods_Line_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Template_Goods_Line_DataTypeWorktag_ReferenceItem), var_export($requisition_Template_Goods_Line_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Template_Goods_Line_Split_Data value
     * @return \StructType\Business_Document_Line_Split_DataType[]|null
     */
    public function getRequisition_Template_Goods_Line_Split_Data()
    {
        return $this->Requisition_Template_Goods_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Template_Goods_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Template_Goods_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Template_Goods_Line_Split_DataForArrayConstraintsFromSetRequisition_Template_Goods_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Template_Goods_Line_DataTypeRequisition_Template_Goods_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_Template_Goods_Line_DataTypeRequisition_Template_Goods_Line_Split_DataItem instanceof \StructType\Business_Document_Line_Split_DataType) {
                $invalidValues[] = is_object($requisition_Template_Goods_Line_DataTypeRequisition_Template_Goods_Line_Split_DataItem) ? get_class($requisition_Template_Goods_Line_DataTypeRequisition_Template_Goods_Line_Split_DataItem) : sprintf('%s(%s)', gettype($requisition_Template_Goods_Line_DataTypeRequisition_Template_Goods_Line_Split_DataItem), var_export($requisition_Template_Goods_Line_DataTypeRequisition_Template_Goods_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Template_Goods_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Template_Goods_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType[] $requisition_Template_Goods_Line_Split_Data
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function setRequisition_Template_Goods_Line_Split_Data(array $requisition_Template_Goods_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Template_Goods_Line_Split_DataArrayErrorMessage = self::validateRequisition_Template_Goods_Line_Split_DataForArrayConstraintsFromSetRequisition_Template_Goods_Line_Split_Data($requisition_Template_Goods_Line_Split_Data))) {
            throw new \InvalidArgumentException($requisition_Template_Goods_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Template_Goods_Line_Split_Data = $requisition_Template_Goods_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Requisition_Template_Goods_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType $item
     * @return \StructType\Requisition_Template_Goods_Line_DataType
     */
    public function addToRequisition_Template_Goods_Line_Split_Data(\StructType\Business_Document_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Template_Goods_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Template_Goods_Line_Split_Data[] = $item;
        return $this;
    }
}
