<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Sourcing_Rule_Supplier_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the contents of a supplier requisition sourcing rule
 * @subpackage Structs
 */
class Requisition_Sourcing_Rule_Supplier_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the supplier sourcing rule
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these companies or company hierarchies to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these spend categories or spend category Hierarchies to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Category_or_HierarchyObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these Ship-To Addresses to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Ship_To_Address_Reference;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these purchase items to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType[]
     */
    public $Purchase_Item_Reference;
    /**
     * The Contract_Required
     * Meta information extracted from the WSDL
     * - documentation: If true, must have a valid contract line that matches to apply this rule.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Contract_Required;
    /**
     * The Resulting_Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resulting Supplier to apply for Requisition Sourcing if criteria is matched.
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Resulting_Supplier_Reference;
    /**
     * Constructor method for Requisition_Sourcing_Rule_Supplier_DataType
     * @uses Requisition_Sourcing_Rule_Supplier_DataType::setID()
     * @uses Requisition_Sourcing_Rule_Supplier_DataType::setCompany_Reference()
     * @uses Requisition_Sourcing_Rule_Supplier_DataType::setSpend_Category_Reference()
     * @uses Requisition_Sourcing_Rule_Supplier_DataType::setShip_To_Address_Reference()
     * @uses Requisition_Sourcing_Rule_Supplier_DataType::setPurchase_Item_Reference()
     * @uses Requisition_Sourcing_Rule_Supplier_DataType::setContract_Required()
     * @uses Requisition_Sourcing_Rule_Supplier_DataType::setResulting_Supplier_Reference()
     * @param string $iD
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_Reference
     * @param \StructType\Unique_IdentifierObjectType[] $ship_To_Address_Reference
     * @param \StructType\Purchase_ItemObjectType[] $purchase_Item_Reference
     * @param bool $contract_Required
     * @param \StructType\Resource_ProviderObjectType $resulting_Supplier_Reference
     */
    public function __construct($iD = null, array $company_Reference = array(), array $spend_Category_Reference = array(), array $ship_To_Address_Reference = array(), array $purchase_Item_Reference = array(), $contract_Required = null, \StructType\Resource_ProviderObjectType $resulting_Supplier_Reference = null)
    {
        $this
            ->setID($iD)
            ->setCompany_Reference($company_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setContract_Required($contract_Required)
            ->setResulting_Supplier_Reference($resulting_Supplier_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Supplier_DataTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Supplier_DataTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Supplier_DataTypeCompany_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Supplier_DataTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Supplier_DataTypeCompany_ReferenceItem), var_export($requisition_Sourcing_Rule_Supplier_DataTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_Category_or_HierarchyObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Supplier_DataTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Supplier_DataTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Supplier_DataTypeSpend_Category_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Supplier_DataTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Supplier_DataTypeSpend_Category_ReferenceItem), var_export($requisition_Sourcing_Rule_Supplier_DataTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_Category_or_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * This method is responsible for validating the values passed to the setShip_To_Address_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShip_To_Address_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShip_To_Address_ReferenceForArrayConstraintsFromSetShip_To_Address_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Supplier_DataTypeShip_To_Address_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Supplier_DataTypeShip_To_Address_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Supplier_DataTypeShip_To_Address_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Supplier_DataTypeShip_To_Address_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Supplier_DataTypeShip_To_Address_ReferenceItem), var_export($requisition_Sourcing_Rule_Supplier_DataTypeShip_To_Address_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ship_To_Address_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $ship_To_Address_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function setShip_To_Address_Reference(array $ship_To_Address_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($ship_To_Address_ReferenceArrayErrorMessage = self::validateShip_To_Address_ReferenceForArrayConstraintsFromSetShip_To_Address_Reference($ship_To_Address_Reference))) {
            throw new \InvalidArgumentException($ship_To_Address_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Add item to Ship_To_Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function addToShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Ship_To_Address_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ship_To_Address_Reference[] = $this->{'Ship-To_Address_Reference'}[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType[]|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_ReferenceForArrayConstraintsFromSetPurchase_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Supplier_DataTypePurchase_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Supplier_DataTypePurchase_Item_ReferenceItem instanceof \StructType\Purchase_ItemObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Supplier_DataTypePurchase_Item_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Supplier_DataTypePurchase_Item_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Supplier_DataTypePurchase_Item_ReferenceItem), var_export($requisition_Sourcing_Rule_Supplier_DataTypePurchase_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType[] $purchase_Item_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function setPurchase_Item_Reference(array $purchase_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_ReferenceArrayErrorMessage = self::validatePurchase_Item_ReferenceForArrayConstraintsFromSetPurchase_Item_Reference($purchase_Item_Reference))) {
            throw new \InvalidArgumentException($purchase_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function addToPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Reference[] = $item;
        return $this;
    }
    /**
     * Get Contract_Required value
     * @return bool|null
     */
    public function getContract_Required()
    {
        return $this->Contract_Required;
    }
    /**
     * Set Contract_Required value
     * @param bool $contract_Required
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function setContract_Required($contract_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($contract_Required) && !is_bool($contract_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contract_Required, true), gettype($contract_Required)), __LINE__);
        }
        $this->Contract_Required = $contract_Required;
        return $this;
    }
    /**
     * Get Resulting_Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getResulting_Supplier_Reference()
    {
        return $this->Resulting_Supplier_Reference;
    }
    /**
     * Set Resulting_Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $resulting_Supplier_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Supplier_DataType
     */
    public function setResulting_Supplier_Reference(\StructType\Resource_ProviderObjectType $resulting_Supplier_Reference = null)
    {
        $this->Resulting_Supplier_Reference = $resulting_Supplier_Reference;
        return $this;
    }
}
