<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Sourcing_Rule_Order_Connection_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the contents of an order-from connection requisition sourcing rule
 * @subpackage Structs
 */
class Requisition_Sourcing_Rule_Order_Connection_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the order-from connection sourcing rule
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match this supplier to apply this rule.
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these companies or company hierarchies to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Purchase_Order_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these order types to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Order_TypeObjectType[]
     */
    public $Purchase_Order_Type_Reference;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these Ship-To Addresses to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Ship_To_Address_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these spend categories or spend category Hierarchies to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Category_or_HierarchyObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * The Resulting_Order_From_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resulting order-from connection to apply to sourcing if criteria is matched.
     * @var \StructType\Order_From_Supplier_ConnectionObjectType
     */
    public $Resulting_Order_From_Connection_Reference;
    /**
     * Constructor method for Requisition_Sourcing_Rule_Order_Connection_DataType
     * @uses Requisition_Sourcing_Rule_Order_Connection_DataType::setID()
     * @uses Requisition_Sourcing_Rule_Order_Connection_DataType::setSupplier_Reference()
     * @uses Requisition_Sourcing_Rule_Order_Connection_DataType::setCompany_Reference()
     * @uses Requisition_Sourcing_Rule_Order_Connection_DataType::setPurchase_Order_Type_Reference()
     * @uses Requisition_Sourcing_Rule_Order_Connection_DataType::setShip_To_Address_Reference()
     * @uses Requisition_Sourcing_Rule_Order_Connection_DataType::setSpend_Category_Reference()
     * @uses Requisition_Sourcing_Rule_Order_Connection_DataType::setResulting_Order_From_Connection_Reference()
     * @param string $iD
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Order_TypeObjectType[] $purchase_Order_Type_Reference
     * @param \StructType\Unique_IdentifierObjectType[] $ship_To_Address_Reference
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_Reference
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $resulting_Order_From_Connection_Reference
     */
    public function __construct($iD = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, array $company_Reference = array(), array $purchase_Order_Type_Reference = array(), array $ship_To_Address_Reference = array(), array $spend_Category_Reference = array(), \StructType\Order_From_Supplier_ConnectionObjectType $resulting_Order_From_Connection_Reference = null)
    {
        $this
            ->setID($iD)
            ->setSupplier_Reference($supplier_Reference)
            ->setCompany_Reference($company_Reference)
            ->setPurchase_Order_Type_Reference($purchase_Order_Type_Reference)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setResulting_Order_From_Connection_Reference($resulting_Order_From_Connection_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Order_Connection_DataTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Order_Connection_DataTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Order_Connection_DataTypeCompany_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Order_Connection_DataTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Order_Connection_DataTypeCompany_ReferenceItem), var_export($requisition_Sourcing_Rule_Order_Connection_DataTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Order_Type_Reference value
     * @return \StructType\Order_TypeObjectType[]|null
     */
    public function getPurchase_Order_Type_Reference()
    {
        return $this->Purchase_Order_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Type_ReferenceForArrayConstraintsFromSetPurchase_Order_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Order_Connection_DataTypePurchase_Order_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Order_Connection_DataTypePurchase_Order_Type_ReferenceItem instanceof \StructType\Order_TypeObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Order_Connection_DataTypePurchase_Order_Type_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Order_Connection_DataTypePurchase_Order_Type_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Order_Connection_DataTypePurchase_Order_Type_ReferenceItem), var_export($requisition_Sourcing_Rule_Order_Connection_DataTypePurchase_Order_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Type_Reference property can only contain items of type \StructType\Order_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_TypeObjectType[] $purchase_Order_Type_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function setPurchase_Order_Type_Reference(array $purchase_Order_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Type_ReferenceArrayErrorMessage = self::validatePurchase_Order_Type_ReferenceForArrayConstraintsFromSetPurchase_Order_Type_Reference($purchase_Order_Type_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Type_Reference = $purchase_Order_Type_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_TypeObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function addToPurchase_Order_Type_Reference(\StructType\Order_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Type_Reference property can only contain items of type \StructType\Order_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * This method is responsible for validating the values passed to the setShip_To_Address_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShip_To_Address_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShip_To_Address_ReferenceForArrayConstraintsFromSetShip_To_Address_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Order_Connection_DataTypeShip_To_Address_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Order_Connection_DataTypeShip_To_Address_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Order_Connection_DataTypeShip_To_Address_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Order_Connection_DataTypeShip_To_Address_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Order_Connection_DataTypeShip_To_Address_ReferenceItem), var_export($requisition_Sourcing_Rule_Order_Connection_DataTypeShip_To_Address_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ship_To_Address_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $ship_To_Address_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function setShip_To_Address_Reference(array $ship_To_Address_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($ship_To_Address_ReferenceArrayErrorMessage = self::validateShip_To_Address_ReferenceForArrayConstraintsFromSetShip_To_Address_Reference($ship_To_Address_Reference))) {
            throw new \InvalidArgumentException($ship_To_Address_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Add item to Ship_To_Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function addToShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Ship_To_Address_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ship_To_Address_Reference[] = $this->{'Ship-To_Address_Reference'}[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_Category_or_HierarchyObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Order_Connection_DataTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Order_Connection_DataTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Order_Connection_DataTypeSpend_Category_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Order_Connection_DataTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Order_Connection_DataTypeSpend_Category_ReferenceItem), var_export($requisition_Sourcing_Rule_Order_Connection_DataTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_Category_or_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Resulting_Order_From_Connection_Reference value
     * @return \StructType\Order_From_Supplier_ConnectionObjectType|null
     */
    public function getResulting_Order_From_Connection_Reference()
    {
        return $this->{'Resulting_Order-From_Connection_Reference'};
    }
    /**
     * Set Resulting_Order_From_Connection_Reference value
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $resulting_Order_From_Connection_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Order_Connection_DataType
     */
    public function setResulting_Order_From_Connection_Reference(\StructType\Order_From_Supplier_ConnectionObjectType $resulting_Order_From_Connection_Reference = null)
    {
        $this->Resulting_Order_From_Connection_Reference = $this->{'Resulting_Order-From_Connection_Reference'} = $resulting_Order_From_Connection_Reference;
        return $this;
    }
}
