<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Sourcing_Rule_Buyer_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the contents of a buyer requisition sourcing rule
 * @subpackage Structs
 */
class Requisition_Sourcing_Rule_Buyer_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the buyer sourcing rule
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these companies or company hierarchies to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these Ship-To Addresses to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Ship_To_Address_Reference;
    /**
     * The Active_Location_or_Location_Hierarchy_for_Procurement_Reference
     * Meta information extracted from the WSDL
     * - documentation: Active Deliver-To Locations or Location Hierarchies that must match to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Location_or_Location_HierarchyObjectType[]
     */
    public $Active_Location_or_Location_Hierarchy_for_Procurement_Reference;
    /**
     * The Requisition_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requisition Types that must match to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_TypeObjectType[]
     */
    public $Requisition_Type_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these spend categories or spend category Hierarchies to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Category_or_HierarchyObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Suppliers that must match to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Resulting_Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: The resulting buyer to set on the requisition if the requisition rule criteria is met. If empty, then Use submitted by worker, or requisition sourcing buyer will be used.
     * - choice: Resulting_Buyer_Reference | Use_Submitted_by_Worker_on_Requisition_as_Buyer | Use_Requisition_Sourcing_Buyer
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\WorkerObjectType
     */
    public $Resulting_Buyer_Reference;
    /**
     * The Use_Submitted_by_Worker_on_Requisition_as_Buyer
     * Meta information extracted from the WSDL
     * - documentation: Use submitted by worker on the requisition as the resulting buyer if the requisition rule criteria is met.
     * - choice: Resulting_Buyer_Reference | Use_Submitted_by_Worker_on_Requisition_as_Buyer | Use_Requisition_Sourcing_Buyer
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Use_Submitted_by_Worker_on_Requisition_as_Buyer;
    /**
     * The Use_Requisition_Sourcing_Buyer
     * Meta information extracted from the WSDL
     * - documentation: Use sourcing buyer on the requisition as the resulting buyer if the requisition rule criteria is met.
     * - choice: Resulting_Buyer_Reference | Use_Submitted_by_Worker_on_Requisition_as_Buyer | Use_Requisition_Sourcing_Buyer
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Use_Requisition_Sourcing_Buyer;
    /**
     * Constructor method for Requisition_Sourcing_Rule_Buyer_DataType
     * @uses Requisition_Sourcing_Rule_Buyer_DataType::setID()
     * @uses Requisition_Sourcing_Rule_Buyer_DataType::setCompany_Reference()
     * @uses Requisition_Sourcing_Rule_Buyer_DataType::setShip_To_Address_Reference()
     * @uses Requisition_Sourcing_Rule_Buyer_DataType::setActive_Location_or_Location_Hierarchy_for_Procurement_Reference()
     * @uses Requisition_Sourcing_Rule_Buyer_DataType::setRequisition_Type_Reference()
     * @uses Requisition_Sourcing_Rule_Buyer_DataType::setSpend_Category_Reference()
     * @uses Requisition_Sourcing_Rule_Buyer_DataType::setSupplier_Reference()
     * @uses Requisition_Sourcing_Rule_Buyer_DataType::setResulting_Buyer_Reference()
     * @uses Requisition_Sourcing_Rule_Buyer_DataType::setUse_Submitted_by_Worker_on_Requisition_as_Buyer()
     * @uses Requisition_Sourcing_Rule_Buyer_DataType::setUse_Requisition_Sourcing_Buyer()
     * @param string $iD
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Unique_IdentifierObjectType[] $ship_To_Address_Reference
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType[] $active_Location_or_Location_Hierarchy_for_Procurement_Reference
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\WorkerObjectType $resulting_Buyer_Reference
     * @param bool $use_Submitted_by_Worker_on_Requisition_as_Buyer
     * @param bool $use_Requisition_Sourcing_Buyer
     */
    public function __construct($iD = null, array $company_Reference = array(), array $ship_To_Address_Reference = array(), array $active_Location_or_Location_Hierarchy_for_Procurement_Reference = array(), array $requisition_Type_Reference = array(), array $spend_Category_Reference = array(), array $supplier_Reference = array(), \StructType\WorkerObjectType $resulting_Buyer_Reference = null, $use_Submitted_by_Worker_on_Requisition_as_Buyer = null, $use_Requisition_Sourcing_Buyer = null)
    {
        $this
            ->setID($iD)
            ->setCompany_Reference($company_Reference)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setActive_Location_or_Location_Hierarchy_for_Procurement_Reference($active_Location_or_Location_Hierarchy_for_Procurement_Reference)
            ->setRequisition_Type_Reference($requisition_Type_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setResulting_Buyer_Reference($resulting_Buyer_Reference)
            ->setUse_Submitted_by_Worker_on_Requisition_as_Buyer($use_Submitted_by_Worker_on_Requisition_as_Buyer)
            ->setUse_Requisition_Sourcing_Buyer($use_Requisition_Sourcing_Buyer);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Buyer_DataTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Buyer_DataTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Buyer_DataTypeCompany_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Buyer_DataTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Buyer_DataTypeCompany_ReferenceItem), var_export($requisition_Sourcing_Rule_Buyer_DataTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * This method is responsible for validating the values passed to the setShip_To_Address_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShip_To_Address_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShip_To_Address_ReferenceForArrayConstraintsFromSetShip_To_Address_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Buyer_DataTypeShip_To_Address_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Buyer_DataTypeShip_To_Address_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Buyer_DataTypeShip_To_Address_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Buyer_DataTypeShip_To_Address_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Buyer_DataTypeShip_To_Address_ReferenceItem), var_export($requisition_Sourcing_Rule_Buyer_DataTypeShip_To_Address_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ship_To_Address_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $ship_To_Address_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function setShip_To_Address_Reference(array $ship_To_Address_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($ship_To_Address_ReferenceArrayErrorMessage = self::validateShip_To_Address_ReferenceForArrayConstraintsFromSetShip_To_Address_Reference($ship_To_Address_Reference))) {
            throw new \InvalidArgumentException($ship_To_Address_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Add item to Ship_To_Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function addToShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Ship_To_Address_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ship_To_Address_Reference[] = $this->{'Ship-To_Address_Reference'}[] = $item;
        return $this;
    }
    /**
     * Get Active_Location_or_Location_Hierarchy_for_Procurement_Reference value
     * @return \StructType\Asset_Location_or_Location_HierarchyObjectType[]|null
     */
    public function getActive_Location_or_Location_Hierarchy_for_Procurement_Reference()
    {
        return $this->Active_Location_or_Location_Hierarchy_for_Procurement_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setActive_Location_or_Location_Hierarchy_for_Procurement_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActive_Location_or_Location_Hierarchy_for_Procurement_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceForArrayConstraintsFromSetActive_Location_or_Location_Hierarchy_for_Procurement_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Buyer_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Buyer_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem instanceof \StructType\Asset_Location_or_Location_HierarchyObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Buyer_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Buyer_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Buyer_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem), var_export($requisition_Sourcing_Rule_Buyer_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Active_Location_or_Location_Hierarchy_for_Procurement_Reference property can only contain items of type \StructType\Asset_Location_or_Location_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Active_Location_or_Location_Hierarchy_for_Procurement_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType[] $active_Location_or_Location_Hierarchy_for_Procurement_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function setActive_Location_or_Location_Hierarchy_for_Procurement_Reference(array $active_Location_or_Location_Hierarchy_for_Procurement_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($active_Location_or_Location_Hierarchy_for_Procurement_ReferenceArrayErrorMessage = self::validateActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceForArrayConstraintsFromSetActive_Location_or_Location_Hierarchy_for_Procurement_Reference($active_Location_or_Location_Hierarchy_for_Procurement_Reference))) {
            throw new \InvalidArgumentException($active_Location_or_Location_Hierarchy_for_Procurement_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Active_Location_or_Location_Hierarchy_for_Procurement_Reference = $active_Location_or_Location_Hierarchy_for_Procurement_Reference;
        return $this;
    }
    /**
     * Add item to Active_Location_or_Location_Hierarchy_for_Procurement_Reference
     * value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function addToActive_Location_or_Location_Hierarchy_for_Procurement_Reference(\StructType\Asset_Location_or_Location_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Location_or_Location_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Active_Location_or_Location_Hierarchy_for_Procurement_Reference property can only contain items of type \StructType\Asset_Location_or_Location_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Active_Location_or_Location_Hierarchy_for_Procurement_Reference[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Type_Reference value
     * @return \StructType\Requisition_TypeObjectType[]|null
     */
    public function getRequisition_Type_Reference()
    {
        return $this->Requisition_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Buyer_DataTypeRequisition_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Buyer_DataTypeRequisition_Type_ReferenceItem instanceof \StructType\Requisition_TypeObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Buyer_DataTypeRequisition_Type_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Buyer_DataTypeRequisition_Type_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Buyer_DataTypeRequisition_Type_ReferenceItem), var_export($requisition_Sourcing_Rule_Buyer_DataTypeRequisition_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function setRequisition_Type_Reference(array $requisition_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Type_ReferenceArrayErrorMessage = self::validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference($requisition_Type_Reference))) {
            throw new \InvalidArgumentException($requisition_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Type_Reference = $requisition_Type_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function addToRequisition_Type_Reference(\StructType\Requisition_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_Category_or_HierarchyObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Buyer_DataTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Buyer_DataTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Buyer_DataTypeSpend_Category_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Buyer_DataTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Buyer_DataTypeSpend_Category_ReferenceItem), var_export($requisition_Sourcing_Rule_Buyer_DataTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_Category_or_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Buyer_DataTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Buyer_DataTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Buyer_DataTypeSupplier_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Buyer_DataTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Buyer_DataTypeSupplier_ReferenceItem), var_export($requisition_Sourcing_Rule_Buyer_DataTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Resulting_Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getResulting_Buyer_Reference()
    {
        return isset($this->Resulting_Buyer_Reference) ? $this->Resulting_Buyer_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setResulting_Buyer_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResulting_Buyer_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateResulting_Buyer_ReferenceForChoiceConstraintsFromSetResulting_Buyer_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Use_Submitted_by_Worker_on_Requisition_as_Buyer',
            'Use_Requisition_Sourcing_Buyer',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Resulting_Buyer_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Resulting_Buyer_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Resulting_Buyer_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $resulting_Buyer_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function setResulting_Buyer_Reference(\StructType\WorkerObjectType $resulting_Buyer_Reference = null)
    {
        // validation for constraint: choice(Resulting_Buyer_Reference, Use_Submitted_by_Worker_on_Requisition_as_Buyer, Use_Requisition_Sourcing_Buyer)
        if ('' !== ($resulting_Buyer_ReferenceChoiceErrorMessage = self::validateResulting_Buyer_ReferenceForChoiceConstraintsFromSetResulting_Buyer_Reference($resulting_Buyer_Reference))) {
            throw new \InvalidArgumentException($resulting_Buyer_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($resulting_Buyer_Reference) || (is_array($resulting_Buyer_Reference) && empty($resulting_Buyer_Reference))) {
            unset($this->Resulting_Buyer_Reference);
        } else {
            $this->Resulting_Buyer_Reference = $resulting_Buyer_Reference;
        }
        return $this;
    }
    /**
     * Get Use_Submitted_by_Worker_on_Requisition_as_Buyer value
     * @return bool|null
     */
    public function getUse_Submitted_by_Worker_on_Requisition_as_Buyer()
    {
        return isset($this->Use_Submitted_by_Worker_on_Requisition_as_Buyer) ? $this->Use_Submitted_by_Worker_on_Requisition_as_Buyer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Submitted_by_Worker_on_Requisition_as_Buyer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Submitted_by_Worker_on_Requisition_as_Buyer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Submitted_by_Worker_on_Requisition_as_BuyerForChoiceConstraintsFromSetUse_Submitted_by_Worker_on_Requisition_as_Buyer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Resulting_Buyer_Reference',
            'Use_Requisition_Sourcing_Buyer',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Submitted_by_Worker_on_Requisition_as_Buyer can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Submitted_by_Worker_on_Requisition_as_Buyer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Submitted_by_Worker_on_Requisition_as_Buyer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Submitted_by_Worker_on_Requisition_as_Buyer
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function setUse_Submitted_by_Worker_on_Requisition_as_Buyer($use_Submitted_by_Worker_on_Requisition_as_Buyer = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Submitted_by_Worker_on_Requisition_as_Buyer) && !is_bool($use_Submitted_by_Worker_on_Requisition_as_Buyer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Submitted_by_Worker_on_Requisition_as_Buyer, true), gettype($use_Submitted_by_Worker_on_Requisition_as_Buyer)), __LINE__);
        }
        // validation for constraint: choice(Resulting_Buyer_Reference, Use_Submitted_by_Worker_on_Requisition_as_Buyer, Use_Requisition_Sourcing_Buyer)
        if ('' !== ($use_Submitted_by_Worker_on_Requisition_as_BuyerChoiceErrorMessage = self::validateUse_Submitted_by_Worker_on_Requisition_as_BuyerForChoiceConstraintsFromSetUse_Submitted_by_Worker_on_Requisition_as_Buyer($use_Submitted_by_Worker_on_Requisition_as_Buyer))) {
            throw new \InvalidArgumentException($use_Submitted_by_Worker_on_Requisition_as_BuyerChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Submitted_by_Worker_on_Requisition_as_Buyer) || (is_array($use_Submitted_by_Worker_on_Requisition_as_Buyer) && empty($use_Submitted_by_Worker_on_Requisition_as_Buyer))) {
            unset($this->Use_Submitted_by_Worker_on_Requisition_as_Buyer);
        } else {
            $this->Use_Submitted_by_Worker_on_Requisition_as_Buyer = $use_Submitted_by_Worker_on_Requisition_as_Buyer;
        }
        return $this;
    }
    /**
     * Get Use_Requisition_Sourcing_Buyer value
     * @return bool|null
     */
    public function getUse_Requisition_Sourcing_Buyer()
    {
        return isset($this->Use_Requisition_Sourcing_Buyer) ? $this->Use_Requisition_Sourcing_Buyer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Requisition_Sourcing_Buyer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Requisition_Sourcing_Buyer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Requisition_Sourcing_BuyerForChoiceConstraintsFromSetUse_Requisition_Sourcing_Buyer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Resulting_Buyer_Reference',
            'Use_Submitted_by_Worker_on_Requisition_as_Buyer',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Requisition_Sourcing_Buyer can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Requisition_Sourcing_Buyer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Requisition_Sourcing_Buyer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Requisition_Sourcing_Buyer
     * @return \StructType\Requisition_Sourcing_Rule_Buyer_DataType
     */
    public function setUse_Requisition_Sourcing_Buyer($use_Requisition_Sourcing_Buyer = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Requisition_Sourcing_Buyer) && !is_bool($use_Requisition_Sourcing_Buyer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Requisition_Sourcing_Buyer, true), gettype($use_Requisition_Sourcing_Buyer)), __LINE__);
        }
        // validation for constraint: choice(Resulting_Buyer_Reference, Use_Submitted_by_Worker_on_Requisition_as_Buyer, Use_Requisition_Sourcing_Buyer)
        if ('' !== ($use_Requisition_Sourcing_BuyerChoiceErrorMessage = self::validateUse_Requisition_Sourcing_BuyerForChoiceConstraintsFromSetUse_Requisition_Sourcing_Buyer($use_Requisition_Sourcing_Buyer))) {
            throw new \InvalidArgumentException($use_Requisition_Sourcing_BuyerChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Requisition_Sourcing_Buyer) || (is_array($use_Requisition_Sourcing_Buyer) && empty($use_Requisition_Sourcing_Buyer))) {
            unset($this->Use_Requisition_Sourcing_Buyer);
        } else {
            $this->Use_Requisition_Sourcing_Buyer = $use_Requisition_Sourcing_Buyer;
        }
        return $this;
    }
}
