<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requesting_Entity_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Requesting Entity
 * @subpackage Structs
 */
class Requesting_Entity_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Requesting_Entity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Requesting Entity.
     * - maxOccurs: unbounded
     * @var \StructType\Requesting_EntityObjectType[]
     */
    public $Requesting_Entity_Reference;
    /**
     * Constructor method for Requesting_Entity_Request_ReferencesType
     * @uses Requesting_Entity_Request_ReferencesType::setRequesting_Entity_Reference()
     * @param \StructType\Requesting_EntityObjectType[] $requesting_Entity_Reference
     */
    public function __construct(array $requesting_Entity_Reference = array())
    {
        $this
            ->setRequesting_Entity_Reference($requesting_Entity_Reference);
    }
    /**
     * Get Requesting_Entity_Reference value
     * @return \StructType\Requesting_EntityObjectType[]|null
     */
    public function getRequesting_Entity_Reference()
    {
        return $this->Requesting_Entity_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequesting_Entity_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequesting_Entity_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequesting_Entity_ReferenceForArrayConstraintsFromSetRequesting_Entity_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requesting_Entity_Request_ReferencesTypeRequesting_Entity_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requesting_Entity_Request_ReferencesTypeRequesting_Entity_ReferenceItem instanceof \StructType\Requesting_EntityObjectType) {
                $invalidValues[] = is_object($requesting_Entity_Request_ReferencesTypeRequesting_Entity_ReferenceItem) ? get_class($requesting_Entity_Request_ReferencesTypeRequesting_Entity_ReferenceItem) : sprintf('%s(%s)', gettype($requesting_Entity_Request_ReferencesTypeRequesting_Entity_ReferenceItem), var_export($requesting_Entity_Request_ReferencesTypeRequesting_Entity_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requesting_Entity_Reference property can only contain items of type \StructType\Requesting_EntityObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requesting_Entity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requesting_EntityObjectType[] $requesting_Entity_Reference
     * @return \StructType\Requesting_Entity_Request_ReferencesType
     */
    public function setRequesting_Entity_Reference(array $requesting_Entity_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requesting_Entity_ReferenceArrayErrorMessage = self::validateRequesting_Entity_ReferenceForArrayConstraintsFromSetRequesting_Entity_Reference($requesting_Entity_Reference))) {
            throw new \InvalidArgumentException($requesting_Entity_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requesting_Entity_Reference = $requesting_Entity_Reference;
        return $this;
    }
    /**
     * Add item to Requesting_Entity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requesting_EntityObjectType $item
     * @return \StructType\Requesting_Entity_Request_ReferencesType
     */
    public function addToRequesting_Entity_Reference(\StructType\Requesting_EntityObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requesting_EntityObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requesting_Entity_Reference property can only contain items of type \StructType\Requesting_EntityObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requesting_Entity_Reference[] = $item;
        return $this;
    }
}
