<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Request for Quote Request References element contains instances of Request for Quote for get operation.
 * @subpackage Structs
 */
class Request_for_Quote_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Request for Quote.
     * - maxOccurs: unbounded
     * @var \StructType\Request_for_QuoteObjectType[]
     */
    public $Request_for_Quote_Reference;
    /**
     * Constructor method for Request_for_Quote_Request_ReferencesType
     * @uses Request_for_Quote_Request_ReferencesType::setRequest_for_Quote_Reference()
     * @param \StructType\Request_for_QuoteObjectType[] $request_for_Quote_Reference
     */
    public function __construct(array $request_for_Quote_Reference = array())
    {
        $this
            ->setRequest_for_Quote_Reference($request_for_Quote_Reference);
    }
    /**
     * Get Request_for_Quote_Reference value
     * @return \StructType\Request_for_QuoteObjectType[]|null
     */
    public function getRequest_for_Quote_Reference()
    {
        return $this->Request_for_Quote_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_ReferenceForArrayConstraintsFromSetRequest_for_Quote_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Request_ReferencesTypeRequest_for_Quote_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Request_ReferencesTypeRequest_for_Quote_ReferenceItem instanceof \StructType\Request_for_QuoteObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Request_ReferencesTypeRequest_for_Quote_ReferenceItem) ? get_class($request_for_Quote_Request_ReferencesTypeRequest_for_Quote_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Request_ReferencesTypeRequest_for_Quote_ReferenceItem), var_export($request_for_Quote_Request_ReferencesTypeRequest_for_Quote_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Reference property can only contain items of type \StructType\Request_for_QuoteObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_QuoteObjectType[] $request_for_Quote_Reference
     * @return \StructType\Request_for_Quote_Request_ReferencesType
     */
    public function setRequest_for_Quote_Reference(array $request_for_Quote_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_ReferenceArrayErrorMessage = self::validateRequest_for_Quote_ReferenceForArrayConstraintsFromSetRequest_for_Quote_Reference($request_for_Quote_Reference))) {
            throw new \InvalidArgumentException($request_for_Quote_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Reference = $request_for_Quote_Reference;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_QuoteObjectType $item
     * @return \StructType\Request_for_Quote_Request_ReferencesType
     */
    public function addToRequest_for_Quote_Reference(\StructType\Request_for_QuoteObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_QuoteObjectType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Reference property can only contain items of type \StructType\Request_for_QuoteObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Reference[] = $item;
        return $this;
    }
}
