<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Award_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that captures a reference to the RFQ Award Document along with its content
 * @subpackage Structs
 */
class Request_for_Quote_Award_OutboundType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Award_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ Award document
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_AwardObjectType
     */
    public $Request_for_Quote_Award_Reference;
    /**
     * The Request_for_Quote_Award_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that represents the contents of the entire RFQ Award Document
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Award_DataType[]
     */
    public $Request_for_Quote_Award_Data;
    /**
     * Constructor method for Request_for_Quote_Award_OutboundType
     * @uses Request_for_Quote_Award_OutboundType::setRequest_for_Quote_Award_Reference()
     * @uses Request_for_Quote_Award_OutboundType::setRequest_for_Quote_Award_Data()
     * @param \StructType\Request_for_Quote_AwardObjectType $request_for_Quote_Award_Reference
     * @param \StructType\Request_for_Quote_Award_DataType[] $request_for_Quote_Award_Data
     */
    public function __construct(\StructType\Request_for_Quote_AwardObjectType $request_for_Quote_Award_Reference = null, array $request_for_Quote_Award_Data = array())
    {
        $this
            ->setRequest_for_Quote_Award_Reference($request_for_Quote_Award_Reference)
            ->setRequest_for_Quote_Award_Data($request_for_Quote_Award_Data);
    }
    /**
     * Get Request_for_Quote_Award_Reference value
     * @return \StructType\Request_for_Quote_AwardObjectType|null
     */
    public function getRequest_for_Quote_Award_Reference()
    {
        return $this->Request_for_Quote_Award_Reference;
    }
    /**
     * Set Request_for_Quote_Award_Reference value
     * @param \StructType\Request_for_Quote_AwardObjectType $request_for_Quote_Award_Reference
     * @return \StructType\Request_for_Quote_Award_OutboundType
     */
    public function setRequest_for_Quote_Award_Reference(\StructType\Request_for_Quote_AwardObjectType $request_for_Quote_Award_Reference = null)
    {
        $this->Request_for_Quote_Award_Reference = $request_for_Quote_Award_Reference;
        return $this;
    }
    /**
     * Get Request_for_Quote_Award_Data value
     * @return \StructType\Request_for_Quote_Award_DataType[]|null
     */
    public function getRequest_for_Quote_Award_Data()
    {
        return $this->Request_for_Quote_Award_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Award_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Award_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Award_DataForArrayConstraintsFromSetRequest_for_Quote_Award_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_OutboundTypeRequest_for_Quote_Award_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_OutboundTypeRequest_for_Quote_Award_DataItem instanceof \StructType\Request_for_Quote_Award_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Award_OutboundTypeRequest_for_Quote_Award_DataItem) ? get_class($request_for_Quote_Award_OutboundTypeRequest_for_Quote_Award_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_OutboundTypeRequest_for_Quote_Award_DataItem), var_export($request_for_Quote_Award_OutboundTypeRequest_for_Quote_Award_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Award_Data property can only contain items of type \StructType\Request_for_Quote_Award_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Award_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_DataType[] $request_for_Quote_Award_Data
     * @return \StructType\Request_for_Quote_Award_OutboundType
     */
    public function setRequest_for_Quote_Award_Data(array $request_for_Quote_Award_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Award_DataArrayErrorMessage = self::validateRequest_for_Quote_Award_DataForArrayConstraintsFromSetRequest_for_Quote_Award_Data($request_for_Quote_Award_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Award_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Award_Data = $request_for_Quote_Award_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Award_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_DataType $item
     * @return \StructType\Request_for_Quote_Award_OutboundType
     */
    public function addToRequest_for_Quote_Award_Data(\StructType\Request_for_Quote_Award_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Award_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Award_Data property can only contain items of type \StructType\Request_for_Quote_Award_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Award_Data[] = $item;
        return $this;
    }
}
