<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Related_Asset_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: References to other assets to which this asset is related. Related assets must be within the same company.Related assets can be loaded using the Edit Asset web service or the Asset > Edit related task.
 * @subpackage Structs
 */
class Related_Asset_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Related_Asset_ID
     * Meta information extracted from the WSDL
     * - documentation: Related assets must be within the same company. | Related assets cannot be the asset itself and must be within the same company. | Related Business Asset ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Related_Asset_ID;
    /**
     * Constructor method for Related_Asset_Replacement_DataType
     * @uses Related_Asset_Replacement_DataType::setRelated_Asset_ID()
     * @param string $related_Asset_ID
     */
    public function __construct($related_Asset_ID = null)
    {
        $this
            ->setRelated_Asset_ID($related_Asset_ID);
    }
    /**
     * Get Related_Asset_ID value
     * @return string|null
     */
    public function getRelated_Asset_ID()
    {
        return $this->Related_Asset_ID;
    }
    /**
     * Set Related_Asset_ID value
     * @param string $related_Asset_ID
     * @return \StructType\Related_Asset_Replacement_DataType
     */
    public function setRelated_Asset_ID($related_Asset_ID = null)
    {
        // validation for constraint: string
        if (!is_null($related_Asset_ID) && !is_string($related_Asset_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($related_Asset_ID, true), gettype($related_Asset_ID)), __LINE__);
        }
        $this->Related_Asset_ID = $related_Asset_ID;
        return $this;
    }
}
