<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recipient_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that encapsulates the recipient type info (worker, recipient, recipient name). Only one value can be used at a time.
 * @subpackage Structs
 */
class Recipient_DataType extends AbstractStructBase
{
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: The applicant you have entered is not valid. You must use the employee instance for this person. | Reference to the worker or applicant who was a recipient for the expense.
     * - choice: Worker_Reference | Recipient_Reference | Recipient_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Expense_PayeeObjectType
     */
    public $Worker_Reference;
    /**
     * The Recipient_Reference
     * Meta information extracted from the WSDL
     * - documentation: The recipient you have entered is not valid for the expense payee | Reference to the person who was a recipient for the expense. Only recipients associated with the expense payee will be allowed.
     * - choice: Worker_Reference | Recipient_Reference | Recipient_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Recipient_Reference;
    /**
     * The Recipient_Name
     * Meta information extracted from the WSDL
     * - documentation: Text representing the name of the recipient. If the recipient exists already and is associated with the expense payee then it will be used. Otherwise, a new recipient will be created.
     * - choice: Worker_Reference | Recipient_Reference | Recipient_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recipient_Name;
    /**
     * Constructor method for Recipient_DataType
     * @uses Recipient_DataType::setWorker_Reference()
     * @uses Recipient_DataType::setRecipient_Reference()
     * @uses Recipient_DataType::setRecipient_Name()
     * @param \StructType\Expense_PayeeObjectType $worker_Reference
     * @param \StructType\Unique_IdentifierObjectType $recipient_Reference
     * @param string $recipient_Name
     */
    public function __construct(\StructType\Expense_PayeeObjectType $worker_Reference = null, \StructType\Unique_IdentifierObjectType $recipient_Reference = null, $recipient_Name = null)
    {
        $this
            ->setWorker_Reference($worker_Reference)
            ->setRecipient_Reference($recipient_Reference)
            ->setRecipient_Name($recipient_Name);
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getWorker_Reference()
    {
        return isset($this->Worker_Reference) ? $this->Worker_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWorker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorker_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWorker_ReferenceForChoiceConstraintsFromSetWorker_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Recipient_Reference',
            'Recipient_Name',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Worker_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Worker_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Worker_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType $worker_Reference
     * @return \StructType\Recipient_DataType
     */
    public function setWorker_Reference(\StructType\Expense_PayeeObjectType $worker_Reference = null)
    {
        // validation for constraint: choice(Worker_Reference, Recipient_Reference, Recipient_Name)
        if ('' !== ($worker_ReferenceChoiceErrorMessage = self::validateWorker_ReferenceForChoiceConstraintsFromSetWorker_Reference($worker_Reference))) {
            throw new \InvalidArgumentException($worker_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($worker_Reference) || (is_array($worker_Reference) && empty($worker_Reference))) {
            unset($this->Worker_Reference);
        } else {
            $this->Worker_Reference = $worker_Reference;
        }
        return $this;
    }
    /**
     * Get Recipient_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getRecipient_Reference()
    {
        return isset($this->Recipient_Reference) ? $this->Recipient_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRecipient_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipient_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRecipient_ReferenceForChoiceConstraintsFromSetRecipient_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Worker_Reference',
            'Recipient_Name',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Recipient_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Recipient_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Recipient_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $recipient_Reference
     * @return \StructType\Recipient_DataType
     */
    public function setRecipient_Reference(\StructType\Unique_IdentifierObjectType $recipient_Reference = null)
    {
        // validation for constraint: choice(Worker_Reference, Recipient_Reference, Recipient_Name)
        if ('' !== ($recipient_ReferenceChoiceErrorMessage = self::validateRecipient_ReferenceForChoiceConstraintsFromSetRecipient_Reference($recipient_Reference))) {
            throw new \InvalidArgumentException($recipient_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($recipient_Reference) || (is_array($recipient_Reference) && empty($recipient_Reference))) {
            unset($this->Recipient_Reference);
        } else {
            $this->Recipient_Reference = $recipient_Reference;
        }
        return $this;
    }
    /**
     * Get Recipient_Name value
     * @return string|null
     */
    public function getRecipient_Name()
    {
        return isset($this->Recipient_Name) ? $this->Recipient_Name : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRecipient_Name method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipient_Name method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRecipient_NameForChoiceConstraintsFromSetRecipient_Name($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Worker_Reference',
            'Recipient_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Recipient_Name can\'t be set as the property %s is already set. Only one property must be set among these properties: Recipient_Name, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Recipient_Name value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $recipient_Name
     * @return \StructType\Recipient_DataType
     */
    public function setRecipient_Name($recipient_Name = null)
    {
        // validation for constraint: string
        if (!is_null($recipient_Name) && !is_string($recipient_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipient_Name, true), gettype($recipient_Name)), __LINE__);
        }
        // validation for constraint: choice(Worker_Reference, Recipient_Reference, Recipient_Name)
        if ('' !== ($recipient_NameChoiceErrorMessage = self::validateRecipient_NameForChoiceConstraintsFromSetRecipient_Name($recipient_Name))) {
            throw new \InvalidArgumentException($recipient_NameChoiceErrorMessage, __LINE__);
        }
        if (is_null($recipient_Name) || (is_array($recipient_Name) && empty($recipient_Name))) {
            unset($this->Recipient_Name);
        } else {
            $this->Recipient_Name = $recipient_Name;
        }
        return $this;
    }
}
