<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receivable_Repayment_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element around a list of elements representing the amount of data that should be included in the Receivable Repayment response. If this element is not included then ALL of the Response Groups are included in the response.
 * @subpackage Structs
 */
class Receivable_Repayment_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Expense Report Reference data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Receivable_Repayment_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Expense Report data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Receivable_Repayment_Data;
    /**
     * Constructor method for Receivable_Repayment_Response_GroupType
     * @uses Receivable_Repayment_Response_GroupType::setInclude_Reference()
     * @uses Receivable_Repayment_Response_GroupType::setInclude_Receivable_Repayment_Data()
     * @param bool $include_Reference
     * @param bool $include_Receivable_Repayment_Data
     */
    public function __construct($include_Reference = null, $include_Receivable_Repayment_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Receivable_Repayment_Data($include_Receivable_Repayment_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Receivable_Repayment_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Receivable_Repayment_Data value
     * @return bool|null
     */
    public function getInclude_Receivable_Repayment_Data()
    {
        return $this->Include_Receivable_Repayment_Data;
    }
    /**
     * Set Include_Receivable_Repayment_Data value
     * @param bool $include_Receivable_Repayment_Data
     * @return \StructType\Receivable_Repayment_Response_GroupType
     */
    public function setInclude_Receivable_Repayment_Data($include_Receivable_Repayment_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Receivable_Repayment_Data) && !is_bool($include_Receivable_Repayment_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Receivable_Repayment_Data, true), gettype($include_Receivable_Repayment_Data)), __LINE__);
        }
        $this->Include_Receivable_Repayment_Data = $include_Receivable_Repayment_Data;
        return $this;
    }
}
