<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receivable_Repayment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Receivable Repayment Data contains all the information about Receivable Repayment.
 * @subpackage Structs
 */
class Receivable_Repayment_DataType extends AbstractStructBase
{
    /**
     * The Receivable_Repayment_Report_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Report ID. This is the Expense Report unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receivable_Repayment_Report_ID;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Document Status
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Expense_Payee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the person who the expense report is for.
     * - minOccurs: 0
     * @var \StructType\Expense_PayeeObjectType
     */
    public $Expense_Payee_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the company the expense report is for.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Repayment_Date
     * Meta information extracted from the WSDL
     * - documentation: Repayment Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Repayment_Date;
    /**
     * The Repayment_Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount being repaid with this Cash Advance Repayment | Repayment Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Repayment_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the currency for Receivable Repayment. This must match the currency for the company.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receivable Repayment Payment Type
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Payment_Type_Reference;
    /**
     * The Payment_Reference_Detail
     * Meta information extracted from the WSDL
     * - documentation: Repayment Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Payment_Reference_Detail;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Recovery_Expense_Reports_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recovery_Expense_Reports_DataType[]
     */
    public $Recovery_Expense_Reports_Data;
    /**
     * Constructor method for Receivable_Repayment_DataType
     * @uses Receivable_Repayment_DataType::setReceivable_Repayment_Report_ID()
     * @uses Receivable_Repayment_DataType::setDocument_Status_Reference()
     * @uses Receivable_Repayment_DataType::setExpense_Payee_Reference()
     * @uses Receivable_Repayment_DataType::setCompany_Reference()
     * @uses Receivable_Repayment_DataType::setRepayment_Date()
     * @uses Receivable_Repayment_DataType::setRepayment_Amount()
     * @uses Receivable_Repayment_DataType::setCurrency_Reference()
     * @uses Receivable_Repayment_DataType::setPayment_Type_Reference()
     * @uses Receivable_Repayment_DataType::setPayment_Reference_Detail()
     * @uses Receivable_Repayment_DataType::setMemo()
     * @uses Receivable_Repayment_DataType::setRecovery_Expense_Reports_Data()
     * @param string $receivable_Repayment_Report_ID
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param string $repayment_Date
     * @param float $repayment_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @param string $payment_Reference_Detail
     * @param string $memo
     * @param \StructType\Recovery_Expense_Reports_DataType[] $recovery_Expense_Reports_Data
     */
    public function __construct($receivable_Repayment_Report_ID = null, \StructType\Document_StatusObjectType $document_Status_Reference = null, \StructType\Expense_PayeeObjectType $expense_Payee_Reference = null, \StructType\CompanyObjectType $company_Reference = null, $repayment_Date = null, $repayment_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Payment_TypeObjectType $payment_Type_Reference = null, $payment_Reference_Detail = null, $memo = null, array $recovery_Expense_Reports_Data = array())
    {
        $this
            ->setReceivable_Repayment_Report_ID($receivable_Repayment_Report_ID)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setExpense_Payee_Reference($expense_Payee_Reference)
            ->setCompany_Reference($company_Reference)
            ->setRepayment_Date($repayment_Date)
            ->setRepayment_Amount($repayment_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setPayment_Type_Reference($payment_Type_Reference)
            ->setPayment_Reference_Detail($payment_Reference_Detail)
            ->setMemo($memo)
            ->setRecovery_Expense_Reports_Data($recovery_Expense_Reports_Data);
    }
    /**
     * Get Receivable_Repayment_Report_ID value
     * @return string|null
     */
    public function getReceivable_Repayment_Report_ID()
    {
        return $this->Receivable_Repayment_Report_ID;
    }
    /**
     * Set Receivable_Repayment_Report_ID value
     * @param string $receivable_Repayment_Report_ID
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setReceivable_Repayment_Report_ID($receivable_Repayment_Report_ID = null)
    {
        // validation for constraint: string
        if (!is_null($receivable_Repayment_Report_ID) && !is_string($receivable_Repayment_Report_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivable_Repayment_Report_ID, true), gettype($receivable_Repayment_Report_ID)), __LINE__);
        }
        $this->Receivable_Repayment_Report_ID = $receivable_Repayment_Report_ID;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Expense_Payee_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getExpense_Payee_Reference()
    {
        return $this->Expense_Payee_Reference;
    }
    /**
     * Set Expense_Payee_Reference value
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setExpense_Payee_Reference(\StructType\Expense_PayeeObjectType $expense_Payee_Reference = null)
    {
        $this->Expense_Payee_Reference = $expense_Payee_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Repayment_Date value
     * @return string|null
     */
    public function getRepayment_Date()
    {
        return $this->Repayment_Date;
    }
    /**
     * Set Repayment_Date value
     * @param string $repayment_Date
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setRepayment_Date($repayment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($repayment_Date) && !is_string($repayment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repayment_Date, true), gettype($repayment_Date)), __LINE__);
        }
        $this->Repayment_Date = $repayment_Date;
        return $this;
    }
    /**
     * Get Repayment_Amount value
     * @return float|null
     */
    public function getRepayment_Amount()
    {
        return $this->Repayment_Amount;
    }
    /**
     * Set Repayment_Amount value
     * @param float $repayment_Amount
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setRepayment_Amount($repayment_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($repayment_Amount) && !(is_float($repayment_Amount) || is_numeric($repayment_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($repayment_Amount, true), gettype($repayment_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($repayment_Amount) && mb_strlen(mb_substr($repayment_Amount, false !== mb_strpos($repayment_Amount, '.') ? mb_strpos($repayment_Amount, '.') + 1 : mb_strlen($repayment_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($repayment_Amount, true), mb_strlen(mb_substr($repayment_Amount, mb_strpos($repayment_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($repayment_Amount) && $repayment_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($repayment_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($repayment_Amount) && mb_strlen(preg_replace('/(\D)/', '', $repayment_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($repayment_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $repayment_Amount))), __LINE__);
        }
        $this->Repayment_Amount = $repayment_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getPayment_Type_Reference()
    {
        return $this->Payment_Type_Reference;
    }
    /**
     * Set Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setPayment_Type_Reference(\StructType\Payment_TypeObjectType $payment_Type_Reference = null)
    {
        $this->Payment_Type_Reference = $payment_Type_Reference;
        return $this;
    }
    /**
     * Get Payment_Reference_Detail value
     * @return string|null
     */
    public function getPayment_Reference_Detail()
    {
        return $this->Payment_Reference_Detail;
    }
    /**
     * Set Payment_Reference_Detail value
     * @param string $payment_Reference_Detail
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setPayment_Reference_Detail($payment_Reference_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($payment_Reference_Detail) && !is_string($payment_Reference_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_Reference_Detail, true), gettype($payment_Reference_Detail)), __LINE__);
        }
        $this->Payment_Reference_Detail = $payment_Reference_Detail;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Recovery_Expense_Reports_Data value
     * @return \StructType\Recovery_Expense_Reports_DataType[]|null
     */
    public function getRecovery_Expense_Reports_Data()
    {
        return $this->Recovery_Expense_Reports_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRecovery_Expense_Reports_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecovery_Expense_Reports_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecovery_Expense_Reports_DataForArrayConstraintsFromSetRecovery_Expense_Reports_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receivable_Repayment_DataTypeRecovery_Expense_Reports_DataItem) {
            // validation for constraint: itemType
            if (!$receivable_Repayment_DataTypeRecovery_Expense_Reports_DataItem instanceof \StructType\Recovery_Expense_Reports_DataType) {
                $invalidValues[] = is_object($receivable_Repayment_DataTypeRecovery_Expense_Reports_DataItem) ? get_class($receivable_Repayment_DataTypeRecovery_Expense_Reports_DataItem) : sprintf('%s(%s)', gettype($receivable_Repayment_DataTypeRecovery_Expense_Reports_DataItem), var_export($receivable_Repayment_DataTypeRecovery_Expense_Reports_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recovery_Expense_Reports_Data property can only contain items of type \StructType\Recovery_Expense_Reports_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recovery_Expense_Reports_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recovery_Expense_Reports_DataType[] $recovery_Expense_Reports_Data
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function setRecovery_Expense_Reports_Data(array $recovery_Expense_Reports_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($recovery_Expense_Reports_DataArrayErrorMessage = self::validateRecovery_Expense_Reports_DataForArrayConstraintsFromSetRecovery_Expense_Reports_Data($recovery_Expense_Reports_Data))) {
            throw new \InvalidArgumentException($recovery_Expense_Reports_DataArrayErrorMessage, __LINE__);
        }
        $this->Recovery_Expense_Reports_Data = $recovery_Expense_Reports_Data;
        return $this;
    }
    /**
     * Add item to Recovery_Expense_Reports_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recovery_Expense_Reports_DataType $item
     * @return \StructType\Receivable_Repayment_DataType
     */
    public function addToRecovery_Expense_Reports_Data(\StructType\Recovery_Expense_Reports_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recovery_Expense_Reports_DataType) {
            throw new \InvalidArgumentException(sprintf('The Recovery_Expense_Reports_Data property can only contain items of type \StructType\Recovery_Expense_Reports_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recovery_Expense_Reports_Data[] = $item;
        return $this;
    }
}
