<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receivable_Repayment_Adhoc_Bank_TransactionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Receivable Repayment Adhoc Bank Transaction contains details about Adhoc Bank Transaction to be created.
 * @subpackage Structs
 */
class Receivable_Repayment_Adhoc_Bank_TransactionType extends AbstractStructBase
{
    /**
     * The Ledger_Account
     * Meta information extracted from the WSDL
     * - documentation: Ledger Account Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ledger_Account;
    /**
     * The Recovered_Amount
     * Meta information extracted from the WSDL
     * - documentation: Recovered Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Recovered_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Audited Accounting Worktag
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * Constructor method for Receivable_Repayment_Adhoc_Bank_TransactionType
     * @uses Receivable_Repayment_Adhoc_Bank_TransactionType::setLedger_Account()
     * @uses Receivable_Repayment_Adhoc_Bank_TransactionType::setRecovered_Amount()
     * @uses Receivable_Repayment_Adhoc_Bank_TransactionType::setCurrency_Reference()
     * @uses Receivable_Repayment_Adhoc_Bank_TransactionType::setWorktags_Reference()
     * @param string $ledger_Account
     * @param float $recovered_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktags_Reference
     */
    public function __construct($ledger_Account = null, $recovered_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, array $worktags_Reference = array())
    {
        $this
            ->setLedger_Account($ledger_Account)
            ->setRecovered_Amount($recovered_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setWorktags_Reference($worktags_Reference);
    }
    /**
     * Get Ledger_Account value
     * @return string|null
     */
    public function getLedger_Account()
    {
        return $this->Ledger_Account;
    }
    /**
     * Set Ledger_Account value
     * @param string $ledger_Account
     * @return \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType
     */
    public function setLedger_Account($ledger_Account = null)
    {
        // validation for constraint: string
        if (!is_null($ledger_Account) && !is_string($ledger_Account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledger_Account, true), gettype($ledger_Account)), __LINE__);
        }
        $this->Ledger_Account = $ledger_Account;
        return $this;
    }
    /**
     * Get Recovered_Amount value
     * @return float|null
     */
    public function getRecovered_Amount()
    {
        return $this->Recovered_Amount;
    }
    /**
     * Set Recovered_Amount value
     * @param float $recovered_Amount
     * @return \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType
     */
    public function setRecovered_Amount($recovered_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($recovered_Amount) && !(is_float($recovered_Amount) || is_numeric($recovered_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recovered_Amount, true), gettype($recovered_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($recovered_Amount) && mb_strlen(mb_substr($recovered_Amount, false !== mb_strpos($recovered_Amount, '.') ? mb_strpos($recovered_Amount, '.') + 1 : mb_strlen($recovered_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($recovered_Amount, true), mb_strlen(mb_substr($recovered_Amount, mb_strpos($recovered_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($recovered_Amount) && mb_strlen(preg_replace('/(\D)/', '', $recovered_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($recovered_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $recovered_Amount))), __LINE__);
        }
        $this->Recovered_Amount = $recovered_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receivable_Repayment_Adhoc_Bank_TransactionTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receivable_Repayment_Adhoc_Bank_TransactionTypeWorktags_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($receivable_Repayment_Adhoc_Bank_TransactionTypeWorktags_ReferenceItem) ? get_class($receivable_Repayment_Adhoc_Bank_TransactionTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($receivable_Repayment_Adhoc_Bank_TransactionTypeWorktags_ReferenceItem), var_export($receivable_Repayment_Adhoc_Bank_TransactionTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Receivable_Repayment_Adhoc_Bank_TransactionType
     */
    public function addToWorktags_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
}
