<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Service_Line_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specify the same company for both the supplier contract header and the receipt header. | Negative values for Extended Amount can't exceed the Amount Already Received | Purchase Order Line cannot be used because it has been Canceled.
 * | You can’t create a receipt for this line as there’s no net amount left to receive. | The Supplier Contract Line referenced is for a Contract that is Closed or Pending Close. | The Purchase Order Line referenced is from a PO that is Closed or
 * Pending Close. | The Purchase Order Line must be for the same Supplier as the Receipt. | Purchase Order Line must be for a Service. The line specified is for another type of line. | Purchase Order Line must be from an issued Order. | Receipt Service
 * Line Data
 * @subpackage Structs
 */
class Receipt_Service_Line_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line associated with the Receipt Line. It must be for a service item, or else an invalid instance error will occur.
     * - minOccurs: 0
     * @var \StructType\Order_Service_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Supplier_Contract_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Line associated with the Receipt Line. It must be for a service item, or else an invalid instance error will occur.
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Service_LineObjectType
     */
    public $Supplier_Contract_Line_Reference;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company from the purchase order line or receipt header.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Address Reference for an existing Ship-To Address. Workday derives the Address Reference from the related Purchase Order Line or Supplier Contract Line when creating a Receipt and does not expect this to be included in the Submit Web
     * Service request.
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker, who will be the designated Ship-To Contact. Workday derives the Ship-To Contact from the related Purchase Order Line or Supplier Contract Line when creating a Receipt and does not expect this to be included in
     * the Submit Web Service request.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Location, where the Goods or Services will be delivered. Workday derives the Deliver-To Location from the related Purchase Order Line when creating a Receipt and does not expect this to be included in the
     * Submit Web Service request.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Reference;
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: The commodity code on spend transactions lines. This is a standard code that identifies a type of good or service you order. For example, the United Nations Standard Products and Services Code (UNSPSC) or the National Institute for
     * Governmental Purchasing (NIGP) code. For purchase items and catalog items, you can only submit active commodity codes already associated to the item. For ad hoc based lines, you can submit any active commodity code.
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType
     */
    public $Commodity_Code_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Comment for Receipt Line
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Receipt_Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Receipt Adjustment adjust current Receipt Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_AdjustmentObjectType[]
     */
    public $Receipt_Adjustment_Reference;
    /**
     * The Receipt_Service_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_Service_Line_Split_DataType[]
     */
    public $Receipt_Service_Line_Split_Data;
    /**
     * Constructor method for Receipt_Service_Line_Replacement_DataType
     * @uses Receipt_Service_Line_Replacement_DataType::setPurchase_Order_Line_Reference()
     * @uses Receipt_Service_Line_Replacement_DataType::setSupplier_Contract_Line_Reference()
     * @uses Receipt_Service_Line_Replacement_DataType::setLine_Company_Reference()
     * @uses Receipt_Service_Line_Replacement_DataType::setExtended_Amount()
     * @uses Receipt_Service_Line_Replacement_DataType::setShip_To_Address_Reference()
     * @uses Receipt_Service_Line_Replacement_DataType::setShip_To_Contact_Reference()
     * @uses Receipt_Service_Line_Replacement_DataType::setDeliver_To_Reference()
     * @uses Receipt_Service_Line_Replacement_DataType::setCommodity_Code_Reference()
     * @uses Receipt_Service_Line_Replacement_DataType::setMemo()
     * @uses Receipt_Service_Line_Replacement_DataType::setReceipt_Adjustment_Reference()
     * @uses Receipt_Service_Line_Replacement_DataType::setReceipt_Service_Line_Split_Data()
     * @param \StructType\Order_Service_LineObjectType $purchase_Order_Line_Reference
     * @param \StructType\Supplier_Contract_Service_LineObjectType $supplier_Contract_Line_Reference
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param float $extended_Amount
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Reference
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @param string $memo
     * @param \StructType\Receipt_AdjustmentObjectType[] $receipt_Adjustment_Reference
     * @param \StructType\Receipt_Service_Line_Split_DataType[] $receipt_Service_Line_Split_Data
     */
    public function __construct(\StructType\Order_Service_LineObjectType $purchase_Order_Line_Reference = null, \StructType\Supplier_Contract_Service_LineObjectType $supplier_Contract_Line_Reference = null, \StructType\CompanyObjectType $line_Company_Reference = null, $extended_Amount = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Reference = null, \StructType\Commodity_CodeObjectType $commodity_Code_Reference = null, $memo = null, array $receipt_Adjustment_Reference = array(), array $receipt_Service_Line_Split_Data = array())
    {
        $this
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setSupplier_Contract_Line_Reference($supplier_Contract_Line_Reference)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setExtended_Amount($extended_Amount)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Reference($deliver_To_Reference)
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setMemo($memo)
            ->setReceipt_Adjustment_Reference($receipt_Adjustment_Reference)
            ->setReceipt_Service_Line_Split_Data($receipt_Service_Line_Split_Data);
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Order_Service_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Order_Service_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Order_Service_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Reference value
     * @return \StructType\Supplier_Contract_Service_LineObjectType|null
     */
    public function getSupplier_Contract_Line_Reference()
    {
        return $this->Supplier_Contract_Line_Reference;
    }
    /**
     * Set Supplier_Contract_Line_Reference value
     * @param \StructType\Supplier_Contract_Service_LineObjectType $supplier_Contract_Line_Reference
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Line_Reference(\StructType\Supplier_Contract_Service_LineObjectType $supplier_Contract_Line_Reference = null)
    {
        $this->Supplier_Contract_Line_Reference = $supplier_Contract_Line_Reference;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Reference()
    {
        return $this->Deliver_To_Reference;
    }
    /**
     * Set Deliver_To_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Reference
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setDeliver_To_Reference(\StructType\LocationObjectType $deliver_To_Reference = null)
    {
        $this->Deliver_To_Reference = $deliver_To_Reference;
        return $this;
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * Set Commodity_Code_Reference value
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $commodity_Code_Reference = null)
    {
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Reference value
     * @return \StructType\Receipt_AdjustmentObjectType[]|null
     */
    public function getReceipt_Adjustment_Reference()
    {
        return $this->Receipt_Adjustment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Adjustment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Adjustment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_Adjustment_ReferenceForArrayConstraintsFromSetReceipt_Adjustment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Service_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_Service_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem instanceof \StructType\Receipt_AdjustmentObjectType) {
                $invalidValues[] = is_object($receipt_Service_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem) ? get_class($receipt_Service_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_Service_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem), var_export($receipt_Service_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Adjustment_Reference property can only contain items of type \StructType\Receipt_AdjustmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Adjustment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_AdjustmentObjectType[] $receipt_Adjustment_Reference
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setReceipt_Adjustment_Reference(array $receipt_Adjustment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_Adjustment_ReferenceArrayErrorMessage = self::validateReceipt_Adjustment_ReferenceForArrayConstraintsFromSetReceipt_Adjustment_Reference($receipt_Adjustment_Reference))) {
            throw new \InvalidArgumentException($receipt_Adjustment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Adjustment_Reference = $receipt_Adjustment_Reference;
        return $this;
    }
    /**
     * Add item to Receipt_Adjustment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_AdjustmentObjectType $item
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function addToReceipt_Adjustment_Reference(\StructType\Receipt_AdjustmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_AdjustmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Adjustment_Reference property can only contain items of type \StructType\Receipt_AdjustmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Adjustment_Reference[] = $item;
        return $this;
    }
    /**
     * Get Receipt_Service_Line_Split_Data value
     * @return \StructType\Receipt_Service_Line_Split_DataType[]|null
     */
    public function getReceipt_Service_Line_Split_Data()
    {
        return $this->Receipt_Service_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Service_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Service_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_Service_Line_Split_DataForArrayConstraintsFromSetReceipt_Service_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Service_Line_Replacement_DataTypeReceipt_Service_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_Service_Line_Replacement_DataTypeReceipt_Service_Line_Split_DataItem instanceof \StructType\Receipt_Service_Line_Split_DataType) {
                $invalidValues[] = is_object($receipt_Service_Line_Replacement_DataTypeReceipt_Service_Line_Split_DataItem) ? get_class($receipt_Service_Line_Replacement_DataTypeReceipt_Service_Line_Split_DataItem) : sprintf('%s(%s)', gettype($receipt_Service_Line_Replacement_DataTypeReceipt_Service_Line_Split_DataItem), var_export($receipt_Service_Line_Replacement_DataTypeReceipt_Service_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Service_Line_Split_Data property can only contain items of type \StructType\Receipt_Service_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Service_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Service_Line_Split_DataType[] $receipt_Service_Line_Split_Data
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function setReceipt_Service_Line_Split_Data(array $receipt_Service_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_Service_Line_Split_DataArrayErrorMessage = self::validateReceipt_Service_Line_Split_DataForArrayConstraintsFromSetReceipt_Service_Line_Split_Data($receipt_Service_Line_Split_Data))) {
            throw new \InvalidArgumentException($receipt_Service_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Service_Line_Split_Data = $receipt_Service_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Receipt_Service_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Service_Line_Split_DataType $item
     * @return \StructType\Receipt_Service_Line_Replacement_DataType
     */
    public function addToReceipt_Service_Line_Split_Data(\StructType\Receipt_Service_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_Service_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Service_Line_Split_Data property can only contain items of type \StructType\Receipt_Service_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Service_Line_Split_Data[] = $item;
        return $this;
    }
}
