<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_Invoice_Work_Queue_Tag_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing supplier invoice work queue tag reference for update and all supplier invoice work queue tag data items.
 * @subpackage Structs
 */
class Put_Supplier_Invoice_Work_Queue_Tag_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Work_Queue_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing supplier invoice work queue tag
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_TagObjectType
     */
    public $Supplier_Invoice_Work_Queue_Tag_Reference;
    /**
     * The Supplier_Invoice_Work_Queue_Tag_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier invoice work queue tag data
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_Tag_DataType
     */
    public $Supplier_Invoice_Work_Queue_Tag_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_Invoice_Work_Queue_Tag_RequestType
     * @uses Put_Supplier_Invoice_Work_Queue_Tag_RequestType::setSupplier_Invoice_Work_Queue_Tag_Reference()
     * @uses Put_Supplier_Invoice_Work_Queue_Tag_RequestType::setSupplier_Invoice_Work_Queue_Tag_Data()
     * @uses Put_Supplier_Invoice_Work_Queue_Tag_RequestType::setAdd_Only()
     * @uses Put_Supplier_Invoice_Work_Queue_Tag_RequestType::setVersion()
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType $supplier_Invoice_Work_Queue_Tag_Reference
     * @param \StructType\Supplier_Invoice_Work_Queue_Tag_DataType $supplier_Invoice_Work_Queue_Tag_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Supplier_Invoice_Work_Queue_TagObjectType $supplier_Invoice_Work_Queue_Tag_Reference = null, \StructType\Supplier_Invoice_Work_Queue_Tag_DataType $supplier_Invoice_Work_Queue_Tag_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Invoice_Work_Queue_Tag_Reference($supplier_Invoice_Work_Queue_Tag_Reference)
            ->setSupplier_Invoice_Work_Queue_Tag_Data($supplier_Invoice_Work_Queue_Tag_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Invoice_Work_Queue_Tag_Reference value
     * @return \StructType\Supplier_Invoice_Work_Queue_TagObjectType|null
     */
    public function getSupplier_Invoice_Work_Queue_Tag_Reference()
    {
        return $this->Supplier_Invoice_Work_Queue_Tag_Reference;
    }
    /**
     * Set Supplier_Invoice_Work_Queue_Tag_Reference value
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType $supplier_Invoice_Work_Queue_Tag_Reference
     * @return \StructType\Put_Supplier_Invoice_Work_Queue_Tag_RequestType
     */
    public function setSupplier_Invoice_Work_Queue_Tag_Reference(\StructType\Supplier_Invoice_Work_Queue_TagObjectType $supplier_Invoice_Work_Queue_Tag_Reference = null)
    {
        $this->Supplier_Invoice_Work_Queue_Tag_Reference = $supplier_Invoice_Work_Queue_Tag_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Work_Queue_Tag_Data value
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_DataType|null
     */
    public function getSupplier_Invoice_Work_Queue_Tag_Data()
    {
        return $this->Supplier_Invoice_Work_Queue_Tag_Data;
    }
    /**
     * Set Supplier_Invoice_Work_Queue_Tag_Data value
     * @param \StructType\Supplier_Invoice_Work_Queue_Tag_DataType $supplier_Invoice_Work_Queue_Tag_Data
     * @return \StructType\Put_Supplier_Invoice_Work_Queue_Tag_RequestType
     */
    public function setSupplier_Invoice_Work_Queue_Tag_Data(\StructType\Supplier_Invoice_Work_Queue_Tag_DataType $supplier_Invoice_Work_Queue_Tag_Data = null)
    {
        $this->Supplier_Invoice_Work_Queue_Tag_Data = $supplier_Invoice_Work_Queue_Tag_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Supplier_Invoice_Work_Queue_Tag_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_Invoice_Work_Queue_Tag_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
