<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_Contract_Document_Link_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Contract reference for update and all Supplier Contract data items that can be updated.
 * @subpackage Structs
 */
class Put_Supplier_Contract_Document_Link_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Contract for update only purposes.
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Contract_Document_Link
     * Meta information extracted from the WSDL
     * - documentation: Link to the external document captured on the contract.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Document_Link;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_Contract_Document_Link_RequestType
     * @uses Put_Supplier_Contract_Document_Link_RequestType::setSupplier_Contract_Reference()
     * @uses Put_Supplier_Contract_Document_Link_RequestType::setContract_Document_Link()
     * @uses Put_Supplier_Contract_Document_Link_RequestType::setVersion()
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param string $contract_Document_Link
     * @param string $version
     */
    public function __construct(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, $contract_Document_Link = null, $version = null)
    {
        $this
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setContract_Document_Link($contract_Document_Link)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Put_Supplier_Contract_Document_Link_RequestType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Contract_Document_Link value
     * @return string|null
     */
    public function getContract_Document_Link()
    {
        return $this->Contract_Document_Link;
    }
    /**
     * Set Contract_Document_Link value
     * @param string $contract_Document_Link
     * @return \StructType\Put_Supplier_Contract_Document_Link_RequestType
     */
    public function setContract_Document_Link($contract_Document_Link = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Document_Link) && !is_string($contract_Document_Link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Document_Link, true), gettype($contract_Document_Link)), __LINE__);
        }
        $this->Contract_Document_Link = $contract_Document_Link;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_Contract_Document_Link_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
