<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Revenue_Center_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Revenue Center reference to be returned as a response for web service.
 * @subpackage Structs
 */
class Put_Revenue_Center_ResponseType extends AbstractStructBase
{
    /**
     * The Revenue_Center_Reference
     * Meta information extracted from the WSDL
     * - documentation: Revenue Center Reference.
     * - minOccurs: 0
     * @var \StructType\Revenue_CenterObjectType
     */
    public $Revenue_Center_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Revenue_Center_ResponseType
     * @uses Put_Revenue_Center_ResponseType::setRevenue_Center_Reference()
     * @uses Put_Revenue_Center_ResponseType::setVersion()
     * @param \StructType\Revenue_CenterObjectType $revenue_Center_Reference
     * @param string $version
     */
    public function __construct(\StructType\Revenue_CenterObjectType $revenue_Center_Reference = null, $version = null)
    {
        $this
            ->setRevenue_Center_Reference($revenue_Center_Reference)
            ->setVersion($version);
    }
    /**
     * Get Revenue_Center_Reference value
     * @return \StructType\Revenue_CenterObjectType|null
     */
    public function getRevenue_Center_Reference()
    {
        return $this->Revenue_Center_Reference;
    }
    /**
     * Set Revenue_Center_Reference value
     * @param \StructType\Revenue_CenterObjectType $revenue_Center_Reference
     * @return \StructType\Put_Revenue_Center_ResponseType
     */
    public function setRevenue_Center_Reference(\StructType\Revenue_CenterObjectType $revenue_Center_Reference = null)
    {
        $this->Revenue_Center_Reference = $revenue_Center_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Revenue_Center_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
