<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Resource_Pool_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Put Resource Pool Top Level Request Element.
 * @subpackage Structs
 */
class Put_Resource_Pool_RequestType extends AbstractStructBase
{
    /**
     * The Resource_Pool_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool Instance.
     * - minOccurs: 0
     * @var \StructType\Resource_PoolObjectType
     */
    public $Resource_Pool_Reference;
    /**
     * The Resource_Pool_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Resource_Pool_DataType
     */
    public $Resource_Pool_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update. If an existing instance is found and this flag is set there will be an error.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Resource_Pool_RequestType
     * @uses Put_Resource_Pool_RequestType::setResource_Pool_Reference()
     * @uses Put_Resource_Pool_RequestType::setResource_Pool_Data()
     * @uses Put_Resource_Pool_RequestType::setAdd_Only()
     * @uses Put_Resource_Pool_RequestType::setVersion()
     * @param \StructType\Resource_PoolObjectType $resource_Pool_Reference
     * @param \StructType\Resource_Pool_DataType $resource_Pool_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Resource_PoolObjectType $resource_Pool_Reference = null, \StructType\Resource_Pool_DataType $resource_Pool_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setResource_Pool_Reference($resource_Pool_Reference)
            ->setResource_Pool_Data($resource_Pool_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Resource_Pool_Reference value
     * @return \StructType\Resource_PoolObjectType|null
     */
    public function getResource_Pool_Reference()
    {
        return $this->Resource_Pool_Reference;
    }
    /**
     * Set Resource_Pool_Reference value
     * @param \StructType\Resource_PoolObjectType $resource_Pool_Reference
     * @return \StructType\Put_Resource_Pool_RequestType
     */
    public function setResource_Pool_Reference(\StructType\Resource_PoolObjectType $resource_Pool_Reference = null)
    {
        $this->Resource_Pool_Reference = $resource_Pool_Reference;
        return $this;
    }
    /**
     * Get Resource_Pool_Data value
     * @return \StructType\Resource_Pool_DataType|null
     */
    public function getResource_Pool_Data()
    {
        return $this->Resource_Pool_Data;
    }
    /**
     * Set Resource_Pool_Data value
     * @param \StructType\Resource_Pool_DataType $resource_Pool_Data
     * @return \StructType\Put_Resource_Pool_RequestType
     */
    public function setResource_Pool_Data(\StructType\Resource_Pool_DataType $resource_Pool_Data = null)
    {
        $this->Resource_Pool_Data = $resource_Pool_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Resource_Pool_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Resource_Pool_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
