<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Requisition_Template_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Shared Requisition Template reference for update. Flag to indicate if this operation is add only, and all Shared Requisition Template data items required to create a complete Shared Requisition Template
 * @subpackage Structs
 */
class Put_Requisition_Template_RequestType extends AbstractStructBase
{
    /**
     * The Requisition_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Requisition Template for update only purposes
     * - minOccurs: 0
     * @var \StructType\Requisition_TemplateObjectType
     */
    public $Requisition_Template_Reference;
    /**
     * The Requisition_Template_Data
     * Meta information extracted from the WSDL
     * - documentation: Shared Requisition Template Data
     * @var \StructType\Requisition_Template_DataType
     */
    public $Requisition_Template_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Requisition_Template_RequestType
     * @uses Put_Requisition_Template_RequestType::setRequisition_Template_Reference()
     * @uses Put_Requisition_Template_RequestType::setRequisition_Template_Data()
     * @uses Put_Requisition_Template_RequestType::setAdd_Only()
     * @uses Put_Requisition_Template_RequestType::setVersion()
     * @param \StructType\Requisition_TemplateObjectType $requisition_Template_Reference
     * @param \StructType\Requisition_Template_DataType $requisition_Template_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Requisition_TemplateObjectType $requisition_Template_Reference = null, \StructType\Requisition_Template_DataType $requisition_Template_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setRequisition_Template_Reference($requisition_Template_Reference)
            ->setRequisition_Template_Data($requisition_Template_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Requisition_Template_Reference value
     * @return \StructType\Requisition_TemplateObjectType|null
     */
    public function getRequisition_Template_Reference()
    {
        return $this->Requisition_Template_Reference;
    }
    /**
     * Set Requisition_Template_Reference value
     * @param \StructType\Requisition_TemplateObjectType $requisition_Template_Reference
     * @return \StructType\Put_Requisition_Template_RequestType
     */
    public function setRequisition_Template_Reference(\StructType\Requisition_TemplateObjectType $requisition_Template_Reference = null)
    {
        $this->Requisition_Template_Reference = $requisition_Template_Reference;
        return $this;
    }
    /**
     * Get Requisition_Template_Data value
     * @return \StructType\Requisition_Template_DataType|null
     */
    public function getRequisition_Template_Data()
    {
        return $this->Requisition_Template_Data;
    }
    /**
     * Set Requisition_Template_Data value
     * @param \StructType\Requisition_Template_DataType $requisition_Template_Data
     * @return \StructType\Put_Requisition_Template_RequestType
     */
    public function setRequisition_Template_Data(\StructType\Requisition_Template_DataType $requisition_Template_Data = null)
    {
        $this->Requisition_Template_Data = $requisition_Template_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Requisition_Template_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Requisition_Template_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
