<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Requesting_Entity_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Requesting Entity reference for update and all Requesting Entity data items.
 * @subpackage Structs
 */
class Put_Requesting_Entity_RequestType extends AbstractStructBase
{
    /**
     * The Requesting_Entity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Requesting Entity for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Requesting_EntityObjectType
     */
    public $Requesting_Entity_Reference;
    /**
     * The Requesting_Entity_Data
     * Meta information extracted from the WSDL
     * - documentation: Requesting Entity Data
     * @var \StructType\Requesting_Entity_DataType
     */
    public $Requesting_Entity_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Requesting_Entity_RequestType
     * @uses Put_Requesting_Entity_RequestType::setRequesting_Entity_Reference()
     * @uses Put_Requesting_Entity_RequestType::setRequesting_Entity_Data()
     * @uses Put_Requesting_Entity_RequestType::setAdd_Only()
     * @uses Put_Requesting_Entity_RequestType::setVersion()
     * @param \StructType\Requesting_EntityObjectType $requesting_Entity_Reference
     * @param \StructType\Requesting_Entity_DataType $requesting_Entity_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Requesting_EntityObjectType $requesting_Entity_Reference = null, \StructType\Requesting_Entity_DataType $requesting_Entity_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setRequesting_Entity_Reference($requesting_Entity_Reference)
            ->setRequesting_Entity_Data($requesting_Entity_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Requesting_Entity_Reference value
     * @return \StructType\Requesting_EntityObjectType|null
     */
    public function getRequesting_Entity_Reference()
    {
        return $this->Requesting_Entity_Reference;
    }
    /**
     * Set Requesting_Entity_Reference value
     * @param \StructType\Requesting_EntityObjectType $requesting_Entity_Reference
     * @return \StructType\Put_Requesting_Entity_RequestType
     */
    public function setRequesting_Entity_Reference(\StructType\Requesting_EntityObjectType $requesting_Entity_Reference = null)
    {
        $this->Requesting_Entity_Reference = $requesting_Entity_Reference;
        return $this;
    }
    /**
     * Get Requesting_Entity_Data value
     * @return \StructType\Requesting_Entity_DataType|null
     */
    public function getRequesting_Entity_Data()
    {
        return $this->Requesting_Entity_Data;
    }
    /**
     * Set Requesting_Entity_Data value
     * @param \StructType\Requesting_Entity_DataType $requesting_Entity_Data
     * @return \StructType\Put_Requesting_Entity_RequestType
     */
    public function setRequesting_Entity_Data(\StructType\Requesting_Entity_DataType $requesting_Entity_Data = null)
    {
        $this->Requesting_Entity_Data = $requesting_Entity_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Requesting_Entity_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Requesting_Entity_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
