<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Invoice_Types_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element that includes the Invoice Type instance.
 * @subpackage Structs
 */
class Put_Invoice_Types_ResponseType extends AbstractStructBase
{
    /**
     * The Invoice_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a specific Invoice Type
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeObjectType
     */
    public $Invoice_Type_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Invoice_Types_ResponseType
     * @uses Put_Invoice_Types_ResponseType::setInvoice_Type_Reference()
     * @uses Put_Invoice_Types_ResponseType::setVersion()
     * @param \StructType\Invoice_TypeObjectType $invoice_Type_Reference
     * @param string $version
     */
    public function __construct(\StructType\Invoice_TypeObjectType $invoice_Type_Reference = null, $version = null)
    {
        $this
            ->setInvoice_Type_Reference($invoice_Type_Reference)
            ->setVersion($version);
    }
    /**
     * Get Invoice_Type_Reference value
     * @return \StructType\Invoice_TypeObjectType|null
     */
    public function getInvoice_Type_Reference()
    {
        return $this->Invoice_Type_Reference;
    }
    /**
     * Set Invoice_Type_Reference value
     * @param \StructType\Invoice_TypeObjectType $invoice_Type_Reference
     * @return \StructType\Put_Invoice_Types_ResponseType
     */
    public function setInvoice_Type_Reference(\StructType\Invoice_TypeObjectType $invoice_Type_Reference = null)
    {
        $this->Invoice_Type_Reference = $invoice_Type_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Invoice_Types_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
