<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Corporate_Credit_Card_Billing_Account_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Add Only Flag. Indicates that the service is an add only, not an update. | Element containing Corporate Credit Card Account reference for update and all Corporate Credit Card Account data items.
 * @subpackage Structs
 */
class Put_Corporate_Credit_Card_Billing_Account_RequestType extends AbstractStructBase
{
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Add_Only;
    /**
     * The Corporate_Credit_Card_Account_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Corporate Credit Card Account for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Corporate_Credit_Card_AccountObjectType
     */
    public $Corporate_Credit_Card_Account_Reference;
    /**
     * The Corporate_Credit_Card_Account_Data
     * Meta information extracted from the WSDL
     * - documentation: Corporate Credit Card Account Data.
     * @var \StructType\Corporate_Credit_Card_Account_DataType
     */
    public $Corporate_Credit_Card_Account_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Corporate_Credit_Card_Billing_Account_RequestType
     * @uses Put_Corporate_Credit_Card_Billing_Account_RequestType::setAdd_Only()
     * @uses Put_Corporate_Credit_Card_Billing_Account_RequestType::setCorporate_Credit_Card_Account_Reference()
     * @uses Put_Corporate_Credit_Card_Billing_Account_RequestType::setCorporate_Credit_Card_Account_Data()
     * @uses Put_Corporate_Credit_Card_Billing_Account_RequestType::setVersion()
     * @param bool $add_Only
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference
     * @param \StructType\Corporate_Credit_Card_Account_DataType $corporate_Credit_Card_Account_Data
     * @param string $version
     */
    public function __construct($add_Only = null, \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference = null, \StructType\Corporate_Credit_Card_Account_DataType $corporate_Credit_Card_Account_Data = null, $version = null)
    {
        $this
            ->setAdd_Only($add_Only)
            ->setCorporate_Credit_Card_Account_Reference($corporate_Credit_Card_Account_Reference)
            ->setCorporate_Credit_Card_Account_Data($corporate_Credit_Card_Account_Data)
            ->setVersion($version);
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Corporate_Credit_Card_Billing_Account_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Corporate_Credit_Card_Account_Reference value
     * @return \StructType\Corporate_Credit_Card_AccountObjectType|null
     */
    public function getCorporate_Credit_Card_Account_Reference()
    {
        return $this->Corporate_Credit_Card_Account_Reference;
    }
    /**
     * Set Corporate_Credit_Card_Account_Reference value
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference
     * @return \StructType\Put_Corporate_Credit_Card_Billing_Account_RequestType
     */
    public function setCorporate_Credit_Card_Account_Reference(\StructType\Corporate_Credit_Card_AccountObjectType $corporate_Credit_Card_Account_Reference = null)
    {
        $this->Corporate_Credit_Card_Account_Reference = $corporate_Credit_Card_Account_Reference;
        return $this;
    }
    /**
     * Get Corporate_Credit_Card_Account_Data value
     * @return \StructType\Corporate_Credit_Card_Account_DataType|null
     */
    public function getCorporate_Credit_Card_Account_Data()
    {
        return $this->Corporate_Credit_Card_Account_Data;
    }
    /**
     * Set Corporate_Credit_Card_Account_Data value
     * @param \StructType\Corporate_Credit_Card_Account_DataType $corporate_Credit_Card_Account_Data
     * @return \StructType\Put_Corporate_Credit_Card_Billing_Account_RequestType
     */
    public function setCorporate_Credit_Card_Account_Data(\StructType\Corporate_Credit_Card_Account_DataType $corporate_Credit_Card_Account_Data = null)
    {
        $this->Corporate_Credit_Card_Account_Data = $corporate_Credit_Card_Account_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Corporate_Credit_Card_Billing_Account_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
