<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Card_Holder_Listing_File_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; but the Card Holder Listing File already exists. | Element containing Card Holder Listing File reference for update and all Card Holder Listing File data items
 * @subpackage Structs
 */
class Put_Card_Holder_Listing_File_RequestType extends AbstractStructBase
{
    /**
     * The Card_Holder_Listing_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Card Holder Listing File for update only purposes
     * - minOccurs: 0
     * @var \StructType\Cardholder_Listing_FileObjectType
     */
    public $Card_Holder_Listing_File_Reference;
    /**
     * The Card_Holder_Listing_File_Data
     * Meta information extracted from the WSDL
     * - documentation: Card Holder Listing File Data
     * - minOccurs: 0
     * @var \StructType\Card_Holder_Listing_File_DataType
     */
    public $Card_Holder_Listing_File_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Card_Holder_Listing_File_RequestType
     * @uses Put_Card_Holder_Listing_File_RequestType::setCard_Holder_Listing_File_Reference()
     * @uses Put_Card_Holder_Listing_File_RequestType::setCard_Holder_Listing_File_Data()
     * @uses Put_Card_Holder_Listing_File_RequestType::setAdd_Only()
     * @uses Put_Card_Holder_Listing_File_RequestType::setVersion()
     * @param \StructType\Cardholder_Listing_FileObjectType $card_Holder_Listing_File_Reference
     * @param \StructType\Card_Holder_Listing_File_DataType $card_Holder_Listing_File_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Cardholder_Listing_FileObjectType $card_Holder_Listing_File_Reference = null, \StructType\Card_Holder_Listing_File_DataType $card_Holder_Listing_File_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setCard_Holder_Listing_File_Reference($card_Holder_Listing_File_Reference)
            ->setCard_Holder_Listing_File_Data($card_Holder_Listing_File_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Card_Holder_Listing_File_Reference value
     * @return \StructType\Cardholder_Listing_FileObjectType|null
     */
    public function getCard_Holder_Listing_File_Reference()
    {
        return $this->Card_Holder_Listing_File_Reference;
    }
    /**
     * Set Card_Holder_Listing_File_Reference value
     * @param \StructType\Cardholder_Listing_FileObjectType $card_Holder_Listing_File_Reference
     * @return \StructType\Put_Card_Holder_Listing_File_RequestType
     */
    public function setCard_Holder_Listing_File_Reference(\StructType\Cardholder_Listing_FileObjectType $card_Holder_Listing_File_Reference = null)
    {
        $this->Card_Holder_Listing_File_Reference = $card_Holder_Listing_File_Reference;
        return $this;
    }
    /**
     * Get Card_Holder_Listing_File_Data value
     * @return \StructType\Card_Holder_Listing_File_DataType|null
     */
    public function getCard_Holder_Listing_File_Data()
    {
        return $this->Card_Holder_Listing_File_Data;
    }
    /**
     * Set Card_Holder_Listing_File_Data value
     * @param \StructType\Card_Holder_Listing_File_DataType $card_Holder_Listing_File_Data
     * @return \StructType\Put_Card_Holder_Listing_File_RequestType
     */
    public function setCard_Holder_Listing_File_Data(\StructType\Card_Holder_Listing_File_DataType $card_Holder_Listing_File_Data = null)
    {
        $this->Card_Holder_Listing_File_Data = $card_Holder_Listing_File_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Card_Holder_Listing_File_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Card_Holder_Listing_File_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
