<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Airline_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Create a new Airline, or change 'Add Only' to 'false' to edit the existing Airline. | Put Airline Request
 * @subpackage Structs
 */
class Put_Airline_RequestType extends AbstractStructBase
{
    /**
     * The Airline_Reference
     * Meta information extracted from the WSDL
     * - documentation: Airline Reference
     * - minOccurs: 0
     * @var \StructType\AirlineObjectType
     */
    public $Airline_Reference;
    /**
     * The Airline_Data
     * Meta information extracted from the WSDL
     * - documentation: Airline Data
     * @var \StructType\Airline_DataType
     */
    public $Airline_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Airline_RequestType
     * @uses Put_Airline_RequestType::setAirline_Reference()
     * @uses Put_Airline_RequestType::setAirline_Data()
     * @uses Put_Airline_RequestType::setAdd_Only()
     * @uses Put_Airline_RequestType::setVersion()
     * @param \StructType\AirlineObjectType $airline_Reference
     * @param \StructType\Airline_DataType $airline_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\AirlineObjectType $airline_Reference = null, \StructType\Airline_DataType $airline_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setAirline_Reference($airline_Reference)
            ->setAirline_Data($airline_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Airline_Reference value
     * @return \StructType\AirlineObjectType|null
     */
    public function getAirline_Reference()
    {
        return $this->Airline_Reference;
    }
    /**
     * Set Airline_Reference value
     * @param \StructType\AirlineObjectType $airline_Reference
     * @return \StructType\Put_Airline_RequestType
     */
    public function setAirline_Reference(\StructType\AirlineObjectType $airline_Reference = null)
    {
        $this->Airline_Reference = $airline_Reference;
        return $this;
    }
    /**
     * Get Airline_Data value
     * @return \StructType\Airline_DataType|null
     */
    public function getAirline_Data()
    {
        return $this->Airline_Data;
    }
    /**
     * Set Airline_Data value
     * @param \StructType\Airline_DataType $airline_Data
     * @return \StructType\Put_Airline_RequestType
     */
    public function setAirline_Data(\StructType\Airline_DataType $airline_Data = null)
    {
        $this->Airline_Data = $airline_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Airline_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Airline_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
