<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Schedule_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You cannot specify a Withholding tax code in the transaction tax code reference | You can't specify a third party tax code in the transaction tax code reference. | Element containing Purchase Order Schedule Data
 * @subpackage Structs
 */
class Purchase_Order_Schedule_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Schedule_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Schedule Reference ID. This is the Purchase Order Schedule unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Order_Schedule_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit flag. The service will attempt to submit the schedule if this is on.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Schedule_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Schedule Status
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Schedule_Status_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing the schedule company.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing the schedule supplier.
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing the schedule currency.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing the schedule supplier contract.
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Supplier_Contract_Lines_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is a reference to an existing Supplier Contract Line that isn't used by another Supplier Contract type Schedule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Installment_ItemObjectType[]
     */
    public $Supplier_Contract_Lines_Reference;
    /**
     * The Schedule_Description
     * Meta information extracted from the WSDL
     * - documentation: Schedule Description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schedule_Description;
    /**
     * The Schedule_On_Hold
     * Meta information extracted from the WSDL
     * - documentation: Schedule On Hold flag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Schedule_On_Hold;
    /**
     * The Purchase_Order_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Type for the Supplier Contract Purchase Order Schedule. Note that Purchase Order types that are marked Bill Only cannot be used on the Purchase Order Schedule.
     * - minOccurs: 0
     * @var \StructType\Order_TypeObjectType
     */
    public $Purchase_Order_Type_Reference;
    /**
     * The Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the named buyer for the purchase order.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Buyer_Reference;
    /**
     * The Purchase_Order_Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order Issue Option
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Issue_OptionObjectType
     */
    public $Purchase_Order_Issue_Option_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Tax Code Reference
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing a unique instance of Payment Terms.
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Auto_submit_for_Approval
     * Meta information extracted from the WSDL
     * - documentation: Auto-Submit Purchase Orders for Approval Flag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Auto_submit_for_Approval;
    /**
     * The Override_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the override Supplier Invoice Payment Type.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Override_Payment_Type_Reference;
    /**
     * The Procurement_Card_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Procurement Card for the Purchase Order. If provided, the Payment Type reference must be set to Credit Card. If no Override Payment Type is supplied, then the Default Payment Type for the Supplier needs to be Credit
     * Card. Additionally, the Procurement Card must be valid for the Supplier or the Buyer.
     * - minOccurs: 0
     * @var \StructType\Worker_Credit_CardObjectType
     */
    public $Procurement_Card_Reference;
    /**
     * The Bill_To_Contact_Detail
     * Meta information extracted from the WSDL
     * - documentation: Name of the Bill-To Contact for the Purchase Order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bill_To_Contact_Detail;
    /**
     * The Bill_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Bill-To address.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Bill_To_Address_Reference;
    /**
     * The Ship_To_Contact_Detail
     * Meta information extracted from the WSDL
     * - documentation: Name of the Ship-To Contact for the Purchase Order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ship_To_Contact_Detail;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Ship-To address.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Distribution_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supplier Contract type Schedule Distribution Method. Valid values are: - Custom (CUSTOM). - Defined Installment (RECURRING). - Spread Even (EVEN).
     * - minOccurs: 0
     * @var \StructType\Schedule_Distribution_MethodObjectType
     */
    public $Distribution_Method_Reference;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference element representing the schedule Installment Frequency.
     * - minOccurs: 0
     * @var \StructType\Frequency_BehaviorObjectType
     */
    public $Frequency_Reference;
    /**
     * The From_Date
     * Meta information extracted from the WSDL
     * - documentation: From date. The system generates installments based on this value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From_Date;
    /**
     * The To_Date
     * Meta information extracted from the WSDL
     * - documentation: To date. The system generates installments based on this value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $To_Date;
    /**
     * The Number_of_Installments
     * Meta information extracted from the WSDL
     * - documentation: Number of installments. The system generates installments based on this value. | The Number of Installments to use when accounting for the Prepaid Amortization.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Installments;
    /**
     * The Date_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Date Option used for Installment generation. Valid values are: - Contract Line Start Date (LINE_START). - Contract Signed Date (CONTRACT_SIGNED). - Contract Start Date (CONTRACT_START). - Receipt Date (RECEIPT). -
     * Use From Date (SCHEDULE_FROM_DATE). - Use To Date (SCHEDULE_TO_DATE).
     * - minOccurs: 0
     * @var \StructType\Procurement_Date_OptionObjectType
     */
    public $Date_Option_Reference;
    /**
     * The Day_of_Month
     * Meta information extracted from the WSDL
     * - documentation: Day of Month. The system generates installments based on this value.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Day_of_Month;
    /**
     * The Automatically_Regenerate_Installments
     * Meta information extracted from the WSDL
     * - documentation: Automatically Regenerate Installments Flag. Use this flag to Regenerate installments when Supplier Contract Amendments are completed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Automatically_Regenerate_Installments;
    /**
     * The Automatically_Submit_Schedules
     * Meta information extracted from the WSDL
     * - documentation: Automatically Submit Schedules Flag. Use this flag when automatically regenerating installments when Supplier Contract Amendments are completed to automatically submit the Supplier Contract type Schedule.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Automatically_Submit_Schedules;
    /**
     * The System_Generated
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Purchase Order Schedule was System Generated. Not enterable for Submit Purchase Order Schedule web service. It is used only by Get Purchase Order Schedule web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $System_Generated;
    /**
     * The Purchase_Order_Installment_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Installment_Replacement_DataType[]
     */
    public $Purchase_Order_Installment_Replacement_Data;
    /**
     * Constructor method for Purchase_Order_Schedule_DataType
     * @uses Purchase_Order_Schedule_DataType::setPurchase_Order_Schedule_ID()
     * @uses Purchase_Order_Schedule_DataType::setSubmit()
     * @uses Purchase_Order_Schedule_DataType::setSchedule_Status_Reference()
     * @uses Purchase_Order_Schedule_DataType::setCompany_Reference()
     * @uses Purchase_Order_Schedule_DataType::setSupplier_Reference()
     * @uses Purchase_Order_Schedule_DataType::setCurrency_Reference()
     * @uses Purchase_Order_Schedule_DataType::setSupplier_Contract_Reference()
     * @uses Purchase_Order_Schedule_DataType::setSupplier_Contract_Lines_Reference()
     * @uses Purchase_Order_Schedule_DataType::setSchedule_Description()
     * @uses Purchase_Order_Schedule_DataType::setSchedule_On_Hold()
     * @uses Purchase_Order_Schedule_DataType::setPurchase_Order_Type_Reference()
     * @uses Purchase_Order_Schedule_DataType::setBuyer_Reference()
     * @uses Purchase_Order_Schedule_DataType::setPurchase_Order_Issue_Option_Reference()
     * @uses Purchase_Order_Schedule_DataType::setTax_Code_Reference()
     * @uses Purchase_Order_Schedule_DataType::setPayment_Terms_Reference()
     * @uses Purchase_Order_Schedule_DataType::setAuto_submit_for_Approval()
     * @uses Purchase_Order_Schedule_DataType::setOverride_Payment_Type_Reference()
     * @uses Purchase_Order_Schedule_DataType::setProcurement_Card_Reference()
     * @uses Purchase_Order_Schedule_DataType::setBill_To_Contact_Detail()
     * @uses Purchase_Order_Schedule_DataType::setBill_To_Address_Reference()
     * @uses Purchase_Order_Schedule_DataType::setShip_To_Contact_Detail()
     * @uses Purchase_Order_Schedule_DataType::setShip_To_Address_Reference()
     * @uses Purchase_Order_Schedule_DataType::setDistribution_Method_Reference()
     * @uses Purchase_Order_Schedule_DataType::setFrequency_Reference()
     * @uses Purchase_Order_Schedule_DataType::setFrom_Date()
     * @uses Purchase_Order_Schedule_DataType::setTo_Date()
     * @uses Purchase_Order_Schedule_DataType::setNumber_of_Installments()
     * @uses Purchase_Order_Schedule_DataType::setDate_Option_Reference()
     * @uses Purchase_Order_Schedule_DataType::setDay_of_Month()
     * @uses Purchase_Order_Schedule_DataType::setAutomatically_Regenerate_Installments()
     * @uses Purchase_Order_Schedule_DataType::setAutomatically_Submit_Schedules()
     * @uses Purchase_Order_Schedule_DataType::setSystem_Generated()
     * @uses Purchase_Order_Schedule_DataType::setPurchase_Order_Installment_Replacement_Data()
     * @param string $purchase_Order_Schedule_ID
     * @param bool $submit
     * @param \StructType\Document_StatusObjectType[] $schedule_Status_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Installment_ItemObjectType[] $supplier_Contract_Lines_Reference
     * @param string $schedule_Description
     * @param bool $schedule_On_Hold
     * @param \StructType\Order_TypeObjectType $purchase_Order_Type_Reference
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param bool $auto_submit_for_Approval
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @param \StructType\Worker_Credit_CardObjectType $procurement_Card_Reference
     * @param string $bill_To_Contact_Detail
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @param string $ship_To_Contact_Detail
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param \StructType\Schedule_Distribution_MethodObjectType $distribution_Method_Reference
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @param string $from_Date
     * @param string $to_Date
     * @param float $number_of_Installments
     * @param \StructType\Procurement_Date_OptionObjectType $date_Option_Reference
     * @param float $day_of_Month
     * @param bool $automatically_Regenerate_Installments
     * @param bool $automatically_Submit_Schedules
     * @param bool $system_Generated
     * @param \StructType\Purchase_Order_Installment_Replacement_DataType[] $purchase_Order_Installment_Replacement_Data
     */
    public function __construct($purchase_Order_Schedule_ID = null, $submit = null, array $schedule_Status_Reference = array(), \StructType\CompanyObjectType $company_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, array $supplier_Contract_Lines_Reference = array(), $schedule_Description = null, $schedule_On_Hold = null, \StructType\Order_TypeObjectType $purchase_Order_Type_Reference = null, \StructType\WorkerObjectType $buyer_Reference = null, \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, $auto_submit_for_Approval = null, \StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null, \StructType\Worker_Credit_CardObjectType $procurement_Card_Reference = null, $bill_To_Contact_Detail = null, \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null, $ship_To_Contact_Detail = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, \StructType\Schedule_Distribution_MethodObjectType $distribution_Method_Reference = null, \StructType\Frequency_BehaviorObjectType $frequency_Reference = null, $from_Date = null, $to_Date = null, $number_of_Installments = null, \StructType\Procurement_Date_OptionObjectType $date_Option_Reference = null, $day_of_Month = null, $automatically_Regenerate_Installments = null, $automatically_Submit_Schedules = null, $system_Generated = null, array $purchase_Order_Installment_Replacement_Data = array())
    {
        $this
            ->setPurchase_Order_Schedule_ID($purchase_Order_Schedule_ID)
            ->setSubmit($submit)
            ->setSchedule_Status_Reference($schedule_Status_Reference)
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setSupplier_Contract_Lines_Reference($supplier_Contract_Lines_Reference)
            ->setSchedule_Description($schedule_Description)
            ->setSchedule_On_Hold($schedule_On_Hold)
            ->setPurchase_Order_Type_Reference($purchase_Order_Type_Reference)
            ->setBuyer_Reference($buyer_Reference)
            ->setPurchase_Order_Issue_Option_Reference($purchase_Order_Issue_Option_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setAuto_submit_for_Approval($auto_submit_for_Approval)
            ->setOverride_Payment_Type_Reference($override_Payment_Type_Reference)
            ->setProcurement_Card_Reference($procurement_Card_Reference)
            ->setBill_To_Contact_Detail($bill_To_Contact_Detail)
            ->setBill_To_Address_Reference($bill_To_Address_Reference)
            ->setShip_To_Contact_Detail($ship_To_Contact_Detail)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setDistribution_Method_Reference($distribution_Method_Reference)
            ->setFrequency_Reference($frequency_Reference)
            ->setFrom_Date($from_Date)
            ->setTo_Date($to_Date)
            ->setNumber_of_Installments($number_of_Installments)
            ->setDate_Option_Reference($date_Option_Reference)
            ->setDay_of_Month($day_of_Month)
            ->setAutomatically_Regenerate_Installments($automatically_Regenerate_Installments)
            ->setAutomatically_Submit_Schedules($automatically_Submit_Schedules)
            ->setSystem_Generated($system_Generated)
            ->setPurchase_Order_Installment_Replacement_Data($purchase_Order_Installment_Replacement_Data);
    }
    /**
     * Get Purchase_Order_Schedule_ID value
     * @return string|null
     */
    public function getPurchase_Order_Schedule_ID()
    {
        return $this->Purchase_Order_Schedule_ID;
    }
    /**
     * Set Purchase_Order_Schedule_ID value
     * @param string $purchase_Order_Schedule_ID
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setPurchase_Order_Schedule_ID($purchase_Order_Schedule_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Schedule_ID) && !is_string($purchase_Order_Schedule_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Schedule_ID, true), gettype($purchase_Order_Schedule_ID)), __LINE__);
        }
        $this->Purchase_Order_Schedule_ID = $purchase_Order_Schedule_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Schedule_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getSchedule_Status_Reference()
    {
        return $this->Schedule_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSchedule_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchedule_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchedule_Status_ReferenceForArrayConstraintsFromSetSchedule_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Schedule_DataTypeSchedule_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Schedule_DataTypeSchedule_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($purchase_Order_Schedule_DataTypeSchedule_Status_ReferenceItem) ? get_class($purchase_Order_Schedule_DataTypeSchedule_Status_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Schedule_DataTypeSchedule_Status_ReferenceItem), var_export($purchase_Order_Schedule_DataTypeSchedule_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schedule_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schedule_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $schedule_Status_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setSchedule_Status_Reference(array $schedule_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($schedule_Status_ReferenceArrayErrorMessage = self::validateSchedule_Status_ReferenceForArrayConstraintsFromSetSchedule_Status_Reference($schedule_Status_Reference))) {
            throw new \InvalidArgumentException($schedule_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Schedule_Status_Reference = $schedule_Status_Reference;
        return $this;
    }
    /**
     * Add item to Schedule_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function addToSchedule_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Schedule_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schedule_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Lines_Reference value
     * @return \StructType\Installment_ItemObjectType[]|null
     */
    public function getSupplier_Contract_Lines_Reference()
    {
        return $this->Supplier_Contract_Lines_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Lines_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Lines_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_Lines_ReferenceForArrayConstraintsFromSetSupplier_Contract_Lines_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem instanceof \StructType\Installment_ItemObjectType) {
                $invalidValues[] = is_object($purchase_Order_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem) ? get_class($purchase_Order_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem), var_export($purchase_Order_Schedule_DataTypeSupplier_Contract_Lines_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Lines_Reference property can only contain items of type \StructType\Installment_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Lines_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Installment_ItemObjectType[] $supplier_Contract_Lines_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setSupplier_Contract_Lines_Reference(array $supplier_Contract_Lines_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_Lines_ReferenceArrayErrorMessage = self::validateSupplier_Contract_Lines_ReferenceForArrayConstraintsFromSetSupplier_Contract_Lines_Reference($supplier_Contract_Lines_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_Lines_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Lines_Reference = $supplier_Contract_Lines_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Lines_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Installment_ItemObjectType $item
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function addToSupplier_Contract_Lines_Reference(\StructType\Installment_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Installment_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Lines_Reference property can only contain items of type \StructType\Installment_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Lines_Reference[] = $item;
        return $this;
    }
    /**
     * Get Schedule_Description value
     * @return string|null
     */
    public function getSchedule_Description()
    {
        return $this->Schedule_Description;
    }
    /**
     * Set Schedule_Description value
     * @param string $schedule_Description
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setSchedule_Description($schedule_Description = null)
    {
        // validation for constraint: string
        if (!is_null($schedule_Description) && !is_string($schedule_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedule_Description, true), gettype($schedule_Description)), __LINE__);
        }
        $this->Schedule_Description = $schedule_Description;
        return $this;
    }
    /**
     * Get Schedule_On_Hold value
     * @return bool|null
     */
    public function getSchedule_On_Hold()
    {
        return $this->Schedule_On_Hold;
    }
    /**
     * Set Schedule_On_Hold value
     * @param bool $schedule_On_Hold
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setSchedule_On_Hold($schedule_On_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($schedule_On_Hold) && !is_bool($schedule_On_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($schedule_On_Hold, true), gettype($schedule_On_Hold)), __LINE__);
        }
        $this->Schedule_On_Hold = $schedule_On_Hold;
        return $this;
    }
    /**
     * Get Purchase_Order_Type_Reference value
     * @return \StructType\Order_TypeObjectType|null
     */
    public function getPurchase_Order_Type_Reference()
    {
        return $this->Purchase_Order_Type_Reference;
    }
    /**
     * Set Purchase_Order_Type_Reference value
     * @param \StructType\Order_TypeObjectType $purchase_Order_Type_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setPurchase_Order_Type_Reference(\StructType\Order_TypeObjectType $purchase_Order_Type_Reference = null)
    {
        $this->Purchase_Order_Type_Reference = $purchase_Order_Type_Reference;
        return $this;
    }
    /**
     * Get Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getBuyer_Reference()
    {
        return $this->Buyer_Reference;
    }
    /**
     * Set Buyer_Reference value
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setBuyer_Reference(\StructType\WorkerObjectType $buyer_Reference = null)
    {
        $this->Buyer_Reference = $buyer_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType|null
     */
    public function getPurchase_Order_Issue_Option_Reference()
    {
        return $this->Purchase_Order_Issue_Option_Reference;
    }
    /**
     * Set Purchase_Order_Issue_Option_Reference value
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setPurchase_Order_Issue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference = null)
    {
        $this->Purchase_Order_Issue_Option_Reference = $purchase_Order_Issue_Option_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Auto_submit_for_Approval value
     * @return bool|null
     */
    public function getAuto_submit_for_Approval()
    {
        return $this->{'Auto-submit_for_Approval'};
    }
    /**
     * Set Auto_submit_for_Approval value
     * @param bool $auto_submit_for_Approval
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setAuto_submit_for_Approval($auto_submit_for_Approval = null)
    {
        // validation for constraint: boolean
        if (!is_null($auto_submit_for_Approval) && !is_bool($auto_submit_for_Approval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($auto_submit_for_Approval, true), gettype($auto_submit_for_Approval)), __LINE__);
        }
        $this->Auto_submit_for_Approval = $this->{'Auto-submit_for_Approval'} = $auto_submit_for_Approval;
        return $this;
    }
    /**
     * Get Override_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getOverride_Payment_Type_Reference()
    {
        return $this->Override_Payment_Type_Reference;
    }
    /**
     * Set Override_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setOverride_Payment_Type_Reference(\StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null)
    {
        $this->Override_Payment_Type_Reference = $override_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Procurement_Card_Reference value
     * @return \StructType\Worker_Credit_CardObjectType|null
     */
    public function getProcurement_Card_Reference()
    {
        return $this->Procurement_Card_Reference;
    }
    /**
     * Set Procurement_Card_Reference value
     * @param \StructType\Worker_Credit_CardObjectType $procurement_Card_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setProcurement_Card_Reference(\StructType\Worker_Credit_CardObjectType $procurement_Card_Reference = null)
    {
        $this->Procurement_Card_Reference = $procurement_Card_Reference;
        return $this;
    }
    /**
     * Get Bill_To_Contact_Detail value
     * @return string|null
     */
    public function getBill_To_Contact_Detail()
    {
        return $this->{'Bill-To_Contact_Detail'};
    }
    /**
     * Set Bill_To_Contact_Detail value
     * @param string $bill_To_Contact_Detail
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setBill_To_Contact_Detail($bill_To_Contact_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($bill_To_Contact_Detail) && !is_string($bill_To_Contact_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_To_Contact_Detail, true), gettype($bill_To_Contact_Detail)), __LINE__);
        }
        $this->Bill_To_Contact_Detail = $this->{'Bill-To_Contact_Detail'} = $bill_To_Contact_Detail;
        return $this;
    }
    /**
     * Get Bill_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getBill_To_Address_Reference()
    {
        return $this->{'Bill-To_Address_Reference'};
    }
    /**
     * Set Bill_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setBill_To_Address_Reference(\StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null)
    {
        $this->Bill_To_Address_Reference = $this->{'Bill-To_Address_Reference'} = $bill_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Detail value
     * @return string|null
     */
    public function getShip_To_Contact_Detail()
    {
        return $this->{'Ship-To_Contact_Detail'};
    }
    /**
     * Set Ship_To_Contact_Detail value
     * @param string $ship_To_Contact_Detail
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setShip_To_Contact_Detail($ship_To_Contact_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($ship_To_Contact_Detail) && !is_string($ship_To_Contact_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ship_To_Contact_Detail, true), gettype($ship_To_Contact_Detail)), __LINE__);
        }
        $this->Ship_To_Contact_Detail = $this->{'Ship-To_Contact_Detail'} = $ship_To_Contact_Detail;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Distribution_Method_Reference value
     * @return \StructType\Schedule_Distribution_MethodObjectType|null
     */
    public function getDistribution_Method_Reference()
    {
        return $this->Distribution_Method_Reference;
    }
    /**
     * Set Distribution_Method_Reference value
     * @param \StructType\Schedule_Distribution_MethodObjectType $distribution_Method_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setDistribution_Method_Reference(\StructType\Schedule_Distribution_MethodObjectType $distribution_Method_Reference = null)
    {
        $this->Distribution_Method_Reference = $distribution_Method_Reference;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\Frequency_BehaviorObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setFrequency_Reference(\StructType\Frequency_BehaviorObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get From_Date value
     * @return string|null
     */
    public function getFrom_Date()
    {
        return $this->From_Date;
    }
    /**
     * Set From_Date value
     * @param string $from_Date
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setFrom_Date($from_Date = null)
    {
        // validation for constraint: string
        if (!is_null($from_Date) && !is_string($from_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from_Date, true), gettype($from_Date)), __LINE__);
        }
        $this->From_Date = $from_Date;
        return $this;
    }
    /**
     * Get To_Date value
     * @return string|null
     */
    public function getTo_Date()
    {
        return $this->To_Date;
    }
    /**
     * Set To_Date value
     * @param string $to_Date
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setTo_Date($to_Date = null)
    {
        // validation for constraint: string
        if (!is_null($to_Date) && !is_string($to_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to_Date, true), gettype($to_Date)), __LINE__);
        }
        $this->To_Date = $to_Date;
        return $this;
    }
    /**
     * Get Number_of_Installments value
     * @return float|null
     */
    public function getNumber_of_Installments()
    {
        return $this->Number_of_Installments;
    }
    /**
     * Set Number_of_Installments value
     * @param float $number_of_Installments
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setNumber_of_Installments($number_of_Installments = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Installments) && !(is_float($number_of_Installments) || is_numeric($number_of_Installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Installments, true), gettype($number_of_Installments)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Installments) && mb_strlen(mb_substr($number_of_Installments, false !== mb_strpos($number_of_Installments, '.') ? mb_strpos($number_of_Installments, '.') + 1 : mb_strlen($number_of_Installments))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Installments, true), mb_strlen(mb_substr($number_of_Installments, mb_strpos($number_of_Installments, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Installments) && $number_of_Installments < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Installments, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Installments) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Installments)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Installments, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Installments))), __LINE__);
        }
        $this->Number_of_Installments = $number_of_Installments;
        return $this;
    }
    /**
     * Get Date_Option_Reference value
     * @return \StructType\Procurement_Date_OptionObjectType|null
     */
    public function getDate_Option_Reference()
    {
        return $this->Date_Option_Reference;
    }
    /**
     * Set Date_Option_Reference value
     * @param \StructType\Procurement_Date_OptionObjectType $date_Option_Reference
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setDate_Option_Reference(\StructType\Procurement_Date_OptionObjectType $date_Option_Reference = null)
    {
        $this->Date_Option_Reference = $date_Option_Reference;
        return $this;
    }
    /**
     * Get Day_of_Month value
     * @return float|null
     */
    public function getDay_of_Month()
    {
        return $this->Day_of_Month;
    }
    /**
     * Set Day_of_Month value
     * @param float $day_of_Month
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setDay_of_Month($day_of_Month = null)
    {
        // validation for constraint: float
        if (!is_null($day_of_Month) && !(is_float($day_of_Month) || is_numeric($day_of_Month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($day_of_Month, true), gettype($day_of_Month)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($day_of_Month) && mb_strlen(mb_substr($day_of_Month, false !== mb_strpos($day_of_Month, '.') ? mb_strpos($day_of_Month, '.') + 1 : mb_strlen($day_of_Month))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($day_of_Month, true), mb_strlen(mb_substr($day_of_Month, mb_strpos($day_of_Month, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($day_of_Month) && $day_of_Month < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($day_of_Month, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($day_of_Month) && mb_strlen(preg_replace('/(\D)/', '', $day_of_Month)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($day_of_Month, true), mb_strlen(preg_replace('/(\D)/', '', $day_of_Month))), __LINE__);
        }
        $this->Day_of_Month = $day_of_Month;
        return $this;
    }
    /**
     * Get Automatically_Regenerate_Installments value
     * @return bool|null
     */
    public function getAutomatically_Regenerate_Installments()
    {
        return $this->Automatically_Regenerate_Installments;
    }
    /**
     * Set Automatically_Regenerate_Installments value
     * @param bool $automatically_Regenerate_Installments
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setAutomatically_Regenerate_Installments($automatically_Regenerate_Installments = null)
    {
        // validation for constraint: boolean
        if (!is_null($automatically_Regenerate_Installments) && !is_bool($automatically_Regenerate_Installments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automatically_Regenerate_Installments, true), gettype($automatically_Regenerate_Installments)), __LINE__);
        }
        $this->Automatically_Regenerate_Installments = $automatically_Regenerate_Installments;
        return $this;
    }
    /**
     * Get Automatically_Submit_Schedules value
     * @return bool|null
     */
    public function getAutomatically_Submit_Schedules()
    {
        return $this->Automatically_Submit_Schedules;
    }
    /**
     * Set Automatically_Submit_Schedules value
     * @param bool $automatically_Submit_Schedules
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setAutomatically_Submit_Schedules($automatically_Submit_Schedules = null)
    {
        // validation for constraint: boolean
        if (!is_null($automatically_Submit_Schedules) && !is_bool($automatically_Submit_Schedules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automatically_Submit_Schedules, true), gettype($automatically_Submit_Schedules)), __LINE__);
        }
        $this->Automatically_Submit_Schedules = $automatically_Submit_Schedules;
        return $this;
    }
    /**
     * Get System_Generated value
     * @return bool|null
     */
    public function getSystem_Generated()
    {
        return $this->System_Generated;
    }
    /**
     * Set System_Generated value
     * @param bool $system_Generated
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setSystem_Generated($system_Generated = null)
    {
        // validation for constraint: boolean
        if (!is_null($system_Generated) && !is_bool($system_Generated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($system_Generated, true), gettype($system_Generated)), __LINE__);
        }
        $this->System_Generated = $system_Generated;
        return $this;
    }
    /**
     * Get Purchase_Order_Installment_Replacement_Data value
     * @return \StructType\Purchase_Order_Installment_Replacement_DataType[]|null
     */
    public function getPurchase_Order_Installment_Replacement_Data()
    {
        return $this->Purchase_Order_Installment_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Installment_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Installment_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Installment_Replacement_DataForArrayConstraintsFromSetPurchase_Order_Installment_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Schedule_DataTypePurchase_Order_Installment_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Schedule_DataTypePurchase_Order_Installment_Replacement_DataItem instanceof \StructType\Purchase_Order_Installment_Replacement_DataType) {
                $invalidValues[] = is_object($purchase_Order_Schedule_DataTypePurchase_Order_Installment_Replacement_DataItem) ? get_class($purchase_Order_Schedule_DataTypePurchase_Order_Installment_Replacement_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_Schedule_DataTypePurchase_Order_Installment_Replacement_DataItem), var_export($purchase_Order_Schedule_DataTypePurchase_Order_Installment_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Installment_Replacement_Data property can only contain items of type \StructType\Purchase_Order_Installment_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Installment_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Installment_Replacement_DataType[] $purchase_Order_Installment_Replacement_Data
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function setPurchase_Order_Installment_Replacement_Data(array $purchase_Order_Installment_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Installment_Replacement_DataArrayErrorMessage = self::validatePurchase_Order_Installment_Replacement_DataForArrayConstraintsFromSetPurchase_Order_Installment_Replacement_Data($purchase_Order_Installment_Replacement_Data))) {
            throw new \InvalidArgumentException($purchase_Order_Installment_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Installment_Replacement_Data = $purchase_Order_Installment_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Installment_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Installment_Replacement_DataType $item
     * @return \StructType\Purchase_Order_Schedule_DataType
     */
    public function addToPurchase_Order_Installment_Replacement_Data(\StructType\Purchase_Order_Installment_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Installment_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Installment_Replacement_Data property can only contain items of type \StructType\Purchase_Order_Installment_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Installment_Replacement_Data[] = $item;
        return $this;
    }
}
