<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_ScheduleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Purchase Order Schedule Instance and Data
 * @subpackage Structs
 */
class Purchase_Order_ScheduleType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Schedule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order Schedule
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_ScheduleObjectType
     */
    public $Purchase_Order_Schedule_Reference;
    /**
     * The Purchase_Order_Schedule_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Schedule_DataType[]
     */
    public $Purchase_Order_Schedule_Data;
    /**
     * Constructor method for Purchase_Order_ScheduleType
     * @uses Purchase_Order_ScheduleType::setPurchase_Order_Schedule_Reference()
     * @uses Purchase_Order_ScheduleType::setPurchase_Order_Schedule_Data()
     * @param \StructType\Purchase_Order_ScheduleObjectType $purchase_Order_Schedule_Reference
     * @param \StructType\Purchase_Order_Schedule_DataType[] $purchase_Order_Schedule_Data
     */
    public function __construct(\StructType\Purchase_Order_ScheduleObjectType $purchase_Order_Schedule_Reference = null, array $purchase_Order_Schedule_Data = array())
    {
        $this
            ->setPurchase_Order_Schedule_Reference($purchase_Order_Schedule_Reference)
            ->setPurchase_Order_Schedule_Data($purchase_Order_Schedule_Data);
    }
    /**
     * Get Purchase_Order_Schedule_Reference value
     * @return \StructType\Purchase_Order_ScheduleObjectType|null
     */
    public function getPurchase_Order_Schedule_Reference()
    {
        return $this->Purchase_Order_Schedule_Reference;
    }
    /**
     * Set Purchase_Order_Schedule_Reference value
     * @param \StructType\Purchase_Order_ScheduleObjectType $purchase_Order_Schedule_Reference
     * @return \StructType\Purchase_Order_ScheduleType
     */
    public function setPurchase_Order_Schedule_Reference(\StructType\Purchase_Order_ScheduleObjectType $purchase_Order_Schedule_Reference = null)
    {
        $this->Purchase_Order_Schedule_Reference = $purchase_Order_Schedule_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Schedule_Data value
     * @return \StructType\Purchase_Order_Schedule_DataType[]|null
     */
    public function getPurchase_Order_Schedule_Data()
    {
        return $this->Purchase_Order_Schedule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Schedule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Schedule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Schedule_DataForArrayConstraintsFromSetPurchase_Order_Schedule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_ScheduleTypePurchase_Order_Schedule_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_ScheduleTypePurchase_Order_Schedule_DataItem instanceof \StructType\Purchase_Order_Schedule_DataType) {
                $invalidValues[] = is_object($purchase_Order_ScheduleTypePurchase_Order_Schedule_DataItem) ? get_class($purchase_Order_ScheduleTypePurchase_Order_Schedule_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_ScheduleTypePurchase_Order_Schedule_DataItem), var_export($purchase_Order_ScheduleTypePurchase_Order_Schedule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Schedule_Data property can only contain items of type \StructType\Purchase_Order_Schedule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Schedule_DataType[] $purchase_Order_Schedule_Data
     * @return \StructType\Purchase_Order_ScheduleType
     */
    public function setPurchase_Order_Schedule_Data(array $purchase_Order_Schedule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Schedule_DataArrayErrorMessage = self::validatePurchase_Order_Schedule_DataForArrayConstraintsFromSetPurchase_Order_Schedule_Data($purchase_Order_Schedule_Data))) {
            throw new \InvalidArgumentException($purchase_Order_Schedule_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Schedule_Data = $purchase_Order_Schedule_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Schedule_DataType $item
     * @return \StructType\Purchase_Order_ScheduleType
     */
    public function addToPurchase_Order_Schedule_Data(\StructType\Purchase_Order_Schedule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Schedule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Schedule_Data property can only contain items of type \StructType\Purchase_Order_Schedule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Schedule_Data[] = $item;
        return $this;
    }
}
