<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Acknowledgement_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Purchase Order Acknowledgements Response Data
 * @subpackage Structs
 */
class Purchase_Order_Acknowledgement_OutboundType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Acknowledgement_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order Acknowledgement
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_AcknowledgementObjectType
     */
    public $Purchase_Order_Acknowledgement_Reference;
    /**
     * The Purchase_Order_Acknowledgement_Data
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Acknowledgement Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Acknowledgement_DataType[]
     */
    public $Purchase_Order_Acknowledgement_Data;
    /**
     * Constructor method for Purchase_Order_Acknowledgement_OutboundType
     * @uses Purchase_Order_Acknowledgement_OutboundType::setPurchase_Order_Acknowledgement_Reference()
     * @uses Purchase_Order_Acknowledgement_OutboundType::setPurchase_Order_Acknowledgement_Data()
     * @param \StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference
     * @param \StructType\Purchase_Order_Acknowledgement_DataType[] $purchase_Order_Acknowledgement_Data
     */
    public function __construct(\StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference = null, array $purchase_Order_Acknowledgement_Data = array())
    {
        $this
            ->setPurchase_Order_Acknowledgement_Reference($purchase_Order_Acknowledgement_Reference)
            ->setPurchase_Order_Acknowledgement_Data($purchase_Order_Acknowledgement_Data);
    }
    /**
     * Get Purchase_Order_Acknowledgement_Reference value
     * @return \StructType\Purchase_Order_AcknowledgementObjectType|null
     */
    public function getPurchase_Order_Acknowledgement_Reference()
    {
        return $this->Purchase_Order_Acknowledgement_Reference;
    }
    /**
     * Set Purchase_Order_Acknowledgement_Reference value
     * @param \StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_OutboundType
     */
    public function setPurchase_Order_Acknowledgement_Reference(\StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference = null)
    {
        $this->Purchase_Order_Acknowledgement_Reference = $purchase_Order_Acknowledgement_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Acknowledgement_Data value
     * @return \StructType\Purchase_Order_Acknowledgement_DataType[]|null
     */
    public function getPurchase_Order_Acknowledgement_Data()
    {
        return $this->Purchase_Order_Acknowledgement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Acknowledgement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Acknowledgement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Acknowledgement_DataForArrayConstraintsFromSetPurchase_Order_Acknowledgement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Acknowledgement_OutboundTypePurchase_Order_Acknowledgement_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Acknowledgement_OutboundTypePurchase_Order_Acknowledgement_DataItem instanceof \StructType\Purchase_Order_Acknowledgement_DataType) {
                $invalidValues[] = is_object($purchase_Order_Acknowledgement_OutboundTypePurchase_Order_Acknowledgement_DataItem) ? get_class($purchase_Order_Acknowledgement_OutboundTypePurchase_Order_Acknowledgement_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_Acknowledgement_OutboundTypePurchase_Order_Acknowledgement_DataItem), var_export($purchase_Order_Acknowledgement_OutboundTypePurchase_Order_Acknowledgement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Acknowledgement_Data property can only contain items of type \StructType\Purchase_Order_Acknowledgement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Acknowledgement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Acknowledgement_DataType[] $purchase_Order_Acknowledgement_Data
     * @return \StructType\Purchase_Order_Acknowledgement_OutboundType
     */
    public function setPurchase_Order_Acknowledgement_Data(array $purchase_Order_Acknowledgement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Acknowledgement_DataArrayErrorMessage = self::validatePurchase_Order_Acknowledgement_DataForArrayConstraintsFromSetPurchase_Order_Acknowledgement_Data($purchase_Order_Acknowledgement_Data))) {
            throw new \InvalidArgumentException($purchase_Order_Acknowledgement_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Acknowledgement_Data = $purchase_Order_Acknowledgement_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Acknowledgement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Acknowledgement_DataType $item
     * @return \StructType\Purchase_Order_Acknowledgement_OutboundType
     */
    public function addToPurchase_Order_Acknowledgement_Data(\StructType\Purchase_Order_Acknowledgement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Acknowledgement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Acknowledgement_Data property can only contain items of type \StructType\Purchase_Order_Acknowledgement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Acknowledgement_Data[] = $item;
        return $this;
    }
}
