<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Purchase Item response grouping options
 * @subpackage Structs
 */
class Purchase_Item_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Include Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Exclude_Item_Images
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the item image data should be excluded from the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Item_Images;
    /**
     * Constructor method for Purchase_Item_Response_GroupType
     * @uses Purchase_Item_Response_GroupType::setInclude_Reference()
     * @uses Purchase_Item_Response_GroupType::setExclude_Item_Images()
     * @param bool $include_Reference
     * @param bool $exclude_Item_Images
     */
    public function __construct($include_Reference = null, $exclude_Item_Images = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setExclude_Item_Images($exclude_Item_Images);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Purchase_Item_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Exclude_Item_Images value
     * @return bool|null
     */
    public function getExclude_Item_Images()
    {
        return $this->Exclude_Item_Images;
    }
    /**
     * Set Exclude_Item_Images value
     * @param bool $exclude_Item_Images
     * @return \StructType\Purchase_Item_Response_GroupType
     */
    public function setExclude_Item_Images($exclude_Item_Images = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Item_Images) && !is_bool($exclude_Item_Images)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Item_Images, true), gettype($exclude_Item_Images)), __LINE__);
        }
        $this->Exclude_Item_Images = $exclude_Item_Images;
        return $this;
    }
}
