<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_Type_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Purchase Item Request Type
 * @subpackage Structs
 */
class Purchase_Item_Request_Type_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Request_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Item Request Type
     * - maxOccurs: unbounded
     * @var \StructType\Purchase_Item_Request_TypeObjectType[]
     */
    public $Purchase_Item_Request_Type_Reference;
    /**
     * Constructor method for Purchase_Item_Request_Type_Request_ReferencesType
     * @uses Purchase_Item_Request_Type_Request_ReferencesType::setPurchase_Item_Request_Type_Reference()
     * @param \StructType\Purchase_Item_Request_TypeObjectType[] $purchase_Item_Request_Type_Reference
     */
    public function __construct(array $purchase_Item_Request_Type_Reference = array())
    {
        $this
            ->setPurchase_Item_Request_Type_Reference($purchase_Item_Request_Type_Reference);
    }
    /**
     * Get Purchase_Item_Request_Type_Reference value
     * @return \StructType\Purchase_Item_Request_TypeObjectType[]|null
     */
    public function getPurchase_Item_Request_Type_Reference()
    {
        return $this->Purchase_Item_Request_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Request_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Request_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_Request_Type_ReferenceForArrayConstraintsFromSetPurchase_Item_Request_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_Type_Request_ReferencesTypePurchase_Item_Request_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_Type_Request_ReferencesTypePurchase_Item_Request_Type_ReferenceItem instanceof \StructType\Purchase_Item_Request_TypeObjectType) {
                $invalidValues[] = is_object($purchase_Item_Request_Type_Request_ReferencesTypePurchase_Item_Request_Type_ReferenceItem) ? get_class($purchase_Item_Request_Type_Request_ReferencesTypePurchase_Item_Request_Type_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_Type_Request_ReferencesTypePurchase_Item_Request_Type_ReferenceItem), var_export($purchase_Item_Request_Type_Request_ReferencesTypePurchase_Item_Request_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Request_Type_Reference property can only contain items of type \StructType\Purchase_Item_Request_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Request_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_TypeObjectType[] $purchase_Item_Request_Type_Reference
     * @return \StructType\Purchase_Item_Request_Type_Request_ReferencesType
     */
    public function setPurchase_Item_Request_Type_Reference(array $purchase_Item_Request_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_Request_Type_ReferenceArrayErrorMessage = self::validatePurchase_Item_Request_Type_ReferenceForArrayConstraintsFromSetPurchase_Item_Request_Type_Reference($purchase_Item_Request_Type_Reference))) {
            throw new \InvalidArgumentException($purchase_Item_Request_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Request_Type_Reference = $purchase_Item_Request_Type_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Request_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_TypeObjectType $item
     * @return \StructType\Purchase_Item_Request_Type_Request_ReferencesType
     */
    public function addToPurchase_Item_Request_Type_Reference(\StructType\Purchase_Item_Request_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_Request_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Request_Type_Reference property can only contain items of type \StructType\Purchase_Item_Request_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Request_Type_Reference[] = $item;
        return $this;
    }
}
