<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_Type_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Purchase Item Request Type data
 * @subpackage Structs
 */
class Purchase_Item_Request_Type_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Request_Type_ID
     * Meta information extracted from the WSDL
     * - documentation: This is the Purchase Item Request Type ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Item_Request_Type_ID;
    /**
     * The Purchase_Item_Request_Name
     * Meta information extracted from the WSDL
     * - documentation: This is the Purchase Item Request Type name
     * - maxOccurs: 1
     * @var string
     */
    public $Purchase_Item_Request_Name;
    /**
     * The Request_New_Purchase_Items
     * Meta information extracted from the WSDL
     * - documentation: Controls whether this Purchase Item Request Type can be used for requesting new purchase items
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Request_New_Purchase_Items;
    /**
     * The Select_From_Existing_Purchase_Items
     * Meta information extracted from the WSDL
     * - documentation: Controls whether this Purchase Item Request Type can be used when modifying existing purchase items for Mass Maintenance
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Select_From_Existing_Purchase_Items;
    /**
     * The Generate_Empty_Workbook
     * Meta information extracted from the WSDL
     * - documentation: Controls whether this Purchase Item Request Type can be used with mass maintenance requests for new purchase items
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Generate_Empty_Workbook;
    /**
     * The Calculate_Recommended_Reorder_Point
     * Meta information extracted from the WSDL
     * - documentation: Controls whether this Purchase Item Request Type can be used for Calculating Recommended Reorder Point
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Calculate_Recommended_Reorder_Point;
    /**
     * The Search_External_Catalog
     * Meta information extracted from the WSDL
     * - documentation: Controls whether this Purchase Item Request Type can be used for Searching External Catalogs
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Search_External_Catalog;
    /**
     * The Questionnaire_Reference
     * Meta information extracted from the WSDL
     * - documentation: Questionnaire to be used for purchase item and mass maintenance purchase item requests
     * - minOccurs: 0
     * @var \StructType\QuestionnaireObjectType
     */
    public $Questionnaire_Reference;
    /**
     * The Primary_Workbook_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Primary Purchase Item Request Template
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_Request_TemplateObjectType
     */
    public $Primary_Workbook_Template_Reference;
    /**
     * The Enrichment_Workbook_Templates
     * Meta information extracted from the WSDL
     * - documentation: The element containing the Purchase Item Request Type enrichment templates data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType[]
     */
    public $Enrichment_Workbook_Templates;
    /**
     * The In_Use
     * Meta information extracted from the WSDL
     * - documentation: Denotes whether this Purchase item Request Type is currently in use by a Purchase Item Request or Mass Maintenance Purchase Item Request. This field is read-only and will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $In_Use;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Denotes whether this Purchase Item Request Type is currently active
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Purchase_Item_Request_Type_DataType
     * @uses Purchase_Item_Request_Type_DataType::setPurchase_Item_Request_Type_ID()
     * @uses Purchase_Item_Request_Type_DataType::setPurchase_Item_Request_Name()
     * @uses Purchase_Item_Request_Type_DataType::setRequest_New_Purchase_Items()
     * @uses Purchase_Item_Request_Type_DataType::setSelect_From_Existing_Purchase_Items()
     * @uses Purchase_Item_Request_Type_DataType::setGenerate_Empty_Workbook()
     * @uses Purchase_Item_Request_Type_DataType::setCalculate_Recommended_Reorder_Point()
     * @uses Purchase_Item_Request_Type_DataType::setSearch_External_Catalog()
     * @uses Purchase_Item_Request_Type_DataType::setQuestionnaire_Reference()
     * @uses Purchase_Item_Request_Type_DataType::setPrimary_Workbook_Template_Reference()
     * @uses Purchase_Item_Request_Type_DataType::setEnrichment_Workbook_Templates()
     * @uses Purchase_Item_Request_Type_DataType::setIn_Use()
     * @uses Purchase_Item_Request_Type_DataType::setInactive()
     * @param string $purchase_Item_Request_Type_ID
     * @param string $purchase_Item_Request_Name
     * @param bool $request_New_Purchase_Items
     * @param bool $select_From_Existing_Purchase_Items
     * @param bool $generate_Empty_Workbook
     * @param bool $calculate_Recommended_Reorder_Point
     * @param bool $search_External_Catalog
     * @param \StructType\QuestionnaireObjectType $questionnaire_Reference
     * @param \StructType\Purchase_Item_Request_TemplateObjectType $primary_Workbook_Template_Reference
     * @param \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType[] $enrichment_Workbook_Templates
     * @param bool $in_Use
     * @param bool $inactive
     */
    public function __construct($purchase_Item_Request_Type_ID = null, $purchase_Item_Request_Name = null, $request_New_Purchase_Items = null, $select_From_Existing_Purchase_Items = null, $generate_Empty_Workbook = null, $calculate_Recommended_Reorder_Point = null, $search_External_Catalog = null, \StructType\QuestionnaireObjectType $questionnaire_Reference = null, \StructType\Purchase_Item_Request_TemplateObjectType $primary_Workbook_Template_Reference = null, array $enrichment_Workbook_Templates = array(), $in_Use = null, $inactive = null)
    {
        $this
            ->setPurchase_Item_Request_Type_ID($purchase_Item_Request_Type_ID)
            ->setPurchase_Item_Request_Name($purchase_Item_Request_Name)
            ->setRequest_New_Purchase_Items($request_New_Purchase_Items)
            ->setSelect_From_Existing_Purchase_Items($select_From_Existing_Purchase_Items)
            ->setGenerate_Empty_Workbook($generate_Empty_Workbook)
            ->setCalculate_Recommended_Reorder_Point($calculate_Recommended_Reorder_Point)
            ->setSearch_External_Catalog($search_External_Catalog)
            ->setQuestionnaire_Reference($questionnaire_Reference)
            ->setPrimary_Workbook_Template_Reference($primary_Workbook_Template_Reference)
            ->setEnrichment_Workbook_Templates($enrichment_Workbook_Templates)
            ->setIn_Use($in_Use)
            ->setInactive($inactive);
    }
    /**
     * Get Purchase_Item_Request_Type_ID value
     * @return string|null
     */
    public function getPurchase_Item_Request_Type_ID()
    {
        return $this->Purchase_Item_Request_Type_ID;
    }
    /**
     * Set Purchase_Item_Request_Type_ID value
     * @param string $purchase_Item_Request_Type_ID
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setPurchase_Item_Request_Type_ID($purchase_Item_Request_Type_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Item_Request_Type_ID) && !is_string($purchase_Item_Request_Type_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Item_Request_Type_ID, true), gettype($purchase_Item_Request_Type_ID)), __LINE__);
        }
        $this->Purchase_Item_Request_Type_ID = $purchase_Item_Request_Type_ID;
        return $this;
    }
    /**
     * Get Purchase_Item_Request_Name value
     * @return string|null
     */
    public function getPurchase_Item_Request_Name()
    {
        return $this->Purchase_Item_Request_Name;
    }
    /**
     * Set Purchase_Item_Request_Name value
     * @param string $purchase_Item_Request_Name
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setPurchase_Item_Request_Name($purchase_Item_Request_Name = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Item_Request_Name) && !is_string($purchase_Item_Request_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Item_Request_Name, true), gettype($purchase_Item_Request_Name)), __LINE__);
        }
        $this->Purchase_Item_Request_Name = $purchase_Item_Request_Name;
        return $this;
    }
    /**
     * Get Request_New_Purchase_Items value
     * @return bool|null
     */
    public function getRequest_New_Purchase_Items()
    {
        return $this->Request_New_Purchase_Items;
    }
    /**
     * Set Request_New_Purchase_Items value
     * @param bool $request_New_Purchase_Items
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setRequest_New_Purchase_Items($request_New_Purchase_Items = null)
    {
        // validation for constraint: boolean
        if (!is_null($request_New_Purchase_Items) && !is_bool($request_New_Purchase_Items)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($request_New_Purchase_Items, true), gettype($request_New_Purchase_Items)), __LINE__);
        }
        $this->Request_New_Purchase_Items = $request_New_Purchase_Items;
        return $this;
    }
    /**
     * Get Select_From_Existing_Purchase_Items value
     * @return bool|null
     */
    public function getSelect_From_Existing_Purchase_Items()
    {
        return $this->Select_From_Existing_Purchase_Items;
    }
    /**
     * Set Select_From_Existing_Purchase_Items value
     * @param bool $select_From_Existing_Purchase_Items
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setSelect_From_Existing_Purchase_Items($select_From_Existing_Purchase_Items = null)
    {
        // validation for constraint: boolean
        if (!is_null($select_From_Existing_Purchase_Items) && !is_bool($select_From_Existing_Purchase_Items)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($select_From_Existing_Purchase_Items, true), gettype($select_From_Existing_Purchase_Items)), __LINE__);
        }
        $this->Select_From_Existing_Purchase_Items = $select_From_Existing_Purchase_Items;
        return $this;
    }
    /**
     * Get Generate_Empty_Workbook value
     * @return bool|null
     */
    public function getGenerate_Empty_Workbook()
    {
        return $this->Generate_Empty_Workbook;
    }
    /**
     * Set Generate_Empty_Workbook value
     * @param bool $generate_Empty_Workbook
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setGenerate_Empty_Workbook($generate_Empty_Workbook = null)
    {
        // validation for constraint: boolean
        if (!is_null($generate_Empty_Workbook) && !is_bool($generate_Empty_Workbook)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generate_Empty_Workbook, true), gettype($generate_Empty_Workbook)), __LINE__);
        }
        $this->Generate_Empty_Workbook = $generate_Empty_Workbook;
        return $this;
    }
    /**
     * Get Calculate_Recommended_Reorder_Point value
     * @return bool|null
     */
    public function getCalculate_Recommended_Reorder_Point()
    {
        return $this->Calculate_Recommended_Reorder_Point;
    }
    /**
     * Set Calculate_Recommended_Reorder_Point value
     * @param bool $calculate_Recommended_Reorder_Point
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setCalculate_Recommended_Reorder_Point($calculate_Recommended_Reorder_Point = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculate_Recommended_Reorder_Point) && !is_bool($calculate_Recommended_Reorder_Point)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculate_Recommended_Reorder_Point, true), gettype($calculate_Recommended_Reorder_Point)), __LINE__);
        }
        $this->Calculate_Recommended_Reorder_Point = $calculate_Recommended_Reorder_Point;
        return $this;
    }
    /**
     * Get Search_External_Catalog value
     * @return bool|null
     */
    public function getSearch_External_Catalog()
    {
        return $this->Search_External_Catalog;
    }
    /**
     * Set Search_External_Catalog value
     * @param bool $search_External_Catalog
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setSearch_External_Catalog($search_External_Catalog = null)
    {
        // validation for constraint: boolean
        if (!is_null($search_External_Catalog) && !is_bool($search_External_Catalog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($search_External_Catalog, true), gettype($search_External_Catalog)), __LINE__);
        }
        $this->Search_External_Catalog = $search_External_Catalog;
        return $this;
    }
    /**
     * Get Questionnaire_Reference value
     * @return \StructType\QuestionnaireObjectType|null
     */
    public function getQuestionnaire_Reference()
    {
        return $this->Questionnaire_Reference;
    }
    /**
     * Set Questionnaire_Reference value
     * @param \StructType\QuestionnaireObjectType $questionnaire_Reference
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setQuestionnaire_Reference(\StructType\QuestionnaireObjectType $questionnaire_Reference = null)
    {
        $this->Questionnaire_Reference = $questionnaire_Reference;
        return $this;
    }
    /**
     * Get Primary_Workbook_Template_Reference value
     * @return \StructType\Purchase_Item_Request_TemplateObjectType|null
     */
    public function getPrimary_Workbook_Template_Reference()
    {
        return $this->Primary_Workbook_Template_Reference;
    }
    /**
     * Set Primary_Workbook_Template_Reference value
     * @param \StructType\Purchase_Item_Request_TemplateObjectType $primary_Workbook_Template_Reference
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setPrimary_Workbook_Template_Reference(\StructType\Purchase_Item_Request_TemplateObjectType $primary_Workbook_Template_Reference = null)
    {
        $this->Primary_Workbook_Template_Reference = $primary_Workbook_Template_Reference;
        return $this;
    }
    /**
     * Get Enrichment_Workbook_Templates value
     * @return \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType[]|null
     */
    public function getEnrichment_Workbook_Templates()
    {
        return $this->Enrichment_Workbook_Templates;
    }
    /**
     * This method is responsible for validating the values passed to the setEnrichment_Workbook_Templates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnrichment_Workbook_Templates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEnrichment_Workbook_TemplatesForArrayConstraintsFromSetEnrichment_Workbook_Templates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_Type_DataTypeEnrichment_Workbook_TemplatesItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_Type_DataTypeEnrichment_Workbook_TemplatesItem instanceof \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType) {
                $invalidValues[] = is_object($purchase_Item_Request_Type_DataTypeEnrichment_Workbook_TemplatesItem) ? get_class($purchase_Item_Request_Type_DataTypeEnrichment_Workbook_TemplatesItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_Type_DataTypeEnrichment_Workbook_TemplatesItem), var_export($purchase_Item_Request_Type_DataTypeEnrichment_Workbook_TemplatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Enrichment_Workbook_Templates property can only contain items of type \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Enrichment_Workbook_Templates value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType[] $enrichment_Workbook_Templates
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setEnrichment_Workbook_Templates(array $enrichment_Workbook_Templates = array())
    {
        // validation for constraint: array
        if ('' !== ($enrichment_Workbook_TemplatesArrayErrorMessage = self::validateEnrichment_Workbook_TemplatesForArrayConstraintsFromSetEnrichment_Workbook_Templates($enrichment_Workbook_Templates))) {
            throw new \InvalidArgumentException($enrichment_Workbook_TemplatesArrayErrorMessage, __LINE__);
        }
        $this->Enrichment_Workbook_Templates = $enrichment_Workbook_Templates;
        return $this;
    }
    /**
     * Add item to Enrichment_Workbook_Templates value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType $item
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function addToEnrichment_Workbook_Templates(\StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType) {
            throw new \InvalidArgumentException(sprintf('The Enrichment_Workbook_Templates property can only contain items of type \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Enrichment_Workbook_Templates[] = $item;
        return $this;
    }
    /**
     * Get In_Use value
     * @return bool|null
     */
    public function getIn_Use()
    {
        return $this->In_Use;
    }
    /**
     * Set In_Use value
     * @param bool $in_Use
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setIn_Use($in_Use = null)
    {
        // validation for constraint: boolean
        if (!is_null($in_Use) && !is_bool($in_Use)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($in_Use, true), gettype($in_Use)), __LINE__);
        }
        $this->In_Use = $in_Use;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Purchase_Item_Request_Type_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
