<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Group_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Purchase Item Group data
 * @subpackage Structs
 */
class Purchase_Item_Group_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Group_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Group ID. This is the Purchase Item Group unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Item_Group_ID;
    /**
     * The Purchase_Item_Group_Name
     * Meta information extracted from the WSDL
     * - documentation: The Item Group Name is already in use. | Free form text field for a meaningful Purchase Item Group Name
     * - maxOccurs: 1
     * @var string
     */
    public $Purchase_Item_Group_Name;
    /**
     * Constructor method for Purchase_Item_Group_DataType
     * @uses Purchase_Item_Group_DataType::setPurchase_Item_Group_ID()
     * @uses Purchase_Item_Group_DataType::setPurchase_Item_Group_Name()
     * @param string $purchase_Item_Group_ID
     * @param string $purchase_Item_Group_Name
     */
    public function __construct($purchase_Item_Group_ID = null, $purchase_Item_Group_Name = null)
    {
        $this
            ->setPurchase_Item_Group_ID($purchase_Item_Group_ID)
            ->setPurchase_Item_Group_Name($purchase_Item_Group_Name);
    }
    /**
     * Get Purchase_Item_Group_ID value
     * @return string|null
     */
    public function getPurchase_Item_Group_ID()
    {
        return $this->Purchase_Item_Group_ID;
    }
    /**
     * Set Purchase_Item_Group_ID value
     * @param string $purchase_Item_Group_ID
     * @return \StructType\Purchase_Item_Group_DataType
     */
    public function setPurchase_Item_Group_ID($purchase_Item_Group_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Item_Group_ID) && !is_string($purchase_Item_Group_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Item_Group_ID, true), gettype($purchase_Item_Group_ID)), __LINE__);
        }
        $this->Purchase_Item_Group_ID = $purchase_Item_Group_ID;
        return $this;
    }
    /**
     * Get Purchase_Item_Group_Name value
     * @return string|null
     */
    public function getPurchase_Item_Group_Name()
    {
        return $this->Purchase_Item_Group_Name;
    }
    /**
     * Set Purchase_Item_Group_Name value
     * @param string $purchase_Item_Group_Name
     * @return \StructType\Purchase_Item_Group_DataType
     */
    public function setPurchase_Item_Group_Name($purchase_Item_Group_Name = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Item_Group_Name) && !is_string($purchase_Item_Group_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Item_Group_Name, true), gettype($purchase_Item_Group_Name)), __LINE__);
        }
        $this->Purchase_Item_Group_Name = $purchase_Item_Group_Name;
        return $this;
    }
}
