<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_ItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Purchase Item Instance, Data and Patient Charge Information Data.
 * @subpackage Structs
 */
class Purchase_ItemType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Item
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Purchase_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Data
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_DataType
     */
    public $Purchase_Item_Data;
    /**
     * The Patient_Charge_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Patient Charge Information Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Patient_Charge_Information_DataType[]
     */
    public $Patient_Charge_Information_Data;
    /**
     * Constructor method for Purchase_ItemType
     * @uses Purchase_ItemType::setPurchase_Item_Reference()
     * @uses Purchase_ItemType::setPurchase_Item_Data()
     * @uses Purchase_ItemType::setPatient_Charge_Information_Data()
     * @param \StructType\Procurement_ItemObjectType $purchase_Item_Reference
     * @param \StructType\Purchase_Item_DataType $purchase_Item_Data
     * @param \StructType\Patient_Charge_Information_DataType[] $patient_Charge_Information_Data
     */
    public function __construct(\StructType\Procurement_ItemObjectType $purchase_Item_Reference = null, \StructType\Purchase_Item_DataType $purchase_Item_Data = null, array $patient_Charge_Information_Data = array())
    {
        $this
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setPurchase_Item_Data($purchase_Item_Data)
            ->setPatient_Charge_Information_Data($patient_Charge_Information_Data);
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Purchase_ItemType
     */
    public function setPurchase_Item_Reference(\StructType\Procurement_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Purchase_Item_Data value
     * @return \StructType\Purchase_Item_DataType|null
     */
    public function getPurchase_Item_Data()
    {
        return $this->Purchase_Item_Data;
    }
    /**
     * Set Purchase_Item_Data value
     * @param \StructType\Purchase_Item_DataType $purchase_Item_Data
     * @return \StructType\Purchase_ItemType
     */
    public function setPurchase_Item_Data(\StructType\Purchase_Item_DataType $purchase_Item_Data = null)
    {
        $this->Purchase_Item_Data = $purchase_Item_Data;
        return $this;
    }
    /**
     * Get Patient_Charge_Information_Data value
     * @return \StructType\Patient_Charge_Information_DataType[]|null
     */
    public function getPatient_Charge_Information_Data()
    {
        return $this->Patient_Charge_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPatient_Charge_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPatient_Charge_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePatient_Charge_Information_DataForArrayConstraintsFromSetPatient_Charge_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_ItemTypePatient_Charge_Information_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_ItemTypePatient_Charge_Information_DataItem instanceof \StructType\Patient_Charge_Information_DataType) {
                $invalidValues[] = is_object($purchase_ItemTypePatient_Charge_Information_DataItem) ? get_class($purchase_ItemTypePatient_Charge_Information_DataItem) : sprintf('%s(%s)', gettype($purchase_ItemTypePatient_Charge_Information_DataItem), var_export($purchase_ItemTypePatient_Charge_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Patient_Charge_Information_Data property can only contain items of type \StructType\Patient_Charge_Information_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Patient_Charge_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Patient_Charge_Information_DataType[] $patient_Charge_Information_Data
     * @return \StructType\Purchase_ItemType
     */
    public function setPatient_Charge_Information_Data(array $patient_Charge_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($patient_Charge_Information_DataArrayErrorMessage = self::validatePatient_Charge_Information_DataForArrayConstraintsFromSetPatient_Charge_Information_Data($patient_Charge_Information_Data))) {
            throw new \InvalidArgumentException($patient_Charge_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Patient_Charge_Information_Data = $patient_Charge_Information_Data;
        return $this;
    }
    /**
     * Add item to Patient_Charge_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Patient_Charge_Information_DataType $item
     * @return \StructType\Purchase_ItemType
     */
    public function addToPatient_Charge_Information_Data(\StructType\Patient_Charge_Information_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Patient_Charge_Information_DataType) {
            throw new \InvalidArgumentException(sprintf('The Patient_Charge_Information_Data property can only contain items of type \StructType\Patient_Charge_Information_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Patient_Charge_Information_Data[] = $item;
        return $this;
    }
}
