<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Task_Resources_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Request References element contains the specific instance set that should be returned in the Get operation. Either a Reference ID or the Workday ID (GUID) should be specified for each instance to be returned.
 * @subpackage Structs
 */
class Project_Task_Resources_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: .
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType[]
     */
    public $Project_Reference;
    /**
     * Constructor method for Project_Task_Resources_Request_ReferencesType
     * @uses Project_Task_Resources_Request_ReferencesType::setProject_Reference()
     * @param \StructType\ProjectObjectType[] $project_Reference
     */
    public function __construct(array $project_Reference = array())
    {
        $this
            ->setProject_Reference($project_Reference);
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType[]|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_ReferenceForArrayConstraintsFromSetProject_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Task_Resources_Request_ReferencesTypeProject_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Task_Resources_Request_ReferencesTypeProject_ReferenceItem instanceof \StructType\ProjectObjectType) {
                $invalidValues[] = is_object($project_Task_Resources_Request_ReferencesTypeProject_ReferenceItem) ? get_class($project_Task_Resources_Request_ReferencesTypeProject_ReferenceItem) : sprintf('%s(%s)', gettype($project_Task_Resources_Request_ReferencesTypeProject_ReferenceItem), var_export($project_Task_Resources_Request_ReferencesTypeProject_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Reference property can only contain items of type \StructType\ProjectObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectObjectType[] $project_Reference
     * @return \StructType\Project_Task_Resources_Request_ReferencesType
     */
    public function setProject_Reference(array $project_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_ReferenceArrayErrorMessage = self::validateProject_ReferenceForArrayConstraintsFromSetProject_Reference($project_Reference))) {
            throw new \InvalidArgumentException($project_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Add item to Project_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectObjectType $item
     * @return \StructType\Project_Task_Resources_Request_ReferencesType
     */
    public function addToProject_Reference(\StructType\ProjectObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProjectObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Reference property can only contain items of type \StructType\ProjectObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Reference[] = $item;
        return $this;
    }
}
