<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Task_Resource_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource End Date cannot be before the Resource Start Date. | Element containing Project Task Resources related data to be processed by the wws
 * @subpackage Structs
 */
class Project_Task_Resource_Line_DataType extends AbstractStructBase
{
    /**
     * The Project_Task_Resource_ID
     * Meta information extracted from the WSDL
     * - documentation: Project Task Resource Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Task_Resource_ID;
    /**
     * The Project_Plan_Task_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Plan Task Reference
     * @var \StructType\Project_Plan_TaskObjectType
     */
    public $Project_Plan_Task_Reference;
    /**
     * The Project_Resource_Plan_Detail_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Resource Plan Detail Reference
     * @var \StructType\Project_Resource_Plan_DetailObjectType
     */
    public $Project_Resource_Plan_Detail_Reference;
    /**
     * The Project_Resource_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worker and Unnamed Resource reference for the Project Task Resource
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_ResourceObjectType[]
     */
    public $Project_Resource_Reference;
    /**
     * The Resource_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Resource Start Date for the Project Task Resource
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Start_Date;
    /**
     * The Resource_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Resource End Date for the Project Task Resource
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_End_Date;
    /**
     * The Percent_Allocation
     * Meta information extracted from the WSDL
     * - documentation: % Allocation for the Project Task Resource | Percent Allocation | Percent in decimal format, ex: enter 1 for 100%, .5 for 50%, etc
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Percent_Allocation;
    /**
     * The Estimated_Hours
     * Meta information extracted from the WSDL
     * - documentation: Estimated Hours for the Project Task Resource | Estimated Hours | The estimated hours associated to the resource plan line in the resource plan template.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Estimated_Hours;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Project Task Resource
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: This flag controls whether specified Project Task Resource should be deleted (When Replace All Flag is true,then value of delete flag is ignored)
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Project_Task_Resource_Line_DataType
     * @uses Project_Task_Resource_Line_DataType::setProject_Task_Resource_ID()
     * @uses Project_Task_Resource_Line_DataType::setProject_Plan_Task_Reference()
     * @uses Project_Task_Resource_Line_DataType::setProject_Resource_Plan_Detail_Reference()
     * @uses Project_Task_Resource_Line_DataType::setProject_Resource_Reference()
     * @uses Project_Task_Resource_Line_DataType::setResource_Start_Date()
     * @uses Project_Task_Resource_Line_DataType::setResource_End_Date()
     * @uses Project_Task_Resource_Line_DataType::setPercent_Allocation()
     * @uses Project_Task_Resource_Line_DataType::setEstimated_Hours()
     * @uses Project_Task_Resource_Line_DataType::setMemo()
     * @uses Project_Task_Resource_Line_DataType::setDelete()
     * @param string $project_Task_Resource_ID
     * @param \StructType\Project_Plan_TaskObjectType $project_Plan_Task_Reference
     * @param \StructType\Project_Resource_Plan_DetailObjectType $project_Resource_Plan_Detail_Reference
     * @param \StructType\Project_ResourceObjectType[] $project_Resource_Reference
     * @param string $resource_Start_Date
     * @param string $resource_End_Date
     * @param float $percent_Allocation
     * @param float $estimated_Hours
     * @param string $memo
     * @param bool $delete
     */
    public function __construct($project_Task_Resource_ID = null, \StructType\Project_Plan_TaskObjectType $project_Plan_Task_Reference = null, \StructType\Project_Resource_Plan_DetailObjectType $project_Resource_Plan_Detail_Reference = null, array $project_Resource_Reference = array(), $resource_Start_Date = null, $resource_End_Date = null, $percent_Allocation = null, $estimated_Hours = null, $memo = null, $delete = null)
    {
        $this
            ->setProject_Task_Resource_ID($project_Task_Resource_ID)
            ->setProject_Plan_Task_Reference($project_Plan_Task_Reference)
            ->setProject_Resource_Plan_Detail_Reference($project_Resource_Plan_Detail_Reference)
            ->setProject_Resource_Reference($project_Resource_Reference)
            ->setResource_Start_Date($resource_Start_Date)
            ->setResource_End_Date($resource_End_Date)
            ->setPercent_Allocation($percent_Allocation)
            ->setEstimated_Hours($estimated_Hours)
            ->setMemo($memo)
            ->setDelete($delete);
    }
    /**
     * Get Project_Task_Resource_ID value
     * @return string|null
     */
    public function getProject_Task_Resource_ID()
    {
        return $this->Project_Task_Resource_ID;
    }
    /**
     * Set Project_Task_Resource_ID value
     * @param string $project_Task_Resource_ID
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function setProject_Task_Resource_ID($project_Task_Resource_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Task_Resource_ID) && !is_string($project_Task_Resource_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Task_Resource_ID, true), gettype($project_Task_Resource_ID)), __LINE__);
        }
        $this->Project_Task_Resource_ID = $project_Task_Resource_ID;
        return $this;
    }
    /**
     * Get Project_Plan_Task_Reference value
     * @return \StructType\Project_Plan_TaskObjectType|null
     */
    public function getProject_Plan_Task_Reference()
    {
        return $this->Project_Plan_Task_Reference;
    }
    /**
     * Set Project_Plan_Task_Reference value
     * @param \StructType\Project_Plan_TaskObjectType $project_Plan_Task_Reference
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function setProject_Plan_Task_Reference(\StructType\Project_Plan_TaskObjectType $project_Plan_Task_Reference = null)
    {
        $this->Project_Plan_Task_Reference = $project_Plan_Task_Reference;
        return $this;
    }
    /**
     * Get Project_Resource_Plan_Detail_Reference value
     * @return \StructType\Project_Resource_Plan_DetailObjectType|null
     */
    public function getProject_Resource_Plan_Detail_Reference()
    {
        return $this->Project_Resource_Plan_Detail_Reference;
    }
    /**
     * Set Project_Resource_Plan_Detail_Reference value
     * @param \StructType\Project_Resource_Plan_DetailObjectType $project_Resource_Plan_Detail_Reference
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function setProject_Resource_Plan_Detail_Reference(\StructType\Project_Resource_Plan_DetailObjectType $project_Resource_Plan_Detail_Reference = null)
    {
        $this->Project_Resource_Plan_Detail_Reference = $project_Resource_Plan_Detail_Reference;
        return $this;
    }
    /**
     * Get Project_Resource_Reference value
     * @return \StructType\Project_ResourceObjectType[]|null
     */
    public function getProject_Resource_Reference()
    {
        return $this->Project_Resource_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Resource_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Resource_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Resource_ReferenceForArrayConstraintsFromSetProject_Resource_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Task_Resource_Line_DataTypeProject_Resource_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Task_Resource_Line_DataTypeProject_Resource_ReferenceItem instanceof \StructType\Project_ResourceObjectType) {
                $invalidValues[] = is_object($project_Task_Resource_Line_DataTypeProject_Resource_ReferenceItem) ? get_class($project_Task_Resource_Line_DataTypeProject_Resource_ReferenceItem) : sprintf('%s(%s)', gettype($project_Task_Resource_Line_DataTypeProject_Resource_ReferenceItem), var_export($project_Task_Resource_Line_DataTypeProject_Resource_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Resource_Reference property can only contain items of type \StructType\Project_ResourceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Resource_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_ResourceObjectType[] $project_Resource_Reference
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function setProject_Resource_Reference(array $project_Resource_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Resource_ReferenceArrayErrorMessage = self::validateProject_Resource_ReferenceForArrayConstraintsFromSetProject_Resource_Reference($project_Resource_Reference))) {
            throw new \InvalidArgumentException($project_Resource_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Resource_Reference = $project_Resource_Reference;
        return $this;
    }
    /**
     * Add item to Project_Resource_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_ResourceObjectType $item
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function addToProject_Resource_Reference(\StructType\Project_ResourceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_ResourceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Resource_Reference property can only contain items of type \StructType\Project_ResourceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Resource_Reference[] = $item;
        return $this;
    }
    /**
     * Get Resource_Start_Date value
     * @return string|null
     */
    public function getResource_Start_Date()
    {
        return $this->Resource_Start_Date;
    }
    /**
     * Set Resource_Start_Date value
     * @param string $resource_Start_Date
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function setResource_Start_Date($resource_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Start_Date) && !is_string($resource_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Start_Date, true), gettype($resource_Start_Date)), __LINE__);
        }
        $this->Resource_Start_Date = $resource_Start_Date;
        return $this;
    }
    /**
     * Get Resource_End_Date value
     * @return string|null
     */
    public function getResource_End_Date()
    {
        return $this->Resource_End_Date;
    }
    /**
     * Set Resource_End_Date value
     * @param string $resource_End_Date
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function setResource_End_Date($resource_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($resource_End_Date) && !is_string($resource_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_End_Date, true), gettype($resource_End_Date)), __LINE__);
        }
        $this->Resource_End_Date = $resource_End_Date;
        return $this;
    }
    /**
     * Get Percent_Allocation value
     * @return float|null
     */
    public function getPercent_Allocation()
    {
        return $this->Percent_Allocation;
    }
    /**
     * Set Percent_Allocation value
     * @param float $percent_Allocation
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function setPercent_Allocation($percent_Allocation = null)
    {
        // validation for constraint: float
        if (!is_null($percent_Allocation) && !(is_float($percent_Allocation) || is_numeric($percent_Allocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_Allocation, true), gettype($percent_Allocation)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($percent_Allocation) && mb_strlen(mb_substr($percent_Allocation, false !== mb_strpos($percent_Allocation, '.') ? mb_strpos($percent_Allocation, '.') + 1 : mb_strlen($percent_Allocation))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($percent_Allocation, true), mb_strlen(mb_substr($percent_Allocation, mb_strpos($percent_Allocation, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_Allocation) && $percent_Allocation < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_Allocation, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($percent_Allocation) && mb_strlen(preg_replace('/(\D)/', '', $percent_Allocation)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($percent_Allocation, true), mb_strlen(preg_replace('/(\D)/', '', $percent_Allocation))), __LINE__);
        }
        $this->Percent_Allocation = $percent_Allocation;
        return $this;
    }
    /**
     * Get Estimated_Hours value
     * @return float|null
     */
    public function getEstimated_Hours()
    {
        return $this->Estimated_Hours;
    }
    /**
     * Set Estimated_Hours value
     * @param float $estimated_Hours
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function setEstimated_Hours($estimated_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($estimated_Hours) && !(is_float($estimated_Hours) || is_numeric($estimated_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimated_Hours, true), gettype($estimated_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($estimated_Hours) && mb_strlen(mb_substr($estimated_Hours, false !== mb_strpos($estimated_Hours, '.') ? mb_strpos($estimated_Hours, '.') + 1 : mb_strlen($estimated_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($estimated_Hours, true), mb_strlen(mb_substr($estimated_Hours, mb_strpos($estimated_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($estimated_Hours) && $estimated_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($estimated_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($estimated_Hours) && mb_strlen(preg_replace('/(\D)/', '', $estimated_Hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($estimated_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $estimated_Hours))), __LINE__);
        }
        $this->Estimated_Hours = $estimated_Hours;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Project_Task_Resource_Line_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
