<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Task_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Project Task data to be retrieved or input via web service
 * @subpackage Structs
 */
class Project_Task_DataType extends AbstractStructBase
{
    /**
     * The Task_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the Project Task
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Task_ID;
    /**
     * The Task_Name
     * Meta information extracted from the WSDL
     * - documentation: Project Task Name
     * - maxOccurs: 1
     * @var string
     */
    public $Task_Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Project Task Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Restricted_to_Project_Hierarchies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Restricted to Project Hierarchies
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_HierarchyObjectType[]
     */
    public $Restricted_to_Project_Hierarchies_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag to set the Project Task to Inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Project_Task_DataType
     * @uses Project_Task_DataType::setTask_ID()
     * @uses Project_Task_DataType::setTask_Name()
     * @uses Project_Task_DataType::setDescription()
     * @uses Project_Task_DataType::setRestricted_to_Project_Hierarchies_Reference()
     * @uses Project_Task_DataType::setInactive()
     * @param string $task_ID
     * @param string $task_Name
     * @param string $description
     * @param \StructType\Project_HierarchyObjectType[] $restricted_to_Project_Hierarchies_Reference
     * @param bool $inactive
     */
    public function __construct($task_ID = null, $task_Name = null, $description = null, array $restricted_to_Project_Hierarchies_Reference = array(), $inactive = null)
    {
        $this
            ->setTask_ID($task_ID)
            ->setTask_Name($task_Name)
            ->setDescription($description)
            ->setRestricted_to_Project_Hierarchies_Reference($restricted_to_Project_Hierarchies_Reference)
            ->setInactive($inactive);
    }
    /**
     * Get Task_ID value
     * @return string|null
     */
    public function getTask_ID()
    {
        return $this->Task_ID;
    }
    /**
     * Set Task_ID value
     * @param string $task_ID
     * @return \StructType\Project_Task_DataType
     */
    public function setTask_ID($task_ID = null)
    {
        // validation for constraint: string
        if (!is_null($task_ID) && !is_string($task_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($task_ID, true), gettype($task_ID)), __LINE__);
        }
        $this->Task_ID = $task_ID;
        return $this;
    }
    /**
     * Get Task_Name value
     * @return string|null
     */
    public function getTask_Name()
    {
        return $this->Task_Name;
    }
    /**
     * Set Task_Name value
     * @param string $task_Name
     * @return \StructType\Project_Task_DataType
     */
    public function setTask_Name($task_Name = null)
    {
        // validation for constraint: string
        if (!is_null($task_Name) && !is_string($task_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($task_Name, true), gettype($task_Name)), __LINE__);
        }
        $this->Task_Name = $task_Name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Project_Task_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Restricted_to_Project_Hierarchies_Reference value
     * @return \StructType\Project_HierarchyObjectType[]|null
     */
    public function getRestricted_to_Project_Hierarchies_Reference()
    {
        return $this->Restricted_to_Project_Hierarchies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_to_Project_Hierarchies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_to_Project_Hierarchies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_to_Project_Hierarchies_ReferenceForArrayConstraintsFromSetRestricted_to_Project_Hierarchies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Task_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Task_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem instanceof \StructType\Project_HierarchyObjectType) {
                $invalidValues[] = is_object($project_Task_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem) ? get_class($project_Task_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem) : sprintf('%s(%s)', gettype($project_Task_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem), var_export($project_Task_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_to_Project_Hierarchies_Reference property can only contain items of type \StructType\Project_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_to_Project_Hierarchies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_HierarchyObjectType[] $restricted_to_Project_Hierarchies_Reference
     * @return \StructType\Project_Task_DataType
     */
    public function setRestricted_to_Project_Hierarchies_Reference(array $restricted_to_Project_Hierarchies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_to_Project_Hierarchies_ReferenceArrayErrorMessage = self::validateRestricted_to_Project_Hierarchies_ReferenceForArrayConstraintsFromSetRestricted_to_Project_Hierarchies_Reference($restricted_to_Project_Hierarchies_Reference))) {
            throw new \InvalidArgumentException($restricted_to_Project_Hierarchies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_to_Project_Hierarchies_Reference = $restricted_to_Project_Hierarchies_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_to_Project_Hierarchies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_HierarchyObjectType $item
     * @return \StructType\Project_Task_DataType
     */
    public function addToRestricted_to_Project_Hierarchies_Reference(\StructType\Project_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_to_Project_Hierarchies_Reference property can only contain items of type \StructType\Project_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_to_Project_Hierarchies_Reference[] = $item;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Project_Task_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
