<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Standard_Cost_Rate_Sheet_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Project Role Standard Cost Rate Sheet Instance and Data
 * @subpackage Structs
 */
class Project_Standard_Cost_Rate_Sheet_Response_DataType extends AbstractStructBase
{
    /**
     * The Project_Standard_Cost_Rate_Sheet
     * Meta information extracted from the WSDL
     * - documentation: Project Role Standard Cost Rate Sheet
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Standard_Cost_Rate_SheetType[]
     */
    public $Project_Standard_Cost_Rate_Sheet;
    /**
     * Constructor method for Project_Standard_Cost_Rate_Sheet_Response_DataType
     * @uses Project_Standard_Cost_Rate_Sheet_Response_DataType::setProject_Standard_Cost_Rate_Sheet()
     * @param \StructType\Project_Standard_Cost_Rate_SheetType[] $project_Standard_Cost_Rate_Sheet
     */
    public function __construct(array $project_Standard_Cost_Rate_Sheet = array())
    {
        $this
            ->setProject_Standard_Cost_Rate_Sheet($project_Standard_Cost_Rate_Sheet);
    }
    /**
     * Get Project_Standard_Cost_Rate_Sheet value
     * @return \StructType\Project_Standard_Cost_Rate_SheetType[]|null
     */
    public function getProject_Standard_Cost_Rate_Sheet()
    {
        return $this->Project_Standard_Cost_Rate_Sheet;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Standard_Cost_Rate_Sheet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Standard_Cost_Rate_Sheet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Standard_Cost_Rate_SheetForArrayConstraintsFromSetProject_Standard_Cost_Rate_Sheet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Standard_Cost_Rate_Sheet_Response_DataTypeProject_Standard_Cost_Rate_SheetItem) {
            // validation for constraint: itemType
            if (!$project_Standard_Cost_Rate_Sheet_Response_DataTypeProject_Standard_Cost_Rate_SheetItem instanceof \StructType\Project_Standard_Cost_Rate_SheetType) {
                $invalidValues[] = is_object($project_Standard_Cost_Rate_Sheet_Response_DataTypeProject_Standard_Cost_Rate_SheetItem) ? get_class($project_Standard_Cost_Rate_Sheet_Response_DataTypeProject_Standard_Cost_Rate_SheetItem) : sprintf('%s(%s)', gettype($project_Standard_Cost_Rate_Sheet_Response_DataTypeProject_Standard_Cost_Rate_SheetItem), var_export($project_Standard_Cost_Rate_Sheet_Response_DataTypeProject_Standard_Cost_Rate_SheetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Standard_Cost_Rate_Sheet property can only contain items of type \StructType\Project_Standard_Cost_Rate_SheetType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Standard_Cost_Rate_Sheet value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Standard_Cost_Rate_SheetType[] $project_Standard_Cost_Rate_Sheet
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_Response_DataType
     */
    public function setProject_Standard_Cost_Rate_Sheet(array $project_Standard_Cost_Rate_Sheet = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Standard_Cost_Rate_SheetArrayErrorMessage = self::validateProject_Standard_Cost_Rate_SheetForArrayConstraintsFromSetProject_Standard_Cost_Rate_Sheet($project_Standard_Cost_Rate_Sheet))) {
            throw new \InvalidArgumentException($project_Standard_Cost_Rate_SheetArrayErrorMessage, __LINE__);
        }
        $this->Project_Standard_Cost_Rate_Sheet = $project_Standard_Cost_Rate_Sheet;
        return $this;
    }
    /**
     * Add item to Project_Standard_Cost_Rate_Sheet value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Standard_Cost_Rate_SheetType $item
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_Response_DataType
     */
    public function addToProject_Standard_Cost_Rate_Sheet(\StructType\Project_Standard_Cost_Rate_SheetType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Standard_Cost_Rate_SheetType) {
            throw new \InvalidArgumentException(sprintf('The Project_Standard_Cost_Rate_Sheet property can only contain items of type \StructType\Project_Standard_Cost_Rate_SheetType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Standard_Cost_Rate_Sheet[] = $item;
        return $this;
    }
}
