<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Role_Category_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Request References element contains the specific instance set that should be returned in the Get operation. Either a Reference ID or the Workday ID (GUID) should be specified for each instance to be returned.
 * @subpackage Structs
 */
class Project_Role_Category_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Project_Role_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Request References for Project Role Category
     * - maxOccurs: unbounded
     * @var \StructType\Project_Role_CategoryObjectType[]
     */
    public $Project_Role_Category_Reference;
    /**
     * Constructor method for Project_Role_Category_Request_ReferencesType
     * @uses Project_Role_Category_Request_ReferencesType::setProject_Role_Category_Reference()
     * @param \StructType\Project_Role_CategoryObjectType[] $project_Role_Category_Reference
     */
    public function __construct(array $project_Role_Category_Reference = array())
    {
        $this
            ->setProject_Role_Category_Reference($project_Role_Category_Reference);
    }
    /**
     * Get Project_Role_Category_Reference value
     * @return \StructType\Project_Role_CategoryObjectType[]|null
     */
    public function getProject_Role_Category_Reference()
    {
        return $this->Project_Role_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Role_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Role_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Role_Category_ReferenceForArrayConstraintsFromSetProject_Role_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Role_Category_Request_ReferencesTypeProject_Role_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Role_Category_Request_ReferencesTypeProject_Role_Category_ReferenceItem instanceof \StructType\Project_Role_CategoryObjectType) {
                $invalidValues[] = is_object($project_Role_Category_Request_ReferencesTypeProject_Role_Category_ReferenceItem) ? get_class($project_Role_Category_Request_ReferencesTypeProject_Role_Category_ReferenceItem) : sprintf('%s(%s)', gettype($project_Role_Category_Request_ReferencesTypeProject_Role_Category_ReferenceItem), var_export($project_Role_Category_Request_ReferencesTypeProject_Role_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Role_Category_Reference property can only contain items of type \StructType\Project_Role_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Role_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Role_CategoryObjectType[] $project_Role_Category_Reference
     * @return \StructType\Project_Role_Category_Request_ReferencesType
     */
    public function setProject_Role_Category_Reference(array $project_Role_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Role_Category_ReferenceArrayErrorMessage = self::validateProject_Role_Category_ReferenceForArrayConstraintsFromSetProject_Role_Category_Reference($project_Role_Category_Reference))) {
            throw new \InvalidArgumentException($project_Role_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Role_Category_Reference = $project_Role_Category_Reference;
        return $this;
    }
    /**
     * Add item to Project_Role_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Role_CategoryObjectType $item
     * @return \StructType\Project_Role_Category_Request_ReferencesType
     */
    public function addToProject_Role_Category_Reference(\StructType\Project_Role_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Role_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Role_Category_Reference property can only contain items of type \StructType\Project_Role_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Role_Category_Reference[] = $item;
        return $this;
    }
}
