<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Role_Category_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data Element for Project Role Category
 * @subpackage Structs
 */
class Project_Role_Category_DataType extends AbstractStructBase
{
    /**
     * The Project_Role_Category_ID
     * Meta information extracted from the WSDL
     * - documentation: Unique ID for Project Role Category
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Role_Category_ID;
    /**
     * The Project_Role_Category_Name
     * Meta information extracted from the WSDL
     * - documentation: Unique Name for Project Role Category
     * - maxOccurs: 1
     * @var string
     */
    public $Project_Role_Category_Name;
    /**
     * The Project_Role_Category_Description
     * Meta information extracted from the WSDL
     * - documentation: Description for Project Role Category
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Role_Category_Description;
    /**
     * The Inactive_Project_Role_Category
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag to set the Project Role Categories to Inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive_Project_Role_Category;
    /**
     * Constructor method for Project_Role_Category_DataType
     * @uses Project_Role_Category_DataType::setProject_Role_Category_ID()
     * @uses Project_Role_Category_DataType::setProject_Role_Category_Name()
     * @uses Project_Role_Category_DataType::setProject_Role_Category_Description()
     * @uses Project_Role_Category_DataType::setInactive_Project_Role_Category()
     * @param string $project_Role_Category_ID
     * @param string $project_Role_Category_Name
     * @param string $project_Role_Category_Description
     * @param bool $inactive_Project_Role_Category
     */
    public function __construct($project_Role_Category_ID = null, $project_Role_Category_Name = null, $project_Role_Category_Description = null, $inactive_Project_Role_Category = null)
    {
        $this
            ->setProject_Role_Category_ID($project_Role_Category_ID)
            ->setProject_Role_Category_Name($project_Role_Category_Name)
            ->setProject_Role_Category_Description($project_Role_Category_Description)
            ->setInactive_Project_Role_Category($inactive_Project_Role_Category);
    }
    /**
     * Get Project_Role_Category_ID value
     * @return string|null
     */
    public function getProject_Role_Category_ID()
    {
        return $this->Project_Role_Category_ID;
    }
    /**
     * Set Project_Role_Category_ID value
     * @param string $project_Role_Category_ID
     * @return \StructType\Project_Role_Category_DataType
     */
    public function setProject_Role_Category_ID($project_Role_Category_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Role_Category_ID) && !is_string($project_Role_Category_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Role_Category_ID, true), gettype($project_Role_Category_ID)), __LINE__);
        }
        $this->Project_Role_Category_ID = $project_Role_Category_ID;
        return $this;
    }
    /**
     * Get Project_Role_Category_Name value
     * @return string|null
     */
    public function getProject_Role_Category_Name()
    {
        return $this->Project_Role_Category_Name;
    }
    /**
     * Set Project_Role_Category_Name value
     * @param string $project_Role_Category_Name
     * @return \StructType\Project_Role_Category_DataType
     */
    public function setProject_Role_Category_Name($project_Role_Category_Name = null)
    {
        // validation for constraint: string
        if (!is_null($project_Role_Category_Name) && !is_string($project_Role_Category_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Role_Category_Name, true), gettype($project_Role_Category_Name)), __LINE__);
        }
        $this->Project_Role_Category_Name = $project_Role_Category_Name;
        return $this;
    }
    /**
     * Get Project_Role_Category_Description value
     * @return string|null
     */
    public function getProject_Role_Category_Description()
    {
        return $this->Project_Role_Category_Description;
    }
    /**
     * Set Project_Role_Category_Description value
     * @param string $project_Role_Category_Description
     * @return \StructType\Project_Role_Category_DataType
     */
    public function setProject_Role_Category_Description($project_Role_Category_Description = null)
    {
        // validation for constraint: string
        if (!is_null($project_Role_Category_Description) && !is_string($project_Role_Category_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Role_Category_Description, true), gettype($project_Role_Category_Description)), __LINE__);
        }
        $this->Project_Role_Category_Description = $project_Role_Category_Description;
        return $this;
    }
    /**
     * Get Inactive_Project_Role_Category value
     * @return bool|null
     */
    public function getInactive_Project_Role_Category()
    {
        return $this->Inactive_Project_Role_Category;
    }
    /**
     * Set Inactive_Project_Role_Category value
     * @param bool $inactive_Project_Role_Category
     * @return \StructType\Project_Role_Category_DataType
     */
    public function setInactive_Project_Role_Category($inactive_Project_Role_Category = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive_Project_Role_Category) && !is_bool($inactive_Project_Role_Category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive_Project_Role_Category, true), gettype($inactive_Project_Role_Category)), __LINE__);
        }
        $this->Inactive_Project_Role_Category = $inactive_Project_Role_Category;
        return $this;
    }
}
