<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Customer reference is for a customer that can be used as a basic worktag only. | Request Criteria for Get Projects.
 * @subpackage Structs
 */
class Project_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the Project
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Project_Name
     * Meta information extracted from the WSDL
     * - documentation: Project Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Name;
    /**
     * The Project_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Project Hierarchy for which this Project belongs.
     * - minOccurs: 0
     * @var \StructType\Project_HierarchyObjectType
     */
    public $Project_Hierarchy_Reference;
    /**
     * The Project_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project status or statuses (Approved, Canceled, Denied or In Progress)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Project_Status_Reference;
    /**
     * The Worker_who_owns_Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the worker who owns the project
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_who_owns_Project_Reference;
    /**
     * The Start_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Start Date On or After must be earlier than Start Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date_On_or_After;
    /**
     * The Start_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Start Date On or After must be earlier than Start Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date_On_or_Before;
    /**
     * The End_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: End Date On or After must be earlier than End Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date_On_or_After;
    /**
     * The End_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: End Date on or before, must be after End Date on or after.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date_On_or_Before;
    /**
     * The Customer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Customer Reference
     * - minOccurs: 0
     * @var \StructType\CustomerObjectType
     */
    public $Customer_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company that the project is for.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Project_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project Group that the project belongs.
     * - minOccurs: 0
     * @var \StructType\Project_GroupObjectType
     */
    public $Project_Group_Reference;
    /**
     * The Initiative_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Initiative Reference
     * - minOccurs: 0
     * @var \StructType\InitiativeObjectType
     */
    public $Initiative_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worktags provided are not valid for this transaction | Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for
     * each worktag type and is subject to configurable validation when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Success_Rating_Reference
     * Meta information extracted from the WSDL
     * - documentation: Success Rating reference for Project
     * - minOccurs: 0
     * @var \StructType\Success_RatingObjectType
     */
    public $Success_Rating_Reference;
    /**
     * The Assigned_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worker assigned to the Project
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Assigned_Worker_Reference;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - documentation: Retrieve Billable Projects
     * - choice: Billable | Non-Billable | Both_Billable_and_Non-Billable
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Billable;
    /**
     * The Non_Billable
     * Meta information extracted from the WSDL
     * - documentation: Retrieve Non-Billable Projects only if true.
     * - choice: Billable | Non-Billable | Both_Billable_and_Non-Billable
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Non_Billable;
    /**
     * The Both_Billable_and_Non_Billable
     * Meta information extracted from the WSDL
     * - documentation: Retrieve both Billable and Non-Billable projects
     * - choice: Billable | Non-Billable | Both_Billable_and_Non-Billable
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Both_Billable_and_Non_Billable;
    /**
     * The Capital
     * Meta information extracted from the WSDL
     * - documentation: Retrieve Capital Projects
     * - choice: Capital | Non-Capital | Both_Capital_and_Non-Capital
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Capital;
    /**
     * The Non_Capital
     * Meta information extracted from the WSDL
     * - documentation: Retrieve Non-Capital Projects
     * - choice: Capital | Non-Capital | Both_Capital_and_Non-Capital
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Non_Capital;
    /**
     * The Both_Capital_and_Non_Capital
     * Meta information extracted from the WSDL
     * - documentation: Retrieve both Capital and Non-Capital projects
     * - choice: Capital | Non-Capital | Both_Capital_and_Non-Capital
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Both_Capital_and_Non_Capital;
    /**
     * Constructor method for Project_Request_CriteriaType
     * @uses Project_Request_CriteriaType::setID()
     * @uses Project_Request_CriteriaType::setProject_Name()
     * @uses Project_Request_CriteriaType::setProject_Hierarchy_Reference()
     * @uses Project_Request_CriteriaType::setProject_Status_Reference()
     * @uses Project_Request_CriteriaType::setWorker_who_owns_Project_Reference()
     * @uses Project_Request_CriteriaType::setStart_Date_On_or_After()
     * @uses Project_Request_CriteriaType::setStart_Date_On_or_Before()
     * @uses Project_Request_CriteriaType::setEnd_Date_On_or_After()
     * @uses Project_Request_CriteriaType::setEnd_Date_On_or_Before()
     * @uses Project_Request_CriteriaType::setCustomer_Reference()
     * @uses Project_Request_CriteriaType::setCompany_Reference()
     * @uses Project_Request_CriteriaType::setProject_Group_Reference()
     * @uses Project_Request_CriteriaType::setInitiative_Reference()
     * @uses Project_Request_CriteriaType::setWorktags_Reference()
     * @uses Project_Request_CriteriaType::setSuccess_Rating_Reference()
     * @uses Project_Request_CriteriaType::setAssigned_Worker_Reference()
     * @uses Project_Request_CriteriaType::setBillable()
     * @uses Project_Request_CriteriaType::setNon_Billable()
     * @uses Project_Request_CriteriaType::setBoth_Billable_and_Non_Billable()
     * @uses Project_Request_CriteriaType::setCapital()
     * @uses Project_Request_CriteriaType::setNon_Capital()
     * @uses Project_Request_CriteriaType::setBoth_Capital_and_Non_Capital()
     * @param string $iD
     * @param string $project_Name
     * @param \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference
     * @param \StructType\Document_StatusObjectType[] $project_Status_Reference
     * @param \StructType\WorkerObjectType $worker_who_owns_Project_Reference
     * @param string $start_Date_On_or_After
     * @param string $start_Date_On_or_Before
     * @param string $end_Date_On_or_After
     * @param string $end_Date_On_or_Before
     * @param \StructType\CustomerObjectType $customer_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Project_GroupObjectType $project_Group_Reference
     * @param \StructType\InitiativeObjectType $initiative_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param \StructType\Success_RatingObjectType $success_Rating_Reference
     * @param \StructType\WorkerObjectType $assigned_Worker_Reference
     * @param bool $billable
     * @param bool $non_Billable
     * @param bool $both_Billable_and_Non_Billable
     * @param bool $capital
     * @param bool $non_Capital
     * @param bool $both_Capital_and_Non_Capital
     */
    public function __construct($iD = null, $project_Name = null, \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference = null, array $project_Status_Reference = array(), \StructType\WorkerObjectType $worker_who_owns_Project_Reference = null, $start_Date_On_or_After = null, $start_Date_On_or_Before = null, $end_Date_On_or_After = null, $end_Date_On_or_Before = null, \StructType\CustomerObjectType $customer_Reference = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Project_GroupObjectType $project_Group_Reference = null, \StructType\InitiativeObjectType $initiative_Reference = null, array $worktags_Reference = array(), \StructType\Success_RatingObjectType $success_Rating_Reference = null, \StructType\WorkerObjectType $assigned_Worker_Reference = null, $billable = null, $non_Billable = null, $both_Billable_and_Non_Billable = null, $capital = null, $non_Capital = null, $both_Capital_and_Non_Capital = null)
    {
        $this
            ->setID($iD)
            ->setProject_Name($project_Name)
            ->setProject_Hierarchy_Reference($project_Hierarchy_Reference)
            ->setProject_Status_Reference($project_Status_Reference)
            ->setWorker_who_owns_Project_Reference($worker_who_owns_Project_Reference)
            ->setStart_Date_On_or_After($start_Date_On_or_After)
            ->setStart_Date_On_or_Before($start_Date_On_or_Before)
            ->setEnd_Date_On_or_After($end_Date_On_or_After)
            ->setEnd_Date_On_or_Before($end_Date_On_or_Before)
            ->setCustomer_Reference($customer_Reference)
            ->setCompany_Reference($company_Reference)
            ->setProject_Group_Reference($project_Group_Reference)
            ->setInitiative_Reference($initiative_Reference)
            ->setWorktags_Reference($worktags_Reference)
            ->setSuccess_Rating_Reference($success_Rating_Reference)
            ->setAssigned_Worker_Reference($assigned_Worker_Reference)
            ->setBillable($billable)
            ->setNon_Billable($non_Billable)
            ->setBoth_Billable_and_Non_Billable($both_Billable_and_Non_Billable)
            ->setCapital($capital)
            ->setNon_Capital($non_Capital)
            ->setBoth_Capital_and_Non_Capital($both_Capital_and_Non_Capital);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Project_Name value
     * @return string|null
     */
    public function getProject_Name()
    {
        return $this->Project_Name;
    }
    /**
     * Set Project_Name value
     * @param string $project_Name
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setProject_Name($project_Name = null)
    {
        // validation for constraint: string
        if (!is_null($project_Name) && !is_string($project_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Name, true), gettype($project_Name)), __LINE__);
        }
        $this->Project_Name = $project_Name;
        return $this;
    }
    /**
     * Get Project_Hierarchy_Reference value
     * @return \StructType\Project_HierarchyObjectType|null
     */
    public function getProject_Hierarchy_Reference()
    {
        return $this->Project_Hierarchy_Reference;
    }
    /**
     * Set Project_Hierarchy_Reference value
     * @param \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setProject_Hierarchy_Reference(\StructType\Project_HierarchyObjectType $project_Hierarchy_Reference = null)
    {
        $this->Project_Hierarchy_Reference = $project_Hierarchy_Reference;
        return $this;
    }
    /**
     * Get Project_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getProject_Status_Reference()
    {
        return $this->Project_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Status_ReferenceForArrayConstraintsFromSetProject_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Request_CriteriaTypeProject_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Request_CriteriaTypeProject_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($project_Request_CriteriaTypeProject_Status_ReferenceItem) ? get_class($project_Request_CriteriaTypeProject_Status_ReferenceItem) : sprintf('%s(%s)', gettype($project_Request_CriteriaTypeProject_Status_ReferenceItem), var_export($project_Request_CriteriaTypeProject_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $project_Status_Reference
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setProject_Status_Reference(array $project_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Status_ReferenceArrayErrorMessage = self::validateProject_Status_ReferenceForArrayConstraintsFromSetProject_Status_Reference($project_Status_Reference))) {
            throw new \InvalidArgumentException($project_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Status_Reference = $project_Status_Reference;
        return $this;
    }
    /**
     * Add item to Project_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Project_Request_CriteriaType
     */
    public function addToProject_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Worker_who_owns_Project_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_who_owns_Project_Reference()
    {
        return $this->Worker_who_owns_Project_Reference;
    }
    /**
     * Set Worker_who_owns_Project_Reference value
     * @param \StructType\WorkerObjectType $worker_who_owns_Project_Reference
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setWorker_who_owns_Project_Reference(\StructType\WorkerObjectType $worker_who_owns_Project_Reference = null)
    {
        $this->Worker_who_owns_Project_Reference = $worker_who_owns_Project_Reference;
        return $this;
    }
    /**
     * Get Start_Date_On_or_After value
     * @return string|null
     */
    public function getStart_Date_On_or_After()
    {
        return $this->Start_Date_On_or_After;
    }
    /**
     * Set Start_Date_On_or_After value
     * @param string $start_Date_On_or_After
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setStart_Date_On_or_After($start_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date_On_or_After) && !is_string($start_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date_On_or_After, true), gettype($start_Date_On_or_After)), __LINE__);
        }
        $this->Start_Date_On_or_After = $start_Date_On_or_After;
        return $this;
    }
    /**
     * Get Start_Date_On_or_Before value
     * @return string|null
     */
    public function getStart_Date_On_or_Before()
    {
        return $this->Start_Date_On_or_Before;
    }
    /**
     * Set Start_Date_On_or_Before value
     * @param string $start_Date_On_or_Before
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setStart_Date_On_or_Before($start_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date_On_or_Before) && !is_string($start_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date_On_or_Before, true), gettype($start_Date_On_or_Before)), __LINE__);
        }
        $this->Start_Date_On_or_Before = $start_Date_On_or_Before;
        return $this;
    }
    /**
     * Get End_Date_On_or_After value
     * @return string|null
     */
    public function getEnd_Date_On_or_After()
    {
        return $this->End_Date_On_or_After;
    }
    /**
     * Set End_Date_On_or_After value
     * @param string $end_Date_On_or_After
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setEnd_Date_On_or_After($end_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date_On_or_After) && !is_string($end_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date_On_or_After, true), gettype($end_Date_On_or_After)), __LINE__);
        }
        $this->End_Date_On_or_After = $end_Date_On_or_After;
        return $this;
    }
    /**
     * Get End_Date_On_or_Before value
     * @return string|null
     */
    public function getEnd_Date_On_or_Before()
    {
        return $this->End_Date_On_or_Before;
    }
    /**
     * Set End_Date_On_or_Before value
     * @param string $end_Date_On_or_Before
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setEnd_Date_On_or_Before($end_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date_On_or_Before) && !is_string($end_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date_On_or_Before, true), gettype($end_Date_On_or_Before)), __LINE__);
        }
        $this->End_Date_On_or_Before = $end_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Customer_Reference value
     * @return \StructType\CustomerObjectType|null
     */
    public function getCustomer_Reference()
    {
        return $this->Customer_Reference;
    }
    /**
     * Set Customer_Reference value
     * @param \StructType\CustomerObjectType $customer_Reference
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setCustomer_Reference(\StructType\CustomerObjectType $customer_Reference = null)
    {
        $this->Customer_Reference = $customer_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Project_Group_Reference value
     * @return \StructType\Project_GroupObjectType|null
     */
    public function getProject_Group_Reference()
    {
        return $this->Project_Group_Reference;
    }
    /**
     * Set Project_Group_Reference value
     * @param \StructType\Project_GroupObjectType $project_Group_Reference
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setProject_Group_Reference(\StructType\Project_GroupObjectType $project_Group_Reference = null)
    {
        $this->Project_Group_Reference = $project_Group_Reference;
        return $this;
    }
    /**
     * Get Initiative_Reference value
     * @return \StructType\InitiativeObjectType|null
     */
    public function getInitiative_Reference()
    {
        return $this->Initiative_Reference;
    }
    /**
     * Set Initiative_Reference value
     * @param \StructType\InitiativeObjectType $initiative_Reference
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setInitiative_Reference(\StructType\InitiativeObjectType $initiative_Reference = null)
    {
        $this->Initiative_Reference = $initiative_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Request_CriteriaTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Request_CriteriaTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($project_Request_CriteriaTypeWorktags_ReferenceItem) ? get_class($project_Request_CriteriaTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($project_Request_CriteriaTypeWorktags_ReferenceItem), var_export($project_Request_CriteriaTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Project_Request_CriteriaType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Success_Rating_Reference value
     * @return \StructType\Success_RatingObjectType|null
     */
    public function getSuccess_Rating_Reference()
    {
        return $this->Success_Rating_Reference;
    }
    /**
     * Set Success_Rating_Reference value
     * @param \StructType\Success_RatingObjectType $success_Rating_Reference
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setSuccess_Rating_Reference(\StructType\Success_RatingObjectType $success_Rating_Reference = null)
    {
        $this->Success_Rating_Reference = $success_Rating_Reference;
        return $this;
    }
    /**
     * Get Assigned_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getAssigned_Worker_Reference()
    {
        return $this->Assigned_Worker_Reference;
    }
    /**
     * Set Assigned_Worker_Reference value
     * @param \StructType\WorkerObjectType $assigned_Worker_Reference
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setAssigned_Worker_Reference(\StructType\WorkerObjectType $assigned_Worker_Reference = null)
    {
        $this->Assigned_Worker_Reference = $assigned_Worker_Reference;
        return $this;
    }
    /**
     * Get Billable value
     * @return bool|null
     */
    public function getBillable()
    {
        return isset($this->Billable) ? $this->Billable : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBillable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillable method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBillableForChoiceConstraintsFromSetBillable($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Non_Billable',
            'Both_Billable_and_Non_Billable',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Billable can\'t be set as the property %s is already set. Only one property must be set among these properties: Billable, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Billable value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $billable
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setBillable($billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($billable) && !is_bool($billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billable, true), gettype($billable)), __LINE__);
        }
        // validation for constraint: choice(Billable, Non-Billable, Both_Billable_and_Non-Billable)
        if ('' !== ($billableChoiceErrorMessage = self::validateBillableForChoiceConstraintsFromSetBillable($billable))) {
            throw new \InvalidArgumentException($billableChoiceErrorMessage, __LINE__);
        }
        if (is_null($billable) || (is_array($billable) && empty($billable))) {
            unset($this->Billable);
        } else {
            $this->Billable = $billable;
        }
        return $this;
    }
    /**
     * Get Non_Billable value
     * @return bool|null
     */
    public function getNon_Billable()
    {
        return isset($this->{'Non-Billable'}) ? $this->{'Non-Billable'} : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNon_Billable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNon_Billable method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNon_BillableForChoiceConstraintsFromSetNon_Billable($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Billable',
            'Both_Billable_and_Non_Billable',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Non-Billable can\'t be set as the property %s is already set. Only one property must be set among these properties: Non-Billable, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Non_Billable value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $non_Billable
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setNon_Billable($non_Billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($non_Billable) && !is_bool($non_Billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($non_Billable, true), gettype($non_Billable)), __LINE__);
        }
        // validation for constraint: choice(Billable, Non-Billable, Both_Billable_and_Non-Billable)
        if ('' !== ($non_BillableChoiceErrorMessage = self::validateNon_BillableForChoiceConstraintsFromSetNon_Billable($non_Billable))) {
            throw new \InvalidArgumentException($non_BillableChoiceErrorMessage, __LINE__);
        }
        if (is_null($non_Billable) || (is_array($non_Billable) && empty($non_Billable))) {
            unset($this->Non_Billable, $this->{'Non-Billable'});
        } else {
            $this->Non_Billable = $this->{'Non-Billable'} = $non_Billable;
        }
        return $this;
    }
    /**
     * Get Both_Billable_and_Non_Billable value
     * @return bool|null
     */
    public function getBoth_Billable_and_Non_Billable()
    {
        return isset($this->{'Both_Billable_and_Non-Billable'}) ? $this->{'Both_Billable_and_Non-Billable'} : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBoth_Billable_and_Non_Billable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBoth_Billable_and_Non_Billable method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBoth_Billable_and_Non_BillableForChoiceConstraintsFromSetBoth_Billable_and_Non_Billable($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Billable',
            'Non_Billable',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Both_Billable_and_Non-Billable can\'t be set as the property %s is already set. Only one property must be set among these properties: Both_Billable_and_Non-Billable, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Both_Billable_and_Non_Billable value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $both_Billable_and_Non_Billable
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setBoth_Billable_and_Non_Billable($both_Billable_and_Non_Billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($both_Billable_and_Non_Billable) && !is_bool($both_Billable_and_Non_Billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($both_Billable_and_Non_Billable, true), gettype($both_Billable_and_Non_Billable)), __LINE__);
        }
        // validation for constraint: choice(Billable, Non-Billable, Both_Billable_and_Non-Billable)
        if ('' !== ($both_Billable_and_Non_BillableChoiceErrorMessage = self::validateBoth_Billable_and_Non_BillableForChoiceConstraintsFromSetBoth_Billable_and_Non_Billable($both_Billable_and_Non_Billable))) {
            throw new \InvalidArgumentException($both_Billable_and_Non_BillableChoiceErrorMessage, __LINE__);
        }
        if (is_null($both_Billable_and_Non_Billable) || (is_array($both_Billable_and_Non_Billable) && empty($both_Billable_and_Non_Billable))) {
            unset($this->Both_Billable_and_Non_Billable, $this->{'Both_Billable_and_Non-Billable'});
        } else {
            $this->Both_Billable_and_Non_Billable = $this->{'Both_Billable_and_Non-Billable'} = $both_Billable_and_Non_Billable;
        }
        return $this;
    }
    /**
     * Get Capital value
     * @return bool|null
     */
    public function getCapital()
    {
        return isset($this->Capital) ? $this->Capital : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCapital method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCapital method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCapitalForChoiceConstraintsFromSetCapital($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Non_Capital',
            'Both_Capital_and_Non_Capital',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Capital can\'t be set as the property %s is already set. Only one property must be set among these properties: Capital, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Capital value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $capital
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setCapital($capital = null)
    {
        // validation for constraint: boolean
        if (!is_null($capital) && !is_bool($capital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($capital, true), gettype($capital)), __LINE__);
        }
        // validation for constraint: choice(Capital, Non-Capital, Both_Capital_and_Non-Capital)
        if ('' !== ($capitalChoiceErrorMessage = self::validateCapitalForChoiceConstraintsFromSetCapital($capital))) {
            throw new \InvalidArgumentException($capitalChoiceErrorMessage, __LINE__);
        }
        if (is_null($capital) || (is_array($capital) && empty($capital))) {
            unset($this->Capital);
        } else {
            $this->Capital = $capital;
        }
        return $this;
    }
    /**
     * Get Non_Capital value
     * @return bool|null
     */
    public function getNon_Capital()
    {
        return isset($this->{'Non-Capital'}) ? $this->{'Non-Capital'} : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNon_Capital method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNon_Capital method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNon_CapitalForChoiceConstraintsFromSetNon_Capital($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Capital',
            'Both_Capital_and_Non_Capital',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Non-Capital can\'t be set as the property %s is already set. Only one property must be set among these properties: Non-Capital, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Non_Capital value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $non_Capital
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setNon_Capital($non_Capital = null)
    {
        // validation for constraint: boolean
        if (!is_null($non_Capital) && !is_bool($non_Capital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($non_Capital, true), gettype($non_Capital)), __LINE__);
        }
        // validation for constraint: choice(Capital, Non-Capital, Both_Capital_and_Non-Capital)
        if ('' !== ($non_CapitalChoiceErrorMessage = self::validateNon_CapitalForChoiceConstraintsFromSetNon_Capital($non_Capital))) {
            throw new \InvalidArgumentException($non_CapitalChoiceErrorMessage, __LINE__);
        }
        if (is_null($non_Capital) || (is_array($non_Capital) && empty($non_Capital))) {
            unset($this->Non_Capital, $this->{'Non-Capital'});
        } else {
            $this->Non_Capital = $this->{'Non-Capital'} = $non_Capital;
        }
        return $this;
    }
    /**
     * Get Both_Capital_and_Non_Capital value
     * @return bool|null
     */
    public function getBoth_Capital_and_Non_Capital()
    {
        return isset($this->{'Both_Capital_and_Non-Capital'}) ? $this->{'Both_Capital_and_Non-Capital'} : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBoth_Capital_and_Non_Capital method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBoth_Capital_and_Non_Capital method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBoth_Capital_and_Non_CapitalForChoiceConstraintsFromSetBoth_Capital_and_Non_Capital($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Capital',
            'Non_Capital',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Both_Capital_and_Non-Capital can\'t be set as the property %s is already set. Only one property must be set among these properties: Both_Capital_and_Non-Capital, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Both_Capital_and_Non_Capital value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $both_Capital_and_Non_Capital
     * @return \StructType\Project_Request_CriteriaType
     */
    public function setBoth_Capital_and_Non_Capital($both_Capital_and_Non_Capital = null)
    {
        // validation for constraint: boolean
        if (!is_null($both_Capital_and_Non_Capital) && !is_bool($both_Capital_and_Non_Capital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($both_Capital_and_Non_Capital, true), gettype($both_Capital_and_Non_Capital)), __LINE__);
        }
        // validation for constraint: choice(Capital, Non-Capital, Both_Capital_and_Non-Capital)
        if ('' !== ($both_Capital_and_Non_CapitalChoiceErrorMessage = self::validateBoth_Capital_and_Non_CapitalForChoiceConstraintsFromSetBoth_Capital_and_Non_Capital($both_Capital_and_Non_Capital))) {
            throw new \InvalidArgumentException($both_Capital_and_Non_CapitalChoiceErrorMessage, __LINE__);
        }
        if (is_null($both_Capital_and_Non_Capital) || (is_array($both_Capital_and_Non_Capital) && empty($both_Capital_and_Non_Capital))) {
            unset($this->Both_Capital_and_Non_Capital, $this->{'Both_Capital_and_Non-Capital'});
        } else {
            $this->Both_Capital_and_Non_Capital = $this->{'Both_Capital_and_Non-Capital'} = $both_Capital_and_Non_Capital;
        }
        return $this;
    }
}
