<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Portfolio_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Portfolio WWS Data
 * @subpackage Structs
 */
class Project_Portfolio_WWS_DataType extends AbstractStructBase
{
    /**
     * The Project_Portfolio_ID
     * Meta information extracted from the WSDL
     * - documentation: This is a unique identifier for Project Portfolio.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Portfolio_ID;
    /**
     * The Project_Portfolio_Name
     * Meta information extracted from the WSDL
     * - documentation: Free form text for a meaningful Project Portfolio Name. Project Portfolio Name must be unique.
     * - maxOccurs: 1
     * @var string
     */
    public $Project_Portfolio_Name;
    /**
     * The Parent_Project_Portfolio_Reference
     * Meta information extracted from the WSDL
     * - documentation: The parent of this project portfolio.
     * - minOccurs: 0
     * @var \StructType\Project_PortfolioObjectType
     */
    public $Parent_Project_Portfolio_Reference;
    /**
     * The Reporting_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The currency used by the project portfolio.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Reporting_Currency_Reference;
    /**
     * The Project_Portfolio_Owner_Reference
     * Meta information extracted from the WSDL
     * - documentation: The owner for this project portfolio.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Project_Portfolio_Owner_Reference;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: The project portfolio description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: The start date of the project portfolio.
     * - maxOccurs: 1
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: The end date of the project portfolio.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Funding_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount allocated to the project portfolio by its parent. This can only be updated by users with access to the parent project portfolio through the Manage: Project Portfolio Funding domain.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Funding_Amount;
    /**
     * The Funding_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The status of the funding amount for the project portfolio. This can only be updated by users with access to the parent project portfolio through the Manage: Project Portfolio Funding domain.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Funding_Status_Reference;
    /**
     * The Project_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Child_Project_Data_for_PortfolioType[]
     */
    public $Project_Data;
    /**
     * Constructor method for Project_Portfolio_WWS_DataType
     * @uses Project_Portfolio_WWS_DataType::setProject_Portfolio_ID()
     * @uses Project_Portfolio_WWS_DataType::setProject_Portfolio_Name()
     * @uses Project_Portfolio_WWS_DataType::setParent_Project_Portfolio_Reference()
     * @uses Project_Portfolio_WWS_DataType::setReporting_Currency_Reference()
     * @uses Project_Portfolio_WWS_DataType::setProject_Portfolio_Owner_Reference()
     * @uses Project_Portfolio_WWS_DataType::setDescription()
     * @uses Project_Portfolio_WWS_DataType::setStart_Date()
     * @uses Project_Portfolio_WWS_DataType::setEnd_Date()
     * @uses Project_Portfolio_WWS_DataType::setFunding_Amount()
     * @uses Project_Portfolio_WWS_DataType::setFunding_Status_Reference()
     * @uses Project_Portfolio_WWS_DataType::setProject_Data()
     * @param string $project_Portfolio_ID
     * @param string $project_Portfolio_Name
     * @param \StructType\Project_PortfolioObjectType $parent_Project_Portfolio_Reference
     * @param \StructType\CurrencyObjectType $reporting_Currency_Reference
     * @param \StructType\WorkerObjectType $project_Portfolio_Owner_Reference
     * @param string $description
     * @param string $start_Date
     * @param string $end_Date
     * @param float $funding_Amount
     * @param \StructType\Document_StatusObjectType $funding_Status_Reference
     * @param \StructType\Child_Project_Data_for_PortfolioType[] $project_Data
     */
    public function __construct($project_Portfolio_ID = null, $project_Portfolio_Name = null, \StructType\Project_PortfolioObjectType $parent_Project_Portfolio_Reference = null, \StructType\CurrencyObjectType $reporting_Currency_Reference = null, \StructType\WorkerObjectType $project_Portfolio_Owner_Reference = null, $description = null, $start_Date = null, $end_Date = null, $funding_Amount = null, \StructType\Document_StatusObjectType $funding_Status_Reference = null, array $project_Data = array())
    {
        $this
            ->setProject_Portfolio_ID($project_Portfolio_ID)
            ->setProject_Portfolio_Name($project_Portfolio_Name)
            ->setParent_Project_Portfolio_Reference($parent_Project_Portfolio_Reference)
            ->setReporting_Currency_Reference($reporting_Currency_Reference)
            ->setProject_Portfolio_Owner_Reference($project_Portfolio_Owner_Reference)
            ->setDescription($description)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setFunding_Amount($funding_Amount)
            ->setFunding_Status_Reference($funding_Status_Reference)
            ->setProject_Data($project_Data);
    }
    /**
     * Get Project_Portfolio_ID value
     * @return string|null
     */
    public function getProject_Portfolio_ID()
    {
        return $this->Project_Portfolio_ID;
    }
    /**
     * Set Project_Portfolio_ID value
     * @param string $project_Portfolio_ID
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setProject_Portfolio_ID($project_Portfolio_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Portfolio_ID) && !is_string($project_Portfolio_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Portfolio_ID, true), gettype($project_Portfolio_ID)), __LINE__);
        }
        $this->Project_Portfolio_ID = $project_Portfolio_ID;
        return $this;
    }
    /**
     * Get Project_Portfolio_Name value
     * @return string|null
     */
    public function getProject_Portfolio_Name()
    {
        return $this->Project_Portfolio_Name;
    }
    /**
     * Set Project_Portfolio_Name value
     * @param string $project_Portfolio_Name
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setProject_Portfolio_Name($project_Portfolio_Name = null)
    {
        // validation for constraint: string
        if (!is_null($project_Portfolio_Name) && !is_string($project_Portfolio_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Portfolio_Name, true), gettype($project_Portfolio_Name)), __LINE__);
        }
        $this->Project_Portfolio_Name = $project_Portfolio_Name;
        return $this;
    }
    /**
     * Get Parent_Project_Portfolio_Reference value
     * @return \StructType\Project_PortfolioObjectType|null
     */
    public function getParent_Project_Portfolio_Reference()
    {
        return $this->Parent_Project_Portfolio_Reference;
    }
    /**
     * Set Parent_Project_Portfolio_Reference value
     * @param \StructType\Project_PortfolioObjectType $parent_Project_Portfolio_Reference
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setParent_Project_Portfolio_Reference(\StructType\Project_PortfolioObjectType $parent_Project_Portfolio_Reference = null)
    {
        $this->Parent_Project_Portfolio_Reference = $parent_Project_Portfolio_Reference;
        return $this;
    }
    /**
     * Get Reporting_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getReporting_Currency_Reference()
    {
        return $this->Reporting_Currency_Reference;
    }
    /**
     * Set Reporting_Currency_Reference value
     * @param \StructType\CurrencyObjectType $reporting_Currency_Reference
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setReporting_Currency_Reference(\StructType\CurrencyObjectType $reporting_Currency_Reference = null)
    {
        $this->Reporting_Currency_Reference = $reporting_Currency_Reference;
        return $this;
    }
    /**
     * Get Project_Portfolio_Owner_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getProject_Portfolio_Owner_Reference()
    {
        return $this->Project_Portfolio_Owner_Reference;
    }
    /**
     * Set Project_Portfolio_Owner_Reference value
     * @param \StructType\WorkerObjectType $project_Portfolio_Owner_Reference
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setProject_Portfolio_Owner_Reference(\StructType\WorkerObjectType $project_Portfolio_Owner_Reference = null)
    {
        $this->Project_Portfolio_Owner_Reference = $project_Portfolio_Owner_Reference;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Funding_Amount value
     * @return float|null
     */
    public function getFunding_Amount()
    {
        return $this->Funding_Amount;
    }
    /**
     * Set Funding_Amount value
     * @param float $funding_Amount
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setFunding_Amount($funding_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($funding_Amount) && !(is_float($funding_Amount) || is_numeric($funding_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($funding_Amount, true), gettype($funding_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($funding_Amount) && mb_strlen(mb_substr($funding_Amount, false !== mb_strpos($funding_Amount, '.') ? mb_strpos($funding_Amount, '.') + 1 : mb_strlen($funding_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($funding_Amount, true), mb_strlen(mb_substr($funding_Amount, mb_strpos($funding_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($funding_Amount) && $funding_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($funding_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($funding_Amount) && mb_strlen(preg_replace('/(\D)/', '', $funding_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($funding_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $funding_Amount))), __LINE__);
        }
        $this->Funding_Amount = $funding_Amount;
        return $this;
    }
    /**
     * Get Funding_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getFunding_Status_Reference()
    {
        return $this->Funding_Status_Reference;
    }
    /**
     * Set Funding_Status_Reference value
     * @param \StructType\Document_StatusObjectType $funding_Status_Reference
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setFunding_Status_Reference(\StructType\Document_StatusObjectType $funding_Status_Reference = null)
    {
        $this->Funding_Status_Reference = $funding_Status_Reference;
        return $this;
    }
    /**
     * Get Project_Data value
     * @return \StructType\Child_Project_Data_for_PortfolioType[]|null
     */
    public function getProject_Data()
    {
        return $this->Project_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_DataForArrayConstraintsFromSetProject_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Portfolio_WWS_DataTypeProject_DataItem) {
            // validation for constraint: itemType
            if (!$project_Portfolio_WWS_DataTypeProject_DataItem instanceof \StructType\Child_Project_Data_for_PortfolioType) {
                $invalidValues[] = is_object($project_Portfolio_WWS_DataTypeProject_DataItem) ? get_class($project_Portfolio_WWS_DataTypeProject_DataItem) : sprintf('%s(%s)', gettype($project_Portfolio_WWS_DataTypeProject_DataItem), var_export($project_Portfolio_WWS_DataTypeProject_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Data property can only contain items of type \StructType\Child_Project_Data_for_PortfolioType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Child_Project_Data_for_PortfolioType[] $project_Data
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function setProject_Data(array $project_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_DataArrayErrorMessage = self::validateProject_DataForArrayConstraintsFromSetProject_Data($project_Data))) {
            throw new \InvalidArgumentException($project_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Data = $project_Data;
        return $this;
    }
    /**
     * Add item to Project_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Child_Project_Data_for_PortfolioType $item
     * @return \StructType\Project_Portfolio_WWS_DataType
     */
    public function addToProject_Data(\StructType\Child_Project_Data_for_PortfolioType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Child_Project_Data_for_PortfolioType) {
            throw new \InvalidArgumentException(sprintf('The Project_Data property can only contain items of type \StructType\Child_Project_Data_for_PortfolioType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Data[] = $item;
        return $this;
    }
}
