<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Phase_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains project plan data. Project plan consists of phases and tasks. If a phase name is not provided, all tasks identified will still be grouped under a phase. If the element is not included, removal of the phase is assumed and the
 * phase and all tasks will be removed from the project, where valid to do so.
 * @subpackage Structs
 */
class Project_Plan_Phase_WWS_DataType extends AbstractStructBase
{
    /**
     * The Project_Plan_Phase_ID
     * Meta information extracted from the WSDL
     * - documentation: Phase ID. This is the phase unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Plan_Phase_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Specifies the display order of the phase in the project plan.Specify the order using lower case letters.If the maximum number of child phases for a parent is less than or equal to 26, use one letter. Example: a, b, c ... z.If it is
     * less than or equal to 676, use two letters. Example: aa, ab, ac ... zz.If it is less than or equal to 17576, use three letters. Example: aaa, aab, aac, ... zzz.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Phase_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Phase Reference
     * - minOccurs: 0
     * @var \StructType\Project_PhaseObjectType
     */
    public $Phase_Reference;
    /**
     * The Parent_Project_Plan_Phase_Reference
     * Meta information extracted from the WSDL
     * - documentation: Parent Project Plan Phase Reference
     * - minOccurs: 0
     * @var \StructType\Project_Plan_PhaseObjectType
     */
    public $Parent_Project_Plan_Phase_Reference;
    /**
     * The Project_Plan_Task_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains task data that are grouped under a phase.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Plan_Task_WWS_DataType[]
     */
    public $Project_Plan_Task_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If Delete is set to true, Replace All must be set to false. | Flag indicating that the referenced data should be deleted.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Project_Plan_Phase_WWS_DataType
     * @uses Project_Plan_Phase_WWS_DataType::setProject_Plan_Phase_ID()
     * @uses Project_Plan_Phase_WWS_DataType::setOrder()
     * @uses Project_Plan_Phase_WWS_DataType::setPhase_Reference()
     * @uses Project_Plan_Phase_WWS_DataType::setParent_Project_Plan_Phase_Reference()
     * @uses Project_Plan_Phase_WWS_DataType::setProject_Plan_Task_Data()
     * @uses Project_Plan_Phase_WWS_DataType::setDelete()
     * @param string $project_Plan_Phase_ID
     * @param string $order
     * @param \StructType\Project_PhaseObjectType $phase_Reference
     * @param \StructType\Project_Plan_PhaseObjectType $parent_Project_Plan_Phase_Reference
     * @param \StructType\Project_Plan_Task_WWS_DataType[] $project_Plan_Task_Data
     * @param bool $delete
     */
    public function __construct($project_Plan_Phase_ID = null, $order = null, \StructType\Project_PhaseObjectType $phase_Reference = null, \StructType\Project_Plan_PhaseObjectType $parent_Project_Plan_Phase_Reference = null, array $project_Plan_Task_Data = array(), $delete = null)
    {
        $this
            ->setProject_Plan_Phase_ID($project_Plan_Phase_ID)
            ->setOrder($order)
            ->setPhase_Reference($phase_Reference)
            ->setParent_Project_Plan_Phase_Reference($parent_Project_Plan_Phase_Reference)
            ->setProject_Plan_Task_Data($project_Plan_Task_Data)
            ->setDelete($delete);
    }
    /**
     * Get Project_Plan_Phase_ID value
     * @return string|null
     */
    public function getProject_Plan_Phase_ID()
    {
        return $this->Project_Plan_Phase_ID;
    }
    /**
     * Set Project_Plan_Phase_ID value
     * @param string $project_Plan_Phase_ID
     * @return \StructType\Project_Plan_Phase_WWS_DataType
     */
    public function setProject_Plan_Phase_ID($project_Plan_Phase_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Plan_Phase_ID) && !is_string($project_Plan_Phase_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Plan_Phase_ID, true), gettype($project_Plan_Phase_ID)), __LINE__);
        }
        $this->Project_Plan_Phase_ID = $project_Plan_Phase_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Project_Plan_Phase_WWS_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Phase_Reference value
     * @return \StructType\Project_PhaseObjectType|null
     */
    public function getPhase_Reference()
    {
        return $this->Phase_Reference;
    }
    /**
     * Set Phase_Reference value
     * @param \StructType\Project_PhaseObjectType $phase_Reference
     * @return \StructType\Project_Plan_Phase_WWS_DataType
     */
    public function setPhase_Reference(\StructType\Project_PhaseObjectType $phase_Reference = null)
    {
        $this->Phase_Reference = $phase_Reference;
        return $this;
    }
    /**
     * Get Parent_Project_Plan_Phase_Reference value
     * @return \StructType\Project_Plan_PhaseObjectType|null
     */
    public function getParent_Project_Plan_Phase_Reference()
    {
        return $this->Parent_Project_Plan_Phase_Reference;
    }
    /**
     * Set Parent_Project_Plan_Phase_Reference value
     * @param \StructType\Project_Plan_PhaseObjectType $parent_Project_Plan_Phase_Reference
     * @return \StructType\Project_Plan_Phase_WWS_DataType
     */
    public function setParent_Project_Plan_Phase_Reference(\StructType\Project_Plan_PhaseObjectType $parent_Project_Plan_Phase_Reference = null)
    {
        $this->Parent_Project_Plan_Phase_Reference = $parent_Project_Plan_Phase_Reference;
        return $this;
    }
    /**
     * Get Project_Plan_Task_Data value
     * @return \StructType\Project_Plan_Task_WWS_DataType[]|null
     */
    public function getProject_Plan_Task_Data()
    {
        return $this->Project_Plan_Task_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Plan_Task_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Plan_Task_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Plan_Task_DataForArrayConstraintsFromSetProject_Plan_Task_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_Phase_WWS_DataTypeProject_Plan_Task_DataItem) {
            // validation for constraint: itemType
            if (!$project_Plan_Phase_WWS_DataTypeProject_Plan_Task_DataItem instanceof \StructType\Project_Plan_Task_WWS_DataType) {
                $invalidValues[] = is_object($project_Plan_Phase_WWS_DataTypeProject_Plan_Task_DataItem) ? get_class($project_Plan_Phase_WWS_DataTypeProject_Plan_Task_DataItem) : sprintf('%s(%s)', gettype($project_Plan_Phase_WWS_DataTypeProject_Plan_Task_DataItem), var_export($project_Plan_Phase_WWS_DataTypeProject_Plan_Task_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Plan_Task_Data property can only contain items of type \StructType\Project_Plan_Task_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Plan_Task_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Task_WWS_DataType[] $project_Plan_Task_Data
     * @return \StructType\Project_Plan_Phase_WWS_DataType
     */
    public function setProject_Plan_Task_Data(array $project_Plan_Task_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Plan_Task_DataArrayErrorMessage = self::validateProject_Plan_Task_DataForArrayConstraintsFromSetProject_Plan_Task_Data($project_Plan_Task_Data))) {
            throw new \InvalidArgumentException($project_Plan_Task_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Plan_Task_Data = $project_Plan_Task_Data;
        return $this;
    }
    /**
     * Add item to Project_Plan_Task_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Task_WWS_DataType $item
     * @return \StructType\Project_Plan_Phase_WWS_DataType
     */
    public function addToProject_Plan_Task_Data(\StructType\Project_Plan_Task_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_Task_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Plan_Task_Data property can only contain items of type \StructType\Project_Plan_Task_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Plan_Task_Data[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Project_Plan_Phase_WWS_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
