<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project-Based_Requisition_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Only one worktag for each type is allowed for each document line. | Can not have any combination of Project, Project Phase or Project Task worktags for the same line. | Project reference is for a project that can be used as a basic
 * worktag only. | Element containing Project-Based Requisition Line data. A Requisition may have multiple Project-Based requisition lines.
 * @subpackage Structs
 */
class Project_Based_Requisition_Line_DataType extends AbstractStructBase
{
    /**
     * The Deliverables_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Project-Based Requisition Line
     * - minOccurs: 0
     * @var \StructType\Project_Based_Requisition_LineObjectType
     */
    public $Deliverables_Line_Reference;
    /**
     * The Deliverables_Requisition_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deliverables_Requisition_Line_ID;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company at the line level that has an intercompany relationship with the company at the header level.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project.
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Requisition Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Project_Phase_Data
     * Meta information extracted from the WSDL
     * - documentation: Element Containing Project Plan Phase Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Plan_Phase_Requisition_DataType[]
     */
    public $Project_Phase_Data;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: If Multi-Company is enabled, this validation compares against the Line Company and requires that the line Company is provided when Grant is supplied. | The Worktags provided are not valid for this transaction | Reference to existing
     * worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Source_This_Line
     * Meta information extracted from the WSDL
     * - documentation: Mark this line for auto-sourcing. A supplier reference must also be provided.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Source_This_Line;
    /**
     * The Mark_Purchase_Order_As_Issued
     * Meta information extracted from the WSDL
     * - documentation: Sets the resulting Purchase Order Issue Option to External which automatically issued the Purchase Order. This can only be used with "Source This Line". Additionally, all Requisition Lines for the resulting Purchase Order must have
     * this set or the Purchase Order will not be auto-issued.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Mark_Purchase_Order_As_Issued;
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Purchase Order Line sourced from the Requisition Line. This field is READ ONLY.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_LineObjectType[]
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Deliverables_Requisition_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_Split_DataType[]
     */
    public $Deliverables_Requisition_Line_Split_Data;
    /**
     * Constructor method for Project-Based_Requisition_Line_DataType
     * @uses Project_Based_Requisition_Line_DataType::setDeliverables_Line_Reference()
     * @uses Project_Based_Requisition_Line_DataType::setDeliverables_Requisition_Line_ID()
     * @uses Project_Based_Requisition_Line_DataType::setLine_Company_Reference()
     * @uses Project_Based_Requisition_Line_DataType::setProject_Reference()
     * @uses Project_Based_Requisition_Line_DataType::setSupplier_Reference()
     * @uses Project_Based_Requisition_Line_DataType::setMemo()
     * @uses Project_Based_Requisition_Line_DataType::setSpend_Category_Reference()
     * @uses Project_Based_Requisition_Line_DataType::setProject_Phase_Data()
     * @uses Project_Based_Requisition_Line_DataType::setExtended_Amount()
     * @uses Project_Based_Requisition_Line_DataType::setWorktags_Reference()
     * @uses Project_Based_Requisition_Line_DataType::setSource_This_Line()
     * @uses Project_Based_Requisition_Line_DataType::setMark_Purchase_Order_As_Issued()
     * @uses Project_Based_Requisition_Line_DataType::setPurchase_Order_Line_Reference()
     * @uses Project_Based_Requisition_Line_DataType::setDeliverables_Requisition_Line_Split_Data()
     * @param \StructType\Project_Based_Requisition_LineObjectType $deliverables_Line_Reference
     * @param string $deliverables_Requisition_Line_ID
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param \StructType\ProjectObjectType $project_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param string $memo
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Project_Plan_Phase_Requisition_DataType[] $project_Phase_Data
     * @param float $extended_Amount
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param bool $source_This_Line
     * @param bool $mark_Purchase_Order_As_Issued
     * @param \StructType\Purchase_Order_LineObjectType[] $purchase_Order_Line_Reference
     * @param \StructType\Business_Document_Line_Split_DataType[] $deliverables_Requisition_Line_Split_Data
     */
    public function __construct(\StructType\Project_Based_Requisition_LineObjectType $deliverables_Line_Reference = null, $deliverables_Requisition_Line_ID = null, \StructType\CompanyObjectType $line_Company_Reference = null, \StructType\ProjectObjectType $project_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, $memo = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, array $project_Phase_Data = array(), $extended_Amount = null, array $worktags_Reference = array(), $source_This_Line = null, $mark_Purchase_Order_As_Issued = null, array $purchase_Order_Line_Reference = array(), array $deliverables_Requisition_Line_Split_Data = array())
    {
        $this
            ->setDeliverables_Line_Reference($deliverables_Line_Reference)
            ->setDeliverables_Requisition_Line_ID($deliverables_Requisition_Line_ID)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setProject_Reference($project_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setMemo($memo)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setProject_Phase_Data($project_Phase_Data)
            ->setExtended_Amount($extended_Amount)
            ->setWorktags_Reference($worktags_Reference)
            ->setSource_This_Line($source_This_Line)
            ->setMark_Purchase_Order_As_Issued($mark_Purchase_Order_As_Issued)
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setDeliverables_Requisition_Line_Split_Data($deliverables_Requisition_Line_Split_Data);
    }
    /**
     * Get Deliverables_Line_Reference value
     * @return \StructType\Project_Based_Requisition_LineObjectType|null
     */
    public function getDeliverables_Line_Reference()
    {
        return $this->Deliverables_Line_Reference;
    }
    /**
     * Set Deliverables_Line_Reference value
     * @param \StructType\Project_Based_Requisition_LineObjectType $deliverables_Line_Reference
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setDeliverables_Line_Reference(\StructType\Project_Based_Requisition_LineObjectType $deliverables_Line_Reference = null)
    {
        $this->Deliverables_Line_Reference = $deliverables_Line_Reference;
        return $this;
    }
    /**
     * Get Deliverables_Requisition_Line_ID value
     * @return string|null
     */
    public function getDeliverables_Requisition_Line_ID()
    {
        return $this->Deliverables_Requisition_Line_ID;
    }
    /**
     * Set Deliverables_Requisition_Line_ID value
     * @param string $deliverables_Requisition_Line_ID
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setDeliverables_Requisition_Line_ID($deliverables_Requisition_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($deliverables_Requisition_Line_ID) && !is_string($deliverables_Requisition_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverables_Requisition_Line_ID, true), gettype($deliverables_Requisition_Line_ID)), __LINE__);
        }
        $this->Deliverables_Requisition_Line_ID = $deliverables_Requisition_Line_ID;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Project_Phase_Data value
     * @return \StructType\Project_Plan_Phase_Requisition_DataType[]|null
     */
    public function getProject_Phase_Data()
    {
        return $this->Project_Phase_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Phase_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Phase_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Phase_DataForArrayConstraintsFromSetProject_Phase_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Based_Requisition_Line_DataTypeProject_Phase_DataItem) {
            // validation for constraint: itemType
            if (!$project_Based_Requisition_Line_DataTypeProject_Phase_DataItem instanceof \StructType\Project_Plan_Phase_Requisition_DataType) {
                $invalidValues[] = is_object($project_Based_Requisition_Line_DataTypeProject_Phase_DataItem) ? get_class($project_Based_Requisition_Line_DataTypeProject_Phase_DataItem) : sprintf('%s(%s)', gettype($project_Based_Requisition_Line_DataTypeProject_Phase_DataItem), var_export($project_Based_Requisition_Line_DataTypeProject_Phase_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Phase_Data property can only contain items of type \StructType\Project_Plan_Phase_Requisition_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Phase_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Phase_Requisition_DataType[] $project_Phase_Data
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setProject_Phase_Data(array $project_Phase_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Phase_DataArrayErrorMessage = self::validateProject_Phase_DataForArrayConstraintsFromSetProject_Phase_Data($project_Phase_Data))) {
            throw new \InvalidArgumentException($project_Phase_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Phase_Data = $project_Phase_Data;
        return $this;
    }
    /**
     * Add item to Project_Phase_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Phase_Requisition_DataType $item
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function addToProject_Phase_Data(\StructType\Project_Plan_Phase_Requisition_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_Phase_Requisition_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Phase_Data property can only contain items of type \StructType\Project_Plan_Phase_Requisition_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Phase_Data[] = $item;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Based_Requisition_Line_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Based_Requisition_Line_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($project_Based_Requisition_Line_DataTypeWorktags_ReferenceItem) ? get_class($project_Based_Requisition_Line_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($project_Based_Requisition_Line_DataTypeWorktags_ReferenceItem), var_export($project_Based_Requisition_Line_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Source_This_Line value
     * @return bool|null
     */
    public function getSource_This_Line()
    {
        return $this->Source_This_Line;
    }
    /**
     * Set Source_This_Line value
     * @param bool $source_This_Line
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setSource_This_Line($source_This_Line = null)
    {
        // validation for constraint: boolean
        if (!is_null($source_This_Line) && !is_bool($source_This_Line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($source_This_Line, true), gettype($source_This_Line)), __LINE__);
        }
        $this->Source_This_Line = $source_This_Line;
        return $this;
    }
    /**
     * Get Mark_Purchase_Order_As_Issued value
     * @return bool|null
     */
    public function getMark_Purchase_Order_As_Issued()
    {
        return $this->Mark_Purchase_Order_As_Issued;
    }
    /**
     * Set Mark_Purchase_Order_As_Issued value
     * @param bool $mark_Purchase_Order_As_Issued
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setMark_Purchase_Order_As_Issued($mark_Purchase_Order_As_Issued = null)
    {
        // validation for constraint: boolean
        if (!is_null($mark_Purchase_Order_As_Issued) && !is_bool($mark_Purchase_Order_As_Issued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mark_Purchase_Order_As_Issued, true), gettype($mark_Purchase_Order_As_Issued)), __LINE__);
        }
        $this->Mark_Purchase_Order_As_Issued = $mark_Purchase_Order_As_Issued;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Purchase_Order_LineObjectType[]|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Line_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Line_ReferenceForArrayConstraintsFromSetPurchase_Order_Line_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Based_Requisition_Line_DataTypePurchase_Order_Line_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Based_Requisition_Line_DataTypePurchase_Order_Line_ReferenceItem instanceof \StructType\Purchase_Order_LineObjectType) {
                $invalidValues[] = is_object($project_Based_Requisition_Line_DataTypePurchase_Order_Line_ReferenceItem) ? get_class($project_Based_Requisition_Line_DataTypePurchase_Order_Line_ReferenceItem) : sprintf('%s(%s)', gettype($project_Based_Requisition_Line_DataTypePurchase_Order_Line_ReferenceItem), var_export($project_Based_Requisition_Line_DataTypePurchase_Order_Line_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Line_Reference property can only contain items of type \StructType\Purchase_Order_LineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_LineObjectType[] $purchase_Order_Line_Reference
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setPurchase_Order_Line_Reference(array $purchase_Order_Line_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Line_ReferenceArrayErrorMessage = self::validatePurchase_Order_Line_ReferenceForArrayConstraintsFromSetPurchase_Order_Line_Reference($purchase_Order_Line_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_Line_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_LineObjectType $item
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function addToPurchase_Order_Line_Reference(\StructType\Purchase_Order_LineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_LineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Line_Reference property can only contain items of type \StructType\Purchase_Order_LineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Line_Reference[] = $item;
        return $this;
    }
    /**
     * Get Deliverables_Requisition_Line_Split_Data value
     * @return \StructType\Business_Document_Line_Split_DataType[]|null
     */
    public function getDeliverables_Requisition_Line_Split_Data()
    {
        return $this->Deliverables_Requisition_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliverables_Requisition_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliverables_Requisition_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliverables_Requisition_Line_Split_DataForArrayConstraintsFromSetDeliverables_Requisition_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Based_Requisition_Line_DataTypeDeliverables_Requisition_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$project_Based_Requisition_Line_DataTypeDeliverables_Requisition_Line_Split_DataItem instanceof \StructType\Business_Document_Line_Split_DataType) {
                $invalidValues[] = is_object($project_Based_Requisition_Line_DataTypeDeliverables_Requisition_Line_Split_DataItem) ? get_class($project_Based_Requisition_Line_DataTypeDeliverables_Requisition_Line_Split_DataItem) : sprintf('%s(%s)', gettype($project_Based_Requisition_Line_DataTypeDeliverables_Requisition_Line_Split_DataItem), var_export($project_Based_Requisition_Line_DataTypeDeliverables_Requisition_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Deliverables_Requisition_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Deliverables_Requisition_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType[] $deliverables_Requisition_Line_Split_Data
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function setDeliverables_Requisition_Line_Split_Data(array $deliverables_Requisition_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($deliverables_Requisition_Line_Split_DataArrayErrorMessage = self::validateDeliverables_Requisition_Line_Split_DataForArrayConstraintsFromSetDeliverables_Requisition_Line_Split_Data($deliverables_Requisition_Line_Split_Data))) {
            throw new \InvalidArgumentException($deliverables_Requisition_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Deliverables_Requisition_Line_Split_Data = $deliverables_Requisition_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Deliverables_Requisition_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType $item
     * @return \StructType\Project_Based_Requisition_Line_DataType
     */
    public function addToDeliverables_Requisition_Line_Split_Data(\StructType\Business_Document_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Deliverables_Requisition_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Deliverables_Requisition_Line_Split_Data[] = $item;
        return $this;
    }
}
