<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Project Instance and Data
 * @subpackage Structs
 */
class ProjectType extends AbstractStructBase
{
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains references to instance of existing project ID and project create event WID.
     * - minOccurs: 0
     * @var \StructType\Project_AbstractObjectType
     */
    public $Project_Reference;
    /**
     * The Project_Data
     * Meta information extracted from the WSDL
     * - documentation: Project Data
     * - minOccurs: 0
     * @var \StructType\Project_DataType
     */
    public $Project_Data;
    /**
     * Constructor method for ProjectType
     * @uses ProjectType::setProject_Reference()
     * @uses ProjectType::setProject_Data()
     * @param \StructType\Project_AbstractObjectType $project_Reference
     * @param \StructType\Project_DataType $project_Data
     */
    public function __construct(\StructType\Project_AbstractObjectType $project_Reference = null, \StructType\Project_DataType $project_Data = null)
    {
        $this
            ->setProject_Reference($project_Reference)
            ->setProject_Data($project_Data);
    }
    /**
     * Get Project_Reference value
     * @return \StructType\Project_AbstractObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\Project_AbstractObjectType $project_Reference
     * @return \StructType\ProjectType
     */
    public function setProject_Reference(\StructType\Project_AbstractObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Project_Data value
     * @return \StructType\Project_DataType|null
     */
    public function getProject_Data()
    {
        return $this->Project_Data;
    }
    /**
     * Set Project_Data value
     * @param \StructType\Project_DataType $project_Data
     * @return \StructType\ProjectType
     */
    public function setProject_Data(\StructType\Project_DataType $project_Data = null)
    {
        $this->Project_Data = $project_Data;
        return $this;
    }
}
