<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Card_Transaction_Verification_Line_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Tax Applicability Reference is required is Tax Code is specified. | You can't associate a procurement card verification to purchase order line of the type Consignment or Bill and Replace. | You can't associate a procurement card
 * verification to supplier contract lines of the type Consignment. | Element containing Procurement Card Transaction Verification Line Data.
 * @subpackage Structs
 */
class Procurement_Card_Transaction_Verification_Line_DataType extends AbstractStructBase
{
    /**
     * The Automatic_Order
     * Meta information extracted from the WSDL
     * - documentation: Line order
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Automatic_Order;
    /**
     * The Intercompany_Affiliate_Reference
     * Meta information extracted from the WSDL
     * - documentation: Intercompany Affiliate Reference
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Intercompany_Affiliate_Reference;
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line Reference
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Supplier_Contract_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Line Reference
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_LineObjectType
     */
    public $Supplier_Contract_Line_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Reference
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Line_Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Line Item Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Item_Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category Reference
     * - minOccurs: 0
     * @var \StructType\Accounting_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure Reference
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date on a procurement card transaction verification line
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Conversion_Rate
     * Meta information extracted from the WSDL
     * - documentation: Conversion RateThis information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 24
     * @var float
     */
    public $Conversion_Rate;
    /**
     * The Credit_Card_Amount
     * Meta information extracted from the WSDL
     * - documentation: Credit Card AmountThis information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Credit_Card_Amount;
    /**
     * The Converted_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount the expense is converted to if it was incurred in a different currency. This cannot be used if you are entering the currency rate. Leave blank if you are entering a credit card transaction. | Converted AmountThis
     * information is for outbound purposes only and is not processed on inbound Workday Web Services requests. | Expense Credit Card Converted Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Converted_Amount;
    /**
     * The Credit_Card_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Currency ReferenceThis information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Credit_Card_Currency_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Taggable_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Taggable Type Reference
     * - minOccurs: 0
     * @var \StructType\Taggable_TypeObjectType
     */
    public $Taggable_Type_Reference;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company on Procurement Card Transaction Verification line must match Company of Grants Worktag | Worktag Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Distribution_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Distribution Method Reference
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Distribution_Method_Reference;
    /**
     * The Business_Document_Line_Split_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Business Document Line Split Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_Split_DataType[]
     */
    public $Business_Document_Line_Split_Data;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the tax applicability.If this is blank and there invoice line has a sales item, Workday will default tax applicability from the sales item. If the invoice line has a tax code then tax applicability
     * is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the tax code.If this is blank, Workday will default in the default tax code from the invoice header if there is one. If the invoice line has a tax applicability value, Workday will validate that the
     * invoice line also has a tax code.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Rate_Option
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType
     */
    public $Tax_Rate_Option;
    /**
     * Constructor method for Procurement_Card_Transaction_Verification_Line_DataType
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setAutomatic_Order()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setIntercompany_Affiliate_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setPurchase_Order_Line_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setSupplier_Contract_Line_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setItem_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setLine_Item_Description()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setSpend_Category_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setQuantity()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setUnit_of_Measure_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setUnit_Cost()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setExtended_Amount()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setBudget_Date()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setCurrency_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setConversion_Rate()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setCredit_Card_Amount()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setConverted_Amount()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setCredit_Card_Currency_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setMemo()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setTaggable_Type_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setWorktag_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setDistribution_Method_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setBusiness_Document_Line_Split_Data()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setTax_Applicability_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setTax_Code_Reference()
     * @uses Procurement_Card_Transaction_Verification_Line_DataType::setTax_Rate_Option()
     * @param string $automatic_Order
     * @param \StructType\CompanyObjectType $intercompany_Affiliate_Reference
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @param string $line_Item_Description
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Cost
     * @param float $extended_Amount
     * @param string $budget_Date
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $conversion_Rate
     * @param float $credit_Card_Amount
     * @param float $converted_Amount
     * @param \StructType\CurrencyObjectType $credit_Card_Currency_Reference
     * @param string $memo
     * @param \StructType\Taggable_TypeObjectType $taggable_Type_Reference
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @param \StructType\Unique_IdentifierObjectType $distribution_Method_Reference
     * @param \StructType\Business_Document_Line_Split_DataType[] $business_Document_Line_Split_Data
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Option
     */
    public function __construct($automatic_Order = null, \StructType\CompanyObjectType $intercompany_Affiliate_Reference = null, \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null, \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null, \StructType\Procurement_ItemObjectType $item_Reference = null, $line_Item_Description = null, \StructType\Accounting_CategoryObjectType $spend_Category_Reference = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Cost = null, $extended_Amount = null, $budget_Date = null, \StructType\CurrencyObjectType $currency_Reference = null, $conversion_Rate = null, $credit_Card_Amount = null, $converted_Amount = null, \StructType\CurrencyObjectType $credit_Card_Currency_Reference = null, $memo = null, \StructType\Taggable_TypeObjectType $taggable_Type_Reference = null, array $worktag_Reference = array(), \StructType\Unique_IdentifierObjectType $distribution_Method_Reference = null, array $business_Document_Line_Split_Data = array(), \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_Rate_Options_DataType $tax_Rate_Option = null)
    {
        $this
            ->setAutomatic_Order($automatic_Order)
            ->setIntercompany_Affiliate_Reference($intercompany_Affiliate_Reference)
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setSupplier_Contract_Line_Reference($supplier_Contract_Line_Reference)
            ->setItem_Reference($item_Reference)
            ->setLine_Item_Description($line_Item_Description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setExtended_Amount($extended_Amount)
            ->setBudget_Date($budget_Date)
            ->setCurrency_Reference($currency_Reference)
            ->setConversion_Rate($conversion_Rate)
            ->setCredit_Card_Amount($credit_Card_Amount)
            ->setConverted_Amount($converted_Amount)
            ->setCredit_Card_Currency_Reference($credit_Card_Currency_Reference)
            ->setMemo($memo)
            ->setTaggable_Type_Reference($taggable_Type_Reference)
            ->setWorktag_Reference($worktag_Reference)
            ->setDistribution_Method_Reference($distribution_Method_Reference)
            ->setBusiness_Document_Line_Split_Data($business_Document_Line_Split_Data)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Rate_Option($tax_Rate_Option);
    }
    /**
     * Get Automatic_Order value
     * @return string|null
     */
    public function getAutomatic_Order()
    {
        return $this->Automatic_Order;
    }
    /**
     * Set Automatic_Order value
     * @param string $automatic_Order
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setAutomatic_Order($automatic_Order = null)
    {
        // validation for constraint: string
        if (!is_null($automatic_Order) && !is_string($automatic_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($automatic_Order, true), gettype($automatic_Order)), __LINE__);
        }
        $this->Automatic_Order = $automatic_Order;
        return $this;
    }
    /**
     * Get Intercompany_Affiliate_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getIntercompany_Affiliate_Reference()
    {
        return $this->Intercompany_Affiliate_Reference;
    }
    /**
     * Set Intercompany_Affiliate_Reference value
     * @param \StructType\CompanyObjectType $intercompany_Affiliate_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setIntercompany_Affiliate_Reference(\StructType\CompanyObjectType $intercompany_Affiliate_Reference = null)
    {
        $this->Intercompany_Affiliate_Reference = $intercompany_Affiliate_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Purchase_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Reference value
     * @return \StructType\Supplier_Contract_LineObjectType|null
     */
    public function getSupplier_Contract_Line_Reference()
    {
        return $this->Supplier_Contract_Line_Reference;
    }
    /**
     * Set Supplier_Contract_Line_Reference value
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setSupplier_Contract_Line_Reference(\StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null)
    {
        $this->Supplier_Contract_Line_Reference = $supplier_Contract_Line_Reference;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setItem_Reference(\StructType\Procurement_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Line_Item_Description value
     * @return string|null
     */
    public function getLine_Item_Description()
    {
        return $this->Line_Item_Description;
    }
    /**
     * Set Line_Item_Description value
     * @param string $line_Item_Description
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setLine_Item_Description($line_Item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($line_Item_Description) && !is_string($line_Item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Item_Description, true), gettype($line_Item_Description)), __LINE__);
        }
        $this->Line_Item_Description = $line_Item_Description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Accounting_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Accounting_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Conversion_Rate value
     * @return float|null
     */
    public function getConversion_Rate()
    {
        return $this->Conversion_Rate;
    }
    /**
     * Set Conversion_Rate value
     * @param float $conversion_Rate
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setConversion_Rate($conversion_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($conversion_Rate) && !(is_float($conversion_Rate) || is_numeric($conversion_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversion_Rate, true), gettype($conversion_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($conversion_Rate) && mb_strlen(mb_substr($conversion_Rate, false !== mb_strpos($conversion_Rate, '.') ? mb_strpos($conversion_Rate, '.') + 1 : mb_strlen($conversion_Rate))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($conversion_Rate, true), mb_strlen(mb_substr($conversion_Rate, mb_strpos($conversion_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(24)
        if (!is_null($conversion_Rate) && mb_strlen(preg_replace('/(\D)/', '', $conversion_Rate)) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 24 digits, "%d" given', var_export($conversion_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $conversion_Rate))), __LINE__);
        }
        $this->Conversion_Rate = $conversion_Rate;
        return $this;
    }
    /**
     * Get Credit_Card_Amount value
     * @return float|null
     */
    public function getCredit_Card_Amount()
    {
        return $this->Credit_Card_Amount;
    }
    /**
     * Set Credit_Card_Amount value
     * @param float $credit_Card_Amount
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setCredit_Card_Amount($credit_Card_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($credit_Card_Amount) && !(is_float($credit_Card_Amount) || is_numeric($credit_Card_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($credit_Card_Amount, true), gettype($credit_Card_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($credit_Card_Amount) && mb_strlen(mb_substr($credit_Card_Amount, false !== mb_strpos($credit_Card_Amount, '.') ? mb_strpos($credit_Card_Amount, '.') + 1 : mb_strlen($credit_Card_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($credit_Card_Amount, true), mb_strlen(mb_substr($credit_Card_Amount, mb_strpos($credit_Card_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($credit_Card_Amount) && mb_strlen(preg_replace('/(\D)/', '', $credit_Card_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($credit_Card_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $credit_Card_Amount))), __LINE__);
        }
        $this->Credit_Card_Amount = $credit_Card_Amount;
        return $this;
    }
    /**
     * Get Converted_Amount value
     * @return float|null
     */
    public function getConverted_Amount()
    {
        return $this->Converted_Amount;
    }
    /**
     * Set Converted_Amount value
     * @param float $converted_Amount
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setConverted_Amount($converted_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($converted_Amount) && !(is_float($converted_Amount) || is_numeric($converted_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($converted_Amount, true), gettype($converted_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($converted_Amount) && mb_strlen(mb_substr($converted_Amount, false !== mb_strpos($converted_Amount, '.') ? mb_strpos($converted_Amount, '.') + 1 : mb_strlen($converted_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($converted_Amount, true), mb_strlen(mb_substr($converted_Amount, mb_strpos($converted_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($converted_Amount) && mb_strlen(preg_replace('/(\D)/', '', $converted_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($converted_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $converted_Amount))), __LINE__);
        }
        $this->Converted_Amount = $converted_Amount;
        return $this;
    }
    /**
     * Get Credit_Card_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCredit_Card_Currency_Reference()
    {
        return $this->Credit_Card_Currency_Reference;
    }
    /**
     * Set Credit_Card_Currency_Reference value
     * @param \StructType\CurrencyObjectType $credit_Card_Currency_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setCredit_Card_Currency_Reference(\StructType\CurrencyObjectType $credit_Card_Currency_Reference = null)
    {
        $this->Credit_Card_Currency_Reference = $credit_Card_Currency_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Taggable_Type_Reference value
     * @return \StructType\Taggable_TypeObjectType|null
     */
    public function getTaggable_Type_Reference()
    {
        return $this->Taggable_Type_Reference;
    }
    /**
     * Set Taggable_Type_Reference value
     * @param \StructType\Taggable_TypeObjectType $taggable_Type_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setTaggable_Type_Reference(\StructType\Taggable_TypeObjectType $taggable_Type_Reference = null)
    {
        $this->Taggable_Type_Reference = $taggable_Type_Reference;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Card_Transaction_Verification_Line_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$procurement_Card_Transaction_Verification_Line_DataTypeWorktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($procurement_Card_Transaction_Verification_Line_DataTypeWorktag_ReferenceItem) ? get_class($procurement_Card_Transaction_Verification_Line_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($procurement_Card_Transaction_Verification_Line_DataTypeWorktag_ReferenceItem), var_export($procurement_Card_Transaction_Verification_Line_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function addToWorktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Distribution_Method_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getDistribution_Method_Reference()
    {
        return $this->Distribution_Method_Reference;
    }
    /**
     * Set Distribution_Method_Reference value
     * @param \StructType\Unique_IdentifierObjectType $distribution_Method_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setDistribution_Method_Reference(\StructType\Unique_IdentifierObjectType $distribution_Method_Reference = null)
    {
        $this->Distribution_Method_Reference = $distribution_Method_Reference;
        return $this;
    }
    /**
     * Get Business_Document_Line_Split_Data value
     * @return \StructType\Business_Document_Line_Split_DataType[]|null
     */
    public function getBusiness_Document_Line_Split_Data()
    {
        return $this->Business_Document_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Document_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Document_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Document_Line_Split_DataForArrayConstraintsFromSetBusiness_Document_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Card_Transaction_Verification_Line_DataTypeBusiness_Document_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$procurement_Card_Transaction_Verification_Line_DataTypeBusiness_Document_Line_Split_DataItem instanceof \StructType\Business_Document_Line_Split_DataType) {
                $invalidValues[] = is_object($procurement_Card_Transaction_Verification_Line_DataTypeBusiness_Document_Line_Split_DataItem) ? get_class($procurement_Card_Transaction_Verification_Line_DataTypeBusiness_Document_Line_Split_DataItem) : sprintf('%s(%s)', gettype($procurement_Card_Transaction_Verification_Line_DataTypeBusiness_Document_Line_Split_DataItem), var_export($procurement_Card_Transaction_Verification_Line_DataTypeBusiness_Document_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Document_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Document_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType[] $business_Document_Line_Split_Data
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setBusiness_Document_Line_Split_Data(array $business_Document_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Document_Line_Split_DataArrayErrorMessage = self::validateBusiness_Document_Line_Split_DataForArrayConstraintsFromSetBusiness_Document_Line_Split_Data($business_Document_Line_Split_Data))) {
            throw new \InvalidArgumentException($business_Document_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Document_Line_Split_Data = $business_Document_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Business_Document_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType $item
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function addToBusiness_Document_Line_Split_Data(\StructType\Business_Document_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Document_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Document_Line_Split_Data[] = $item;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Rate_Option value
     * @return \StructType\Tax_Rate_Options_DataType|null
     */
    public function getTax_Rate_Option()
    {
        return $this->Tax_Rate_Option;
    }
    /**
     * Set Tax_Rate_Option value
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Option
     * @return \StructType\Procurement_Card_Transaction_Verification_Line_DataType
     */
    public function setTax_Rate_Option(\StructType\Tax_Rate_Options_DataType $tax_Rate_Option = null)
    {
        $this->Tax_Rate_Option = $tax_Rate_Option;
        return $this;
    }
}
