<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Priority_Ranked_Supplier_Item_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Associated Catalog Item for Purchase Item, and its sourcing priority.
 * @subpackage Structs
 */
class Priority_Ranked_Supplier_Item_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the Supplier Item.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier for Supplier or Catalog Item. Select a Supplier that exists in your Workday tenant.
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Item which is associated with the Purchase Item.
     * - minOccurs: 0
     * @var \StructType\Supplier_ItemObjectType
     */
    public $Supplier_Item_Reference;
    /**
     * The Catalog_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item which is associated with the Purchase Item.
     * - minOccurs: 0
     * @var \StructType\Catalog_ItemObjectType
     */
    public $Catalog_Item_Reference;
    /**
     * The Supplier_Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Catalog or Supplier Item Identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Item_Identifier;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Supplier or Catalog Item Description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Sourcing_Priority
     * Meta information extracted from the WSDL
     * - documentation: Sourcing Priority of the Catalog Item. | Sourcing priority for the supplier item
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 16
     * @var float
     */
    public $Sourcing_Priority;
    /**
     * The Item_URL
     * Meta information extracted from the WSDL
     * - documentation: Catalog or Supplier Item URL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_URL;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier contract(s) for the Catalog or Supplier item
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType[]
     */
    public $Supplier_Contract_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for the Catalog or Supplier item
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Lead Time | Catalog or Supplier Item Lead Time | Lead time for the UOM of the Catalog Item. | Lead time for the UOM of the supplier item. | Lead time for the supplier item | Lead time for the JIT UOM of the Catalog or
     * Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items. | Lead time for the Bulk UOM of the Catalog or Supplier
     * Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Lead_Time;
    /**
     * The Packaging_String
     * Meta information extracted from the WSDL
     * - documentation: Packaging String for Catalog Item linked to Purchase Item. Solely used for the Get operation (not the Put operation).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Packaging_String;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Used to inactivate an existing Catalog or Supplier Item
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Pricing_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Effective date for the UOM. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Pricing_Effective_Date;
    /**
     * The Calculate_Price_based_on_Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: Select to calculate price for Ordering and Just in Time UOMs based on the price entered for the Default Unit of Measure. When advanced pricing applies to a transaction with an undefined UOM, we calculate the price based on the
     * conversion factor of the price rule. This enables you to load 1 price for 1 UOM.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Calculate_Price_based_on_Conversion_Factor;
    /**
     * The Supplier_Item_Ordering_Pricing_Data
     * Meta information extracted from the WSDL
     * - documentation: Bulk UOM Data for Catalog or Supplier Item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType[]
     */
    public $Supplier_Item_Ordering_Pricing_Data;
    /**
     * The Supplier_Item_JIT_Pricing_Data
     * Meta information extracted from the WSDL
     * - documentation: JIT UOM Data for Catalog or Supplier Item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Priority_Ranked_Supplier_Catalog_Item_JIT_Pricing_DataType[]
     */
    public $Supplier_Item_JIT_Pricing_Data;
    /**
     * The Pricing_History
     * Meta information extracted from the WSDL
     * - documentation: Pricing History cannot be updated.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Item_Data_DataType[]
     */
    public $Pricing_History;
    /**
     * The Advanced_Pricing_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Item_Advanced_Pricing_DataType[]
     */
    public $Advanced_Pricing_Data;
    /**
     * Constructor method for Priority_Ranked_Supplier_Item_DataType
     * @uses Priority_Ranked_Supplier_Item_DataType::setID()
     * @uses Priority_Ranked_Supplier_Item_DataType::setSupplier_Reference()
     * @uses Priority_Ranked_Supplier_Item_DataType::setSupplier_Item_Reference()
     * @uses Priority_Ranked_Supplier_Item_DataType::setCatalog_Item_Reference()
     * @uses Priority_Ranked_Supplier_Item_DataType::setSupplier_Item_Identifier()
     * @uses Priority_Ranked_Supplier_Item_DataType::setItem_Description()
     * @uses Priority_Ranked_Supplier_Item_DataType::setSourcing_Priority()
     * @uses Priority_Ranked_Supplier_Item_DataType::setItem_URL()
     * @uses Priority_Ranked_Supplier_Item_DataType::setSupplier_Contract_Reference()
     * @uses Priority_Ranked_Supplier_Item_DataType::setCurrency_Reference()
     * @uses Priority_Ranked_Supplier_Item_DataType::setLead_Time()
     * @uses Priority_Ranked_Supplier_Item_DataType::setPackaging_String()
     * @uses Priority_Ranked_Supplier_Item_DataType::setInactive()
     * @uses Priority_Ranked_Supplier_Item_DataType::setPricing_Effective_Date()
     * @uses Priority_Ranked_Supplier_Item_DataType::setCalculate_Price_based_on_Conversion_Factor()
     * @uses Priority_Ranked_Supplier_Item_DataType::setSupplier_Item_Ordering_Pricing_Data()
     * @uses Priority_Ranked_Supplier_Item_DataType::setSupplier_Item_JIT_Pricing_Data()
     * @uses Priority_Ranked_Supplier_Item_DataType::setPricing_History()
     * @uses Priority_Ranked_Supplier_Item_DataType::setAdvanced_Pricing_Data()
     * @param string $iD
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Supplier_ItemObjectType $supplier_Item_Reference
     * @param \StructType\Catalog_ItemObjectType $catalog_Item_Reference
     * @param string $supplier_Item_Identifier
     * @param string $item_Description
     * @param float $sourcing_Priority
     * @param string $item_URL
     * @param \StructType\Supplier_ContractObjectType[] $supplier_Contract_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $lead_Time
     * @param string $packaging_String
     * @param bool $inactive
     * @param string $pricing_Effective_Date
     * @param bool $calculate_Price_based_on_Conversion_Factor
     * @param \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType[] $supplier_Item_Ordering_Pricing_Data
     * @param \StructType\Priority_Ranked_Supplier_Catalog_Item_JIT_Pricing_DataType[] $supplier_Item_JIT_Pricing_Data
     * @param \StructType\Catalog_Item_Data_DataType[] $pricing_History
     * @param \StructType\Supplier_Item_Advanced_Pricing_DataType[] $advanced_Pricing_Data
     */
    public function __construct($iD = null, \StructType\SupplierObjectType $supplier_Reference = null, \StructType\Supplier_ItemObjectType $supplier_Item_Reference = null, \StructType\Catalog_ItemObjectType $catalog_Item_Reference = null, $supplier_Item_Identifier = null, $item_Description = null, $sourcing_Priority = null, $item_URL = null, array $supplier_Contract_Reference = array(), \StructType\CurrencyObjectType $currency_Reference = null, $lead_Time = null, $packaging_String = null, $inactive = null, $pricing_Effective_Date = null, $calculate_Price_based_on_Conversion_Factor = null, array $supplier_Item_Ordering_Pricing_Data = array(), array $supplier_Item_JIT_Pricing_Data = array(), array $pricing_History = array(), array $advanced_Pricing_Data = array())
    {
        $this
            ->setID($iD)
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Item_Reference($supplier_Item_Reference)
            ->setCatalog_Item_Reference($catalog_Item_Reference)
            ->setSupplier_Item_Identifier($supplier_Item_Identifier)
            ->setItem_Description($item_Description)
            ->setSourcing_Priority($sourcing_Priority)
            ->setItem_URL($item_URL)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setLead_Time($lead_Time)
            ->setPackaging_String($packaging_String)
            ->setInactive($inactive)
            ->setPricing_Effective_Date($pricing_Effective_Date)
            ->setCalculate_Price_based_on_Conversion_Factor($calculate_Price_based_on_Conversion_Factor)
            ->setSupplier_Item_Ordering_Pricing_Data($supplier_Item_Ordering_Pricing_Data)
            ->setSupplier_Item_JIT_Pricing_Data($supplier_Item_JIT_Pricing_Data)
            ->setPricing_History($pricing_History)
            ->setAdvanced_Pricing_Data($advanced_Pricing_Data);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Supplier_Item_Reference value
     * @return \StructType\Supplier_ItemObjectType|null
     */
    public function getSupplier_Item_Reference()
    {
        return $this->Supplier_Item_Reference;
    }
    /**
     * Set Supplier_Item_Reference value
     * @param \StructType\Supplier_ItemObjectType $supplier_Item_Reference
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setSupplier_Item_Reference(\StructType\Supplier_ItemObjectType $supplier_Item_Reference = null)
    {
        $this->Supplier_Item_Reference = $supplier_Item_Reference;
        return $this;
    }
    /**
     * Get Catalog_Item_Reference value
     * @return \StructType\Catalog_ItemObjectType|null
     */
    public function getCatalog_Item_Reference()
    {
        return $this->Catalog_Item_Reference;
    }
    /**
     * Set Catalog_Item_Reference value
     * @param \StructType\Catalog_ItemObjectType $catalog_Item_Reference
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setCatalog_Item_Reference(\StructType\Catalog_ItemObjectType $catalog_Item_Reference = null)
    {
        $this->Catalog_Item_Reference = $catalog_Item_Reference;
        return $this;
    }
    /**
     * Get Supplier_Item_Identifier value
     * @return string|null
     */
    public function getSupplier_Item_Identifier()
    {
        return $this->Supplier_Item_Identifier;
    }
    /**
     * Set Supplier_Item_Identifier value
     * @param string $supplier_Item_Identifier
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setSupplier_Item_Identifier($supplier_Item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Item_Identifier) && !is_string($supplier_Item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Item_Identifier, true), gettype($supplier_Item_Identifier)), __LINE__);
        }
        $this->Supplier_Item_Identifier = $supplier_Item_Identifier;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Sourcing_Priority value
     * @return float|null
     */
    public function getSourcing_Priority()
    {
        return $this->Sourcing_Priority;
    }
    /**
     * Set Sourcing_Priority value
     * @param float $sourcing_Priority
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setSourcing_Priority($sourcing_Priority = null)
    {
        // validation for constraint: float
        if (!is_null($sourcing_Priority) && !(is_float($sourcing_Priority) || is_numeric($sourcing_Priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sourcing_Priority, true), gettype($sourcing_Priority)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($sourcing_Priority) && mb_strlen(mb_substr($sourcing_Priority, false !== mb_strpos($sourcing_Priority, '.') ? mb_strpos($sourcing_Priority, '.') + 1 : mb_strlen($sourcing_Priority))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($sourcing_Priority, true), mb_strlen(mb_substr($sourcing_Priority, mb_strpos($sourcing_Priority, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sourcing_Priority) && $sourcing_Priority < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sourcing_Priority, true)), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($sourcing_Priority) && mb_strlen(preg_replace('/(\D)/', '', $sourcing_Priority)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($sourcing_Priority, true), mb_strlen(preg_replace('/(\D)/', '', $sourcing_Priority))), __LINE__);
        }
        $this->Sourcing_Priority = $sourcing_Priority;
        return $this;
    }
    /**
     * Get Item_URL value
     * @return string|null
     */
    public function getItem_URL()
    {
        return $this->Item_URL;
    }
    /**
     * Set Item_URL value
     * @param string $item_URL
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setItem_URL($item_URL = null)
    {
        // validation for constraint: string
        if (!is_null($item_URL) && !is_string($item_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_URL, true), gettype($item_URL)), __LINE__);
        }
        $this->Item_URL = $item_URL;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType[]|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_ReferenceForArrayConstraintsFromSetSupplier_Contract_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priority_Ranked_Supplier_Item_DataTypeSupplier_Contract_ReferenceItem) {
            // validation for constraint: itemType
            if (!$priority_Ranked_Supplier_Item_DataTypeSupplier_Contract_ReferenceItem instanceof \StructType\Supplier_ContractObjectType) {
                $invalidValues[] = is_object($priority_Ranked_Supplier_Item_DataTypeSupplier_Contract_ReferenceItem) ? get_class($priority_Ranked_Supplier_Item_DataTypeSupplier_Contract_ReferenceItem) : sprintf('%s(%s)', gettype($priority_Ranked_Supplier_Item_DataTypeSupplier_Contract_ReferenceItem), var_export($priority_Ranked_Supplier_Item_DataTypeSupplier_Contract_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType[] $supplier_Contract_Reference
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setSupplier_Contract_Reference(array $supplier_Contract_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_ReferenceArrayErrorMessage = self::validateSupplier_Contract_ReferenceForArrayConstraintsFromSetSupplier_Contract_Reference($supplier_Contract_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType $item
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function addToSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_ContractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Reference[] = $item;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Lead_Time value
     * @return float|null
     */
    public function getLead_Time()
    {
        return $this->Lead_Time;
    }
    /**
     * Set Lead_Time value
     * @param float $lead_Time
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setLead_Time($lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($lead_Time) && !(is_float($lead_Time) || is_numeric($lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lead_Time, true), gettype($lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($lead_Time) && mb_strlen(mb_substr($lead_Time, false !== mb_strpos($lead_Time, '.') ? mb_strpos($lead_Time, '.') + 1 : mb_strlen($lead_Time))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($lead_Time, true), mb_strlen(mb_substr($lead_Time, mb_strpos($lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lead_Time) && $lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $lead_Time)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $lead_Time))), __LINE__);
        }
        $this->Lead_Time = $lead_Time;
        return $this;
    }
    /**
     * Get Packaging_String value
     * @return string|null
     */
    public function getPackaging_String()
    {
        return $this->Packaging_String;
    }
    /**
     * Set Packaging_String value
     * @param string $packaging_String
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setPackaging_String($packaging_String = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_String) && !is_string($packaging_String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_String, true), gettype($packaging_String)), __LINE__);
        }
        $this->Packaging_String = $packaging_String;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Pricing_Effective_Date value
     * @return string|null
     */
    public function getPricing_Effective_Date()
    {
        return $this->Pricing_Effective_Date;
    }
    /**
     * Set Pricing_Effective_Date value
     * @param string $pricing_Effective_Date
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setPricing_Effective_Date($pricing_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($pricing_Effective_Date) && !is_string($pricing_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricing_Effective_Date, true), gettype($pricing_Effective_Date)), __LINE__);
        }
        $this->Pricing_Effective_Date = $pricing_Effective_Date;
        return $this;
    }
    /**
     * Get Calculate_Price_based_on_Conversion_Factor value
     * @return bool|null
     */
    public function getCalculate_Price_based_on_Conversion_Factor()
    {
        return $this->Calculate_Price_based_on_Conversion_Factor;
    }
    /**
     * Set Calculate_Price_based_on_Conversion_Factor value
     * @param bool $calculate_Price_based_on_Conversion_Factor
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setCalculate_Price_based_on_Conversion_Factor($calculate_Price_based_on_Conversion_Factor = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculate_Price_based_on_Conversion_Factor) && !is_bool($calculate_Price_based_on_Conversion_Factor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculate_Price_based_on_Conversion_Factor, true), gettype($calculate_Price_based_on_Conversion_Factor)), __LINE__);
        }
        $this->Calculate_Price_based_on_Conversion_Factor = $calculate_Price_based_on_Conversion_Factor;
        return $this;
    }
    /**
     * Get Supplier_Item_Ordering_Pricing_Data value
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType[]|null
     */
    public function getSupplier_Item_Ordering_Pricing_Data()
    {
        return $this->Supplier_Item_Ordering_Pricing_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Item_Ordering_Pricing_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Item_Ordering_Pricing_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Item_Ordering_Pricing_DataForArrayConstraintsFromSetSupplier_Item_Ordering_Pricing_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priority_Ranked_Supplier_Item_DataTypeSupplier_Item_Ordering_Pricing_DataItem) {
            // validation for constraint: itemType
            if (!$priority_Ranked_Supplier_Item_DataTypeSupplier_Item_Ordering_Pricing_DataItem instanceof \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType) {
                $invalidValues[] = is_object($priority_Ranked_Supplier_Item_DataTypeSupplier_Item_Ordering_Pricing_DataItem) ? get_class($priority_Ranked_Supplier_Item_DataTypeSupplier_Item_Ordering_Pricing_DataItem) : sprintf('%s(%s)', gettype($priority_Ranked_Supplier_Item_DataTypeSupplier_Item_Ordering_Pricing_DataItem), var_export($priority_Ranked_Supplier_Item_DataTypeSupplier_Item_Ordering_Pricing_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Item_Ordering_Pricing_Data property can only contain items of type \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Item_Ordering_Pricing_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType[] $supplier_Item_Ordering_Pricing_Data
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setSupplier_Item_Ordering_Pricing_Data(array $supplier_Item_Ordering_Pricing_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Item_Ordering_Pricing_DataArrayErrorMessage = self::validateSupplier_Item_Ordering_Pricing_DataForArrayConstraintsFromSetSupplier_Item_Ordering_Pricing_Data($supplier_Item_Ordering_Pricing_Data))) {
            throw new \InvalidArgumentException($supplier_Item_Ordering_Pricing_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Item_Ordering_Pricing_Data = $supplier_Item_Ordering_Pricing_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Item_Ordering_Pricing_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType $item
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function addToSupplier_Item_Ordering_Pricing_Data(\StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Item_Ordering_Pricing_Data property can only contain items of type \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Item_Ordering_Pricing_Data[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Item_JIT_Pricing_Data value
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_JIT_Pricing_DataType[]|null
     */
    public function getSupplier_Item_JIT_Pricing_Data()
    {
        return $this->Supplier_Item_JIT_Pricing_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Item_JIT_Pricing_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Item_JIT_Pricing_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Item_JIT_Pricing_DataForArrayConstraintsFromSetSupplier_Item_JIT_Pricing_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priority_Ranked_Supplier_Item_DataTypeSupplier_Item_JIT_Pricing_DataItem) {
            // validation for constraint: itemType
            if (!$priority_Ranked_Supplier_Item_DataTypeSupplier_Item_JIT_Pricing_DataItem instanceof \StructType\Priority_Ranked_Supplier_Catalog_Item_JIT_Pricing_DataType) {
                $invalidValues[] = is_object($priority_Ranked_Supplier_Item_DataTypeSupplier_Item_JIT_Pricing_DataItem) ? get_class($priority_Ranked_Supplier_Item_DataTypeSupplier_Item_JIT_Pricing_DataItem) : sprintf('%s(%s)', gettype($priority_Ranked_Supplier_Item_DataTypeSupplier_Item_JIT_Pricing_DataItem), var_export($priority_Ranked_Supplier_Item_DataTypeSupplier_Item_JIT_Pricing_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Item_JIT_Pricing_Data property can only contain items of type \StructType\Priority_Ranked_Supplier_Catalog_Item_JIT_Pricing_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Item_JIT_Pricing_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Priority_Ranked_Supplier_Catalog_Item_JIT_Pricing_DataType[] $supplier_Item_JIT_Pricing_Data
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setSupplier_Item_JIT_Pricing_Data(array $supplier_Item_JIT_Pricing_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Item_JIT_Pricing_DataArrayErrorMessage = self::validateSupplier_Item_JIT_Pricing_DataForArrayConstraintsFromSetSupplier_Item_JIT_Pricing_Data($supplier_Item_JIT_Pricing_Data))) {
            throw new \InvalidArgumentException($supplier_Item_JIT_Pricing_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Item_JIT_Pricing_Data = $supplier_Item_JIT_Pricing_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Item_JIT_Pricing_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Priority_Ranked_Supplier_Catalog_Item_JIT_Pricing_DataType $item
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function addToSupplier_Item_JIT_Pricing_Data(\StructType\Priority_Ranked_Supplier_Catalog_Item_JIT_Pricing_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Priority_Ranked_Supplier_Catalog_Item_JIT_Pricing_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Item_JIT_Pricing_Data property can only contain items of type \StructType\Priority_Ranked_Supplier_Catalog_Item_JIT_Pricing_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Item_JIT_Pricing_Data[] = $item;
        return $this;
    }
    /**
     * Get Pricing_History value
     * @return \StructType\Catalog_Item_Data_DataType[]|null
     */
    public function getPricing_History()
    {
        return $this->Pricing_History;
    }
    /**
     * This method is responsible for validating the values passed to the setPricing_History method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricing_History method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricing_HistoryForArrayConstraintsFromSetPricing_History(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priority_Ranked_Supplier_Item_DataTypePricing_HistoryItem) {
            // validation for constraint: itemType
            if (!$priority_Ranked_Supplier_Item_DataTypePricing_HistoryItem instanceof \StructType\Catalog_Item_Data_DataType) {
                $invalidValues[] = is_object($priority_Ranked_Supplier_Item_DataTypePricing_HistoryItem) ? get_class($priority_Ranked_Supplier_Item_DataTypePricing_HistoryItem) : sprintf('%s(%s)', gettype($priority_Ranked_Supplier_Item_DataTypePricing_HistoryItem), var_export($priority_Ranked_Supplier_Item_DataTypePricing_HistoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pricing_History property can only contain items of type \StructType\Catalog_Item_Data_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pricing_History value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_Data_DataType[] $pricing_History
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setPricing_History(array $pricing_History = array())
    {
        // validation for constraint: array
        if ('' !== ($pricing_HistoryArrayErrorMessage = self::validatePricing_HistoryForArrayConstraintsFromSetPricing_History($pricing_History))) {
            throw new \InvalidArgumentException($pricing_HistoryArrayErrorMessage, __LINE__);
        }
        $this->Pricing_History = $pricing_History;
        return $this;
    }
    /**
     * Add item to Pricing_History value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_Data_DataType $item
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function addToPricing_History(\StructType\Catalog_Item_Data_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Item_Data_DataType) {
            throw new \InvalidArgumentException(sprintf('The Pricing_History property can only contain items of type \StructType\Catalog_Item_Data_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pricing_History[] = $item;
        return $this;
    }
    /**
     * Get Advanced_Pricing_Data value
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType[]|null
     */
    public function getAdvanced_Pricing_Data()
    {
        return $this->Advanced_Pricing_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdvanced_Pricing_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdvanced_Pricing_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdvanced_Pricing_DataForArrayConstraintsFromSetAdvanced_Pricing_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priority_Ranked_Supplier_Item_DataTypeAdvanced_Pricing_DataItem) {
            // validation for constraint: itemType
            if (!$priority_Ranked_Supplier_Item_DataTypeAdvanced_Pricing_DataItem instanceof \StructType\Supplier_Item_Advanced_Pricing_DataType) {
                $invalidValues[] = is_object($priority_Ranked_Supplier_Item_DataTypeAdvanced_Pricing_DataItem) ? get_class($priority_Ranked_Supplier_Item_DataTypeAdvanced_Pricing_DataItem) : sprintf('%s(%s)', gettype($priority_Ranked_Supplier_Item_DataTypeAdvanced_Pricing_DataItem), var_export($priority_Ranked_Supplier_Item_DataTypeAdvanced_Pricing_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Advanced_Pricing_Data property can only contain items of type \StructType\Supplier_Item_Advanced_Pricing_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Advanced_Pricing_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Advanced_Pricing_DataType[] $advanced_Pricing_Data
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function setAdvanced_Pricing_Data(array $advanced_Pricing_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($advanced_Pricing_DataArrayErrorMessage = self::validateAdvanced_Pricing_DataForArrayConstraintsFromSetAdvanced_Pricing_Data($advanced_Pricing_Data))) {
            throw new \InvalidArgumentException($advanced_Pricing_DataArrayErrorMessage, __LINE__);
        }
        $this->Advanced_Pricing_Data = $advanced_Pricing_Data;
        return $this;
    }
    /**
     * Add item to Advanced_Pricing_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Advanced_Pricing_DataType $item
     * @return \StructType\Priority_Ranked_Supplier_Item_DataType
     */
    public function addToAdvanced_Pricing_Data(\StructType\Supplier_Item_Advanced_Pricing_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Item_Advanced_Pricing_DataType) {
            throw new \InvalidArgumentException(sprintf('The Advanced_Pricing_Data property can only contain items of type \StructType\Supplier_Item_Advanced_Pricing_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Advanced_Pricing_Data[] = $item;
        return $this;
    }
}
