<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Patient_Charge_Information_Row_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Patient Charge Information Row Data instance.
 * @subpackage Structs
 */
class Patient_Charge_Information_Row_DataType extends AbstractStructBase
{
    /**
     * The Patient_Charge_Information_Reference
     * Meta information extracted from the WSDL
     * - documentation: Patient Charge Information Row Data instance.
     * - minOccurs: 0
     * @var \StructType\Patient_Charge_InformationObjectType
     */
    public $Patient_Charge_Information_Reference;
    /**
     * The Patient_Charge_ID
     * Meta information extracted from the WSDL
     * - documentation: Patient Charge ID. This is the Patient Charge unique identifier.
     * - minOccurs: 0
     * @var string
     */
    public $Patient_Charge_ID;
    /**
     * The CDM
     * Meta information extracted from the WSDL
     * - documentation: CDM Value
     * - maxOccurs: 1
     * @var string
     */
    public $CDM;
    /**
     * The Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refers to existing Company associated with the Patient Charge Information
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType
     */
    public $Organization_Reference;
    /**
     * The Revenue_Center_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refers to existing Revenue Center associated with the Patient Charge Information
     * - minOccurs: 0
     * @var \StructType\Revenue_CenterObjectType
     */
    public $Revenue_Center_Reference;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If True is entered, the Patient Charge Information for the supplied Purchase Item reference will be deleted.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Patient_Charge_Information_Row_DataType
     * @uses Patient_Charge_Information_Row_DataType::setPatient_Charge_Information_Reference()
     * @uses Patient_Charge_Information_Row_DataType::setPatient_Charge_ID()
     * @uses Patient_Charge_Information_Row_DataType::setCDM()
     * @uses Patient_Charge_Information_Row_DataType::setOrganization_Reference()
     * @uses Patient_Charge_Information_Row_DataType::setRevenue_Center_Reference()
     * @uses Patient_Charge_Information_Row_DataType::setDelete()
     * @param \StructType\Patient_Charge_InformationObjectType $patient_Charge_Information_Reference
     * @param string $patient_Charge_ID
     * @param string $cDM
     * @param \StructType\OrganizationObjectType $organization_Reference
     * @param \StructType\Revenue_CenterObjectType $revenue_Center_Reference
     * @param bool $delete
     */
    public function __construct(\StructType\Patient_Charge_InformationObjectType $patient_Charge_Information_Reference = null, $patient_Charge_ID = null, $cDM = null, \StructType\OrganizationObjectType $organization_Reference = null, \StructType\Revenue_CenterObjectType $revenue_Center_Reference = null, $delete = null)
    {
        $this
            ->setPatient_Charge_Information_Reference($patient_Charge_Information_Reference)
            ->setPatient_Charge_ID($patient_Charge_ID)
            ->setCDM($cDM)
            ->setOrganization_Reference($organization_Reference)
            ->setRevenue_Center_Reference($revenue_Center_Reference)
            ->setDelete($delete);
    }
    /**
     * Get Patient_Charge_Information_Reference value
     * @return \StructType\Patient_Charge_InformationObjectType|null
     */
    public function getPatient_Charge_Information_Reference()
    {
        return $this->Patient_Charge_Information_Reference;
    }
    /**
     * Set Patient_Charge_Information_Reference value
     * @param \StructType\Patient_Charge_InformationObjectType $patient_Charge_Information_Reference
     * @return \StructType\Patient_Charge_Information_Row_DataType
     */
    public function setPatient_Charge_Information_Reference(\StructType\Patient_Charge_InformationObjectType $patient_Charge_Information_Reference = null)
    {
        $this->Patient_Charge_Information_Reference = $patient_Charge_Information_Reference;
        return $this;
    }
    /**
     * Get Patient_Charge_ID value
     * @return string|null
     */
    public function getPatient_Charge_ID()
    {
        return $this->Patient_Charge_ID;
    }
    /**
     * Set Patient_Charge_ID value
     * @param string $patient_Charge_ID
     * @return \StructType\Patient_Charge_Information_Row_DataType
     */
    public function setPatient_Charge_ID($patient_Charge_ID = null)
    {
        // validation for constraint: string
        if (!is_null($patient_Charge_ID) && !is_string($patient_Charge_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patient_Charge_ID, true), gettype($patient_Charge_ID)), __LINE__);
        }
        $this->Patient_Charge_ID = $patient_Charge_ID;
        return $this;
    }
    /**
     * Get CDM value
     * @return string|null
     */
    public function getCDM()
    {
        return $this->CDM;
    }
    /**
     * Set CDM value
     * @param string $cDM
     * @return \StructType\Patient_Charge_Information_Row_DataType
     */
    public function setCDM($cDM = null)
    {
        // validation for constraint: string
        if (!is_null($cDM) && !is_string($cDM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cDM, true), gettype($cDM)), __LINE__);
        }
        $this->CDM = $cDM;
        return $this;
    }
    /**
     * Get Organization_Reference value
     * @return \StructType\OrganizationObjectType|null
     */
    public function getOrganization_Reference()
    {
        return $this->Organization_Reference;
    }
    /**
     * Set Organization_Reference value
     * @param \StructType\OrganizationObjectType $organization_Reference
     * @return \StructType\Patient_Charge_Information_Row_DataType
     */
    public function setOrganization_Reference(\StructType\OrganizationObjectType $organization_Reference = null)
    {
        $this->Organization_Reference = $organization_Reference;
        return $this;
    }
    /**
     * Get Revenue_Center_Reference value
     * @return \StructType\Revenue_CenterObjectType|null
     */
    public function getRevenue_Center_Reference()
    {
        return $this->Revenue_Center_Reference;
    }
    /**
     * Set Revenue_Center_Reference value
     * @param \StructType\Revenue_CenterObjectType $revenue_Center_Reference
     * @return \StructType\Patient_Charge_Information_Row_DataType
     */
    public function setRevenue_Center_Reference(\StructType\Revenue_CenterObjectType $revenue_Center_Reference = null)
    {
        $this->Revenue_Center_Reference = $revenue_Center_Reference;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Patient_Charge_Information_Row_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
