<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Override_Depreciation_Period_Status_Data_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element for Override Depreciation Period Status Data Response.
 * @subpackage Structs
 */
class Override_Depreciation_Period_Status_Data_ResponseType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Business Asset that will be processed.
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Asset_Book_Reference
     * Meta information extracted from the WSDL
     * - documentation: List of all the Books that were processed. This list may be different from the Input list as not All books specified on the Input Request Message will be processed.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Asset_Book_Reference;
    /**
     * The Clear_Accounted_Status
     * Meta information extracted from the WSDL
     * - documentation: This field is displayed if the Clear Accounted Date field is set to 1 on the Request message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Clear_Accounted_Status;
    /**
     * The Installment_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: This message is displayed when the Installment On or Before date on the Request message is selected.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Installment_Date_On_or_Before;
    /**
     * Constructor method for Override_Depreciation_Period_Status_Data_ResponseType
     * @uses Override_Depreciation_Period_Status_Data_ResponseType::setAsset_Reference()
     * @uses Override_Depreciation_Period_Status_Data_ResponseType::setAsset_Book_Reference()
     * @uses Override_Depreciation_Period_Status_Data_ResponseType::setClear_Accounted_Status()
     * @uses Override_Depreciation_Period_Status_Data_ResponseType::setInstallment_Date_On_or_Before()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param \StructType\Asset_BookObjectType[] $asset_Book_Reference
     * @param bool $clear_Accounted_Status
     * @param string $installment_Date_On_or_Before
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, array $asset_Book_Reference = array(), $clear_Accounted_Status = null, $installment_Date_On_or_Before = null)
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setAsset_Book_Reference($asset_Book_Reference)
            ->setClear_Accounted_Status($clear_Accounted_Status)
            ->setInstallment_Date_On_or_Before($installment_Date_On_or_Before);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Override_Depreciation_Period_Status_Data_ResponseType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Asset_Book_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getAsset_Book_Reference()
    {
        return $this->Asset_Book_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Book_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Book_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Book_ReferenceForArrayConstraintsFromSetAsset_Book_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $override_Depreciation_Period_Status_Data_ResponseTypeAsset_Book_ReferenceItem) {
            // validation for constraint: itemType
            if (!$override_Depreciation_Period_Status_Data_ResponseTypeAsset_Book_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($override_Depreciation_Period_Status_Data_ResponseTypeAsset_Book_ReferenceItem) ? get_class($override_Depreciation_Period_Status_Data_ResponseTypeAsset_Book_ReferenceItem) : sprintf('%s(%s)', gettype($override_Depreciation_Period_Status_Data_ResponseTypeAsset_Book_ReferenceItem), var_export($override_Depreciation_Period_Status_Data_ResponseTypeAsset_Book_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Book_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Book_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $asset_Book_Reference
     * @return \StructType\Override_Depreciation_Period_Status_Data_ResponseType
     */
    public function setAsset_Book_Reference(array $asset_Book_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Book_ReferenceArrayErrorMessage = self::validateAsset_Book_ReferenceForArrayConstraintsFromSetAsset_Book_Reference($asset_Book_Reference))) {
            throw new \InvalidArgumentException($asset_Book_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Book_Reference = $asset_Book_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Book_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Override_Depreciation_Period_Status_Data_ResponseType
     */
    public function addToAsset_Book_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Book_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Book_Reference[] = $item;
        return $this;
    }
    /**
     * Get Clear_Accounted_Status value
     * @return bool|null
     */
    public function getClear_Accounted_Status()
    {
        return $this->Clear_Accounted_Status;
    }
    /**
     * Set Clear_Accounted_Status value
     * @param bool $clear_Accounted_Status
     * @return \StructType\Override_Depreciation_Period_Status_Data_ResponseType
     */
    public function setClear_Accounted_Status($clear_Accounted_Status = null)
    {
        // validation for constraint: boolean
        if (!is_null($clear_Accounted_Status) && !is_bool($clear_Accounted_Status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($clear_Accounted_Status, true), gettype($clear_Accounted_Status)), __LINE__);
        }
        $this->Clear_Accounted_Status = $clear_Accounted_Status;
        return $this;
    }
    /**
     * Get Installment_Date_On_or_Before value
     * @return string|null
     */
    public function getInstallment_Date_On_or_Before()
    {
        return $this->Installment_Date_On_or_Before;
    }
    /**
     * Set Installment_Date_On_or_Before value
     * @param string $installment_Date_On_or_Before
     * @return \StructType\Override_Depreciation_Period_Status_Data_ResponseType
     */
    public function setInstallment_Date_On_or_Before($installment_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($installment_Date_On_or_Before) && !is_string($installment_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installment_Date_On_or_Before, true), gettype($installment_Date_On_or_Before)), __LINE__);
        }
        $this->Installment_Date_On_or_Before = $installment_Date_On_or_Before;
        return $this;
    }
}
