<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Note_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Includes Notes that have been made for a business object. On a Get operation, all existing Notes will be populated. On a Put or Submit operation, any note information on the request will be added as new notes. Existing notes cannot
 * be updated on a Put or Submit request.
 * @subpackage Structs
 */
class Note_WWS_DataType extends AbstractStructBase
{
    /**
     * The Created
     * Meta information extracted from the WSDL
     * - documentation: The date and time this Note was created. On a Put or Submit operation, this field is ignored, and will be overwritten with the current date and time.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Created;
    /**
     * The Last_Updated
     * Meta information extracted from the WSDL
     * - documentation: The date and time this Note was last updated. On a Put or Submit operation, this field is ignored, and will be overwritten with the current date and time.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Updated;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worker who created this Note (if the person who created it is a Worker). On a Put or Submit operation, this field is ignored, and will be overwritten by the person processing the request.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Business_Entity_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Business Entity Contact who created this Note (if the person who created it is a Business Entity Contact and not a Worker). On a Put or Submit operation, this field is ignored, and will be overwritten with the person processing
     * the request.
     * - minOccurs: 0
     * @var \StructType\Business_Entity_ContactObjectType
     */
    public $Business_Entity_Contact_Reference;
    /**
     * The System_User_Reference
     * Meta information extracted from the WSDL
     * - documentation: The System User who created this Note (if the person who created it is neither a Business Entity Contact nor a Worker). On a Put or Submit operation, this field is ignored, and will be overwritten with the person processing the
     * request.
     * - minOccurs: 0
     * @var \StructType\System_UserObjectType
     */
    public $System_User_Reference;
    /**
     * The Note_Content
     * Meta information extracted from the WSDL
     * - documentation: The main text content for this Note.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note_Content;
    /**
     * Constructor method for Note_WWS_DataType
     * @uses Note_WWS_DataType::setCreated()
     * @uses Note_WWS_DataType::setLast_Updated()
     * @uses Note_WWS_DataType::setWorker_Reference()
     * @uses Note_WWS_DataType::setBusiness_Entity_Contact_Reference()
     * @uses Note_WWS_DataType::setSystem_User_Reference()
     * @uses Note_WWS_DataType::setNote_Content()
     * @param string $created
     * @param string $last_Updated
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference
     * @param \StructType\System_UserObjectType $system_User_Reference
     * @param string $note_Content
     */
    public function __construct($created = null, $last_Updated = null, \StructType\WorkerObjectType $worker_Reference = null, \StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference = null, \StructType\System_UserObjectType $system_User_Reference = null, $note_Content = null)
    {
        $this
            ->setCreated($created)
            ->setLast_Updated($last_Updated)
            ->setWorker_Reference($worker_Reference)
            ->setBusiness_Entity_Contact_Reference($business_Entity_Contact_Reference)
            ->setSystem_User_Reference($system_User_Reference)
            ->setNote_Content($note_Content);
    }
    /**
     * Get Created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\Note_WWS_DataType
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created, true), gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Last_Updated value
     * @return string|null
     */
    public function getLast_Updated()
    {
        return $this->Last_Updated;
    }
    /**
     * Set Last_Updated value
     * @param string $last_Updated
     * @return \StructType\Note_WWS_DataType
     */
    public function setLast_Updated($last_Updated = null)
    {
        // validation for constraint: string
        if (!is_null($last_Updated) && !is_string($last_Updated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Updated, true), gettype($last_Updated)), __LINE__);
        }
        $this->Last_Updated = $last_Updated;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Note_WWS_DataType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Business_Entity_Contact_Reference value
     * @return \StructType\Business_Entity_ContactObjectType|null
     */
    public function getBusiness_Entity_Contact_Reference()
    {
        return $this->Business_Entity_Contact_Reference;
    }
    /**
     * Set Business_Entity_Contact_Reference value
     * @param \StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference
     * @return \StructType\Note_WWS_DataType
     */
    public function setBusiness_Entity_Contact_Reference(\StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference = null)
    {
        $this->Business_Entity_Contact_Reference = $business_Entity_Contact_Reference;
        return $this;
    }
    /**
     * Get System_User_Reference value
     * @return \StructType\System_UserObjectType|null
     */
    public function getSystem_User_Reference()
    {
        return $this->System_User_Reference;
    }
    /**
     * Set System_User_Reference value
     * @param \StructType\System_UserObjectType $system_User_Reference
     * @return \StructType\Note_WWS_DataType
     */
    public function setSystem_User_Reference(\StructType\System_UserObjectType $system_User_Reference = null)
    {
        $this->System_User_Reference = $system_User_Reference;
        return $this;
    }
    /**
     * Get Note_Content value
     * @return string|null
     */
    public function getNote_Content()
    {
        return $this->Note_Content;
    }
    /**
     * Set Note_Content value
     * @param string $note_Content
     * @return \StructType\Note_WWS_DataType
     */
    public function setNote_Content($note_Content = null)
    {
        // validation for constraint: string
        if (!is_null($note_Content) && !is_string($note_Content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note_Content, true), gettype($note_Content)), __LINE__);
        }
        $this->Note_Content = $note_Content;
        return $this;
    }
}
